/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class DataProccessRecordDao
extends AbstractDao<DataProcessRecord> {
    public DataProccessRecordDao(Connection con, int mid) {
        super(con, mid, "voice_process_task");
    }

    protected DataProcessRecord getFromRS(ResultSet rs) throws SQLException, BGException {
        return new DataProcessRecord().setDeviceId(rs.getInt("deviceId")).setDay((Date)rs.getDate("day")).setCurrentHour(rs.getByte("currentHour")).setRadius(rs.getBoolean("radius"));
    }

    protected void updateImpl(DataProcessRecord dataProcessRecord) throws BGException, SQLException {
        String query = "REPLACE INTO " + this.tableName + " SET deviceId=?, day=?, currentHour=?, radius=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, dataProcessRecord.getDeviceId());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dataProcessRecord.getDay()));
            ps.setByte(3, dataProcessRecord.getCurrentHour());
            ps.setBoolean(4, dataProcessRecord.isRadius());
            ps.executeUpdate();
        }
    }

    public List<DataProcessRecord> list(int deviceId, Date dateFrom, Date dateTo) throws BGException {
        return super.list("deviceId=? AND day >= ? AND day < ? ", "day", new Object[]{deviceId, dateFrom, dateTo});
    }

    public void delete(int deviceId, List<Date> days) throws BGException {
        try {
            if (days == null || days.size() == 0) {
                return;
            }
            StringBuilder query = new StringBuilder();
            query.append(" DELETE FROM " + this.tableName + " WHERE deviceId = ? AND day IN (");
            for (int i = 0; i < days.size(); ++i) {
                query.append("?");
                if (i == days.size() - 1) continue;
                query.append(",");
            }
            query.append(" )");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int idx = 1;
            ps.setInt(idx++, deviceId);
            for (int i = 0; i < days.size(); ++i) {
                ps.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)days.get(i)));
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<DataProcessRecord> list(boolean isRadius) throws BGException {
        return super.list("radius=?", "day", new Object[]{isRadius});
    }

    public List<DataProcessRecord> listTest() throws BGException {
        ArrayList<DataProcessRecord> result = new ArrayList<DataProcessRecord>();
        DataProcessRecord record = new DataProcessRecord().setDeviceId(1).setDay(TimeUtils.parseDate((String)"01.09.2007 00", (String)"dd.MM.yyyy HH"));
        result.add(record);
        record = new DataProcessRecord().setDeviceId(1).setDay(TimeUtils.parseDate((String)"01.09.2007", (String)"dd.MM.yyyy"));
        result.add(record);
        record = new DataProcessRecord().setDeviceId(1).setDay(TimeUtils.parseDate((String)"01.09.2007", (String)"dd.MM.yyyy"));
        result.add(record);
        return result;
    }
}

