/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.common.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactItem;

public class CustomerContact {
    private List<CustomerContactItem> phoneList = new ArrayList<CustomerContactItem>();
    private List<CustomerContactItem> mobileList = new ArrayList<CustomerContactItem>();
    private List<CustomerContactItem> emailList = new ArrayList<CustomerContactItem>();

    public List<CustomerContactItem> getPhoneList() {
        return this.phoneList;
    }

    public List<CustomerContactItem> getMobileList() {
        return this.mobileList;
    }

    public List<CustomerContactItem> getEmailList() {
        return this.emailList;
    }

    public CustomerContact setPhoneList(List<CustomerContactItem> phoneList) {
        this.phoneList = phoneList;
        return this;
    }

    public CustomerContact setMobileList(List<CustomerContactItem> mobileList) {
        this.mobileList = mobileList;
        return this;
    }

    public CustomerContact setEmailList(List<CustomerContactItem> emailList) {
        this.emailList = emailList;
        return this;
    }

    public static CustomerContact fromJson(JSONObject json) {
        Objects.requireNonNull(json);
        JSONArray phone = Optional.ofNullable(json.optJSONArray("phone")).orElse(new JSONArray());
        JSONArray mobile = Optional.ofNullable(json.optJSONArray("mobile")).orElse(new JSONArray());
        JSONArray email = Optional.ofNullable(json.optJSONArray("email")).orElse(new JSONArray());
        return new CustomerContact().setPhoneList(CustomerContact.toCustomerContactItemList(phone)).setMobileList(CustomerContact.toCustomerContactItemList(mobile)).setEmailList(CustomerContact.toCustomerContactItemList(email));
    }

    private static List<CustomerContactItem> toCustomerContactItemList(JSONArray array) {
        ArrayList<CustomerContactItem> contactItems = new ArrayList<CustomerContactItem>();
        for (int index = 0; index < array.length(); ++index) {
            JSONObject j = array.getJSONObject(index);
            contactItems.add(new CustomerContactItem().setName(j.optString("name")).setValue(j.optString("value")));
        }
        return contactItems;
    }
}

