/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.common.VersionInfo;
import bitel.billing.module.admin.TransferManager;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class Updater {
    private static final String module = "installer";

    public static boolean updateModules(boolean force) {
        boolean result = false;
        for (String modulename : Updater.needInstallList(force)) {
            try {
                result = Updater.installModule(modulename);
                if (result) continue;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            break;
        }
        return result;
    }

    private static Vector<String> needInstallList(boolean force) {
        Vector<String> result = new Vector<String>();
        Request request = new Request();
        request.setModule(module);
        request.setAction("GetInstalledModules");
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            try {
                String clientVersionNumber;
                boolean nocheckversions = false;
                String serverVersionNumber = XMLUtils.selectText(doc, "/data/installed_modules/@serverversion");
                if (serverVersionNumber != null && !(clientVersionNumber = VersionInfo.getVersionInfo("client").getVersion()).equals(serverVersionNumber)) {
                    if (!ClientUtils.confirm("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \"" + clientVersionNumber + "\" \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \"" + serverVersionNumber + "\"\n\u0422\u0430\u043a\u043e\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f. \u0416\u0435\u043b\u0430\u0435\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043d\u0430 \u0441\u0432\u043e\u0439 \u0441\u0442\u0440\u0430\u0445 \u0438 \u0440\u0438\u0441\u043a?", "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435")) {
                        return new Vector<String>();
                    }
                    nocheckversions = true;
                }
                for (Element item : XMLUtils.selectElements(doc, "/data/installed_modules/item")) {
                    String name = item.getAttribute("name");
                    String moduleName = item.getAttribute("module_name");
                    String version = item.getAttribute("version");
                    String build = item.getAttribute("build");
                    VersionInfo vi = VersionInfo.getVersionInfo(name);
                    if (force || Utils.isBlankString(vi.getVersion())) {
                        result.add(moduleName);
                        continue;
                    }
                    if (!vi.getVersion().equals(version)) {
                        if (!nocheckversions && !ClientUtils.confirm("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043c\u043e\u0434\u0443\u043b\u044f " + name + " \"" + vi.getVersion() + "\" \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \"" + version + "\". \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c?", "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435")) continue;
                        result.add(moduleName);
                        continue;
                    }
                    if (vi.getBuildNumber().equals(build) || Utils.parseInt(build) <= Utils.parseInt(vi.getBuildNumber()) && !ClientUtils.confirm("\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0441\u0431\u043e\u0440\u043a\u0430 \u043c\u043e\u0434\u0443\u043b\u044f " + name + " \"" + vi.getBuildNumber() + "\" \u043d\u043e\u0432\u0435\u0435 \u0441\u0431\u043e\u0440\u043a\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \"" + build + "\". \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0430 \u0431\u043e\u043b\u0435\u0435 \u0441\u0442\u0430\u0440\u044b\u0439 \u0431\u0438\u043b\u0434?", "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435")) continue;
                    result.add(moduleName);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean installModule(String name) throws Exception {
        boolean result = false;
        File libs = new File(System.getProperty("update.folder", "lib.update"));
        if (libs.exists() && libs.isDirectory() && libs.canWrite() || libs.mkdir()) {
            Window waitwindow = null;
            try {
                waitwindow = ClientUtils.showWaitWindow(String.format("Install module %s...", name));
                String libPath = libs.getAbsolutePath();
                Request request = new Request();
                request.setModule(module);
                request.setAction("GetClientPacket");
                request.setAttribute("contentType", "binary");
                request.setAttribute("module_name", name);
                ZipInputStream zis = new ZipInputStream(TransferManager.getInputStream(request));
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    byte[] jar = Utils.readByBlock(zis);
                    FileOutputStream fos = new FileOutputStream(libPath + File.separator + ze.getName());
                    fos.write(jar);
                    fos.close();
                }
                zis.close();
                result = true;
            }
            finally {
                waitwindow.dispose();
            }
        } else {
            String message = "Error setup module " + name + " can't find or create or access path (" + libs.getAbsolutePath() + ") to lib.";
            ClientUtils.showErrorMessageDialog(message);
            System.err.println(message);
        }
        return result;
    }

    public static void performUpdate(boolean force) {
        if (Updater.updateModules(force)) {
            if (ClientSetup.getInstance().getBoolean("shared.client.distribution", false)) {
                try {
                    Updater.markAllAsUpdated();
                }
                catch (IOException ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
            ClientUtils.showMessageDialog("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.");
            BGClientBase.close(true);
        } else if (force) {
            ClientUtils.showMessageDialog("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e.");
        }
    }

    private static void markAllAsUpdated() throws IOException {
        for (File f : new File("instances").listFiles()) {
            if (!f.isFile()) continue;
            FileWriter w = new FileWriter(f, false);
            w.write("1");
            w.flush();
            w.close();
        }
    }

    public static void addInstanceFile() throws IOException {
        String uniqueName = InetAddress.getLocalHost().getHostName();
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        while (ifaces.hasMoreElements()) {
            NetworkInterface current = ifaces.nextElement();
            if (current.isLoopback() || !current.isUp()) continue;
            uniqueName = Utils.bytesToHexString(current.getHardwareAddress());
            break;
        }
        final File instanceFile = new File("instances", uniqueName);
        instanceFile.delete();
        instanceFile.createNewFile();
        instanceFile.deleteOnExit();
        Thread instanceFileListener = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (!instanceFile.exists() || !instanceFile.canRead()) {
                            continue;
                        }
                        BufferedReader reader = new BufferedReader(new FileReader(instanceFile));
                        String line = reader.readLine();
                        reader.close();
                        if (line != null && Utils.parseBoolean(line)) {
                            Updater.restartShellFrame();
                            break;
                        }
                        Thread.sleep(10000L);
                    }
                }
                catch (Throwable ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        instanceFileListener.start();
    }

    private static void restartShellFrame() {
        ClientUtils.showMessageDialog("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430  \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430.");
        BGClientBase.close(true);
    }
}

