/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.action.pub;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.FiasConfigUtil;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationFinder;
import ru.bitel.bgbilling.plugins.fias.server.action.pub.ActionGetAbonentBase;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;

public class ActionGetAbonentInfo
extends ActionGetAbonentBase {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Document BuildResponseXML(String numberForAnswer, LocationFinder.AddressData addressData) throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
            Contract contract;
            Element aiAbonentInfo;
            Document doc;
            block13: {
                Element resultDescription;
                block14: {
                    Element resultCode;
                    block12: {
                        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                        dFactory.setNamespaceAware(true);
                        DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                        doc = docBuilder.newDocument();
                        Element rootNode = doc.createElement("response");
                        doc.appendChild(rootNode);
                        rootNode.setAttribute("xsi:noNamespaceSchemaLocation", "pull_response.xsd");
                        rootNode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLScgema-instance");
                        rootNode.setAttribute("xmlns:ai", "http://www.svetets.ru/AbonentInfo");
                        resultCode = XMLUtils.createElement((Element)rootNode, (String)"resultCode");
                        resultDescription = XMLUtils.createElement((Element)rootNode, (String)"resultDescription");
                        if (addressData == null || addressData.getCid() <= 0) break block12;
                        resultCode.setTextContent("0");
                        aiAbonentInfo = XMLUtils.createElement((Element)rootNode, (String)"ai:AbonentInfo");
                        this.cid = addressData.getCid();
                        contract = (Contract)contractDao.get(this.cid);
                        if (contract != null) break block13;
                        break block14;
                    }
                    resultCode.setTextContent("4");
                    resultDescription.setTextContent("UNKNOWN SUBSCRIBER");
                    Document document = doc;
                    return document;
                }
                this.getLogger().error("ERROR Contract find {}", (Object)addressData);
                resultDescription.setTextContent(addressData.toString());
                Document document = doc;
                return document;
            }
            if (contract.getPersonType() == 0) {
                Element aiPerson = XMLUtils.createElement((Element)aiAbonentInfo, (String)"ai:person");
                EntityAttr name = contractDao.getContractParameter(this.cid, FiasConfigUtil.getNamePid((boolean)true));
                Element aiName = XMLUtils.createElement((Element)aiPerson, (String)"ai:name");
                aiName.setTextContent(name.toString());
                Element aiSecondName = XMLUtils.createElement((Element)aiPerson, (String)"ai:secondName");
                EntityAttr secondName = contractDao.getContractParameter(this.cid, FiasConfigUtil.getSecondNamePid((boolean)true));
                aiSecondName.setTextContent(secondName.toString());
                Element aiLastName = XMLUtils.createElement((Element)aiPerson, (String)"ai:surname");
                EntityAttr lastName = contractDao.getContractParameter(this.cid, FiasConfigUtil.getLastNamePid((boolean)true));
                aiLastName.setTextContent(lastName.toString());
                Element aiAddress = XMLUtils.createElement((Element)aiPerson, (String)"ai:address");
                EntityAttr address = contractDao.getContractParameter(this.cid, FiasConfigUtil.getAddressPid((boolean)true));
                aiAddress.setTextContent(address.toString());
                Element aiBirthDate = XMLUtils.createElement((Element)aiPerson, (String)"ai:birthDate");
                EntityAttr bDate = contractDao.getContractParameter(this.cid, FiasConfigUtil.getDobAsTextPid());
                if (bDate == null) {
                    bDate = contractDao.getContractParameter(this.cid, FiasConfigUtil.getDobAsDatePid());
                }
                aiBirthDate.setTextContent(bDate.toString());
            } else {
                Element aiOrganization = XMLUtils.createElement((Element)aiAbonentInfo, (String)"ai:organization");
                EntityAttr name = contractDao.getContractParameter(this.cid, FiasConfigUtil.getNamePid((boolean)false));
                Element aiName = XMLUtils.createElement((Element)aiOrganization, (String)"ai:name");
                aiName.setTextContent(name.toString());
                Element aiAddress = XMLUtils.createElement((Element)aiOrganization, (String)"ai:address");
                EntityAttr address = contractDao.getContractParameter(this.cid, FiasConfigUtil.getAddressPid((boolean)true));
                aiAddress.setTextContent(address.toString());
            }
            Document document = doc;
            return document;
        }
        catch (Exception ex) {
            throw new BGException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }
}

