/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.processor.LC_LimitChecker;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.Closeable;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.StopableThread;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class TariffOptionWatcher
extends StopableThread {
    private static final Logger log = LogManager.getLogger();
    private static final int SLEEP_TIME = 5000;
    private DialUpNas nas;
    private Map<Integer, Set<Integer>> lastOptionsMap = new HashMap<Integer, Set<Integer>>();

    public TariffOptionWatcher(DialUpNas nas) {
        this.nas = nas;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("Starting TariffOptionWatcher for " + String.valueOf((Object)this.nas));
        RadiusSetup setup = RadiusSetup.getSetup();
        ServerContext context = new ServerContext((Setup)setup, setup.getModuleId(), 0);
        ThreadContext parentContext = ServerContext.push((ThreadContext)context);
        try {
            while (this.working) {
                try {
                    this.runImpl(setup, context);
                }
                finally {
                    context.recycle();
                }
                try {
                    TariffOptionWatcher.sleep((long)5000L);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
        }
        log.info("Stopping TariffOptionWatcher for " + String.valueOf((Object)this.nas));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl(RadiusSetup setup, ServerContext context) {
        try {
            ConnectionSet connectionSet = context.getConnectionSet();
            HashMap<Integer, Set<Integer>> currentOptions = new HashMap<Integer, Set<Integer>>();
            Date now = new Date();
            for (DialUpNasConnection nasCon : this.nas.connections()) {
                DialUpSessionRealtime session = (DialUpSessionRealtime)nasCon.getSession();
                if (session.isFakeSession() || nasCon.getStatus() == NasConnection.Status.waiting) continue;
                Contract contract = session.getContract();
                Set options = contract.getTariffOptions().items(now.getTime(), now.getTime());
                currentOptions.put(contract.getId(), options);
                Set<Integer> prevOptions = this.lastOptionsMap.get(contract.getId());
                if (prevOptions == null || CollectionUtils.isEqualCollection(prevOptions, (Collection)options)) continue;
                DialUpNasConnection dialUpNasConnection = nasCon;
                synchronized (dialUpNasConnection) {
                    session.addLogInfo("Tariff option set was changed.");
                    session.setStopTime(new GregorianCalendar());
                    if (!session.calculate(setup, (Closeable)((Object)nasCon), connectionSet.getConnection(), LC_LimitChecker.getLimitChecker(), true)) {
                        nasCon.kill(this.nas);
                    }
                }
            }
            this.lastOptionsMap = currentOptions;
            context.commit();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

