/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.GraduallySubscription;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class GraduallySubscriptionManager
extends AbstractDao<GraduallySubscription> {
    public GraduallySubscriptionManager(Connection con, int mid) {
        super(con, mid, "cerbercrypt_gradually_subscription");
    }

    protected GraduallySubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        GraduallySubscription entry = new GraduallySubscription();
        entry.setEntityId(rs.getInt("entityId"));
        entry.setDate((Date)rs.getDate("date"));
        return entry;
    }

    protected void updateImpl(GraduallySubscription entry) throws BGException, SQLException {
        if (entry.getEntityId() <= 0 || entry.getDate() == null) {
            throw new BGException("error data");
        }
        String query = "REPLACE INTO `" + this.tableName + "` (`entityId`, `date`) VALUES (?, ?)";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, entry.getEntityId());
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)entry.getDate()));
        ps.executeUpdate();
        ps.close();
    }

    public Date getDate(int entityId) throws BGException {
        GraduallySubscription entry = (GraduallySubscription)this.get("entityId=?", new Object[]{entityId});
        return entry != null ? entry.getDate() : null;
    }

    public void updateDate(int entityId, Date date) throws Exception {
        GraduallySubscription entry = new GraduallySubscription();
        entry.setEntityId(entityId);
        entry.setDate(date);
        this.update(entry);
    }

    public Map<Integer, Date> getDateMap() throws BGException {
        HashMap<Integer, Date> map = new HashMap<Integer, Date>();
        for (GraduallySubscription gs : this.list(null, null, new Object[0])) {
            map.put(gs.getEntityId(), gs.getDate());
        }
        return map;
    }
}

