/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_AccountDetail
extends BGJasperReport {
    public Report_AccountDetail() {
        this.id = "kernel_contract_account_detail";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        try {
            DecimalFormat df;
            BGReportFilter filter = this.createBGReportFilter();
            String gr = filter.getStringParam("gr");
            Calendar date = TimeUtils.parseCalendar((String)filter.getStringParam("date"), (String)"dd.MM.yyyy");
            int fc = Integer.valueOf(filter.getStringParam("fc"));
            String sumFormat = this.moduleSetup.get("report.kernel_contract_account.sum.format", "###,###,###,###,##0.00");
            StringBuffer query = new StringBuffer();
            query.append("SELECT contract.title, service.title, account.summa, contract.comment ");
            query.append("FROM contract_account AS account ");
            query.append("LEFT JOIN service ON account.sid=service.id ");
            query.append("LEFT JOIN contract ON account.cid=contract.id ");
            query.append("WHERE ");
            StringBuffer filterString = new StringBuffer();
            long grMask = Utils.enumToMask((String)gr);
            if (grMask > 0L) {
                filterString.append("contract.gr&");
                filterString.append(grMask);
                filterString.append(">0 AND ");
            }
            filterString.append("account.yy=");
            filterString.append(date.get(1));
            filterString.append(" AND account.mm=");
            filterString.append(date.get(2) + 1);
            if (fc > -1) {
                filterString.append(" AND contract.fc=");
                filterString.append(fc);
            }
            query.append(filterString);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("addInfo", " \u0433\u043e\u0434: " + date.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date.get(2)]);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            double sum = 0.0;
            double val = 0.0;
            try {
                df = new DecimalFormat(sumFormat);
            }
            catch (Exception e) {
                df = new DecimalFormat("###,###,###,###,##0.00");
            }
            params.put("accountSummMap", this.getAccountSummMap(this.con, filterString, df));
            BGDataSource dataSource = new BGDataSource();
            while (rs.next()) {
                val = rs.getDouble(3);
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("contract", rs.getString(1));
                row.put("service", rs.getString(2));
                row.put("summ", df.format(val));
                row.put("comment", rs.getString(4));
                dataSource.addRow(row);
                sum += val;
            }
            rs.close();
            ps.close();
            params.put("total", df.format(sum));
            this.fillReportToStream(this.id, out, params, dataSource);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)ex);
        }
    }

    private Map<String, String> getAccountSummMap(Connection con, StringBuffer filterString, DecimalFormat df) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer query = new StringBuffer();
        query.append("SELECT contract.title, SUM(summa) ");
        query.append("FROM contract_account AS account ");
        query.append("LEFT JOIN contract ON account.cid=contract.id ");
        query.append("WHERE ");
        query.append(filterString);
        query.append(" GROUP BY account.cid");
        PreparedStatement ps = con.prepareStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            result.put(rs.getString(1), df.format(rs.getDouble(2)));
        }
        rs.close();
        ps.close();
        return result;
    }
}

