/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.bean;

import bitel.billing.server.tariff.voice.bean.ZoneMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.model.Id;

public class ZoneMapManager
extends AbstractIdDao<ZoneMap> {
    public ZoneMapManager(Connection con, int moduleId) {
        super(con, moduleId, "zone_map");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void deleteMap(int id) throws SQLException {
        this.deleteImpl(id);
        ServerUtils.changeLastModificationTime(this.con, this.tableName);
    }

    protected void updateImpl(ZoneMap zoneMap) throws SQLException {
        Objects.requireNonNull(zoneMap);
        boolean update = zoneMap.getId() > 0;
        String query = this.sqlCommandAndTable(update) + " SET title=?" + this.sqlWhereId(update);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, zoneMap.getTitle());
            this.executeUpdate((Id)zoneMap, index, ps);
            ServerUtils.changeLastModificationTime(this.con, this.tableName);
        }
    }

    public void updateMap(ZoneMap map) throws SQLException {
        this.update((Object)map);
    }

    public List<ZoneMap> getZoneMapList() throws SQLException {
        ArrayList<ZoneMap> result = new ArrayList<ZoneMap>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        return result;
    }

    public ZoneMap getZoneMap(int id) throws SQLException {
        return (ZoneMap)this.get(id);
    }

    protected ZoneMap getFromRS(ResultSet rs) throws SQLException {
        return ZoneMap.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).build();
    }
}

