/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.bean;

import bitel.billing.server.tariff.bean.TimeType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class TimeTypeManger {
    private static final String TABLE_NAME = "time_type";
    private Connection con;

    public TimeTypeManger(Connection con) {
        this.con = con;
    }

    public List<TimeType> getTypeList() {
        ArrayList<TimeType> result = new ArrayList<TimeType>();
        try {
            String query = "SELECT * FROM time_type ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public TimeType getType(int id) {
        TimeType result = null;
        try {
            String query = "SELECT * FROM time_type WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(TimeType type) {
        String query = null;
        PreparedStatement ps = null;
        try {
            if (type.getId() <= 0) {
                query = "INSERT INTO time_type(title, data) VALUES (?, ?)";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE time_type SET title=?, data=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(3, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, type.getData());
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteType(int id) {
        try {
            String query = "DELETE FROM time_type WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TimeType getTypeFromRs(ResultSet rs) throws Exception {
        TimeType result = new TimeType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setData(rs.getString("data"));
        return result;
    }
}

