/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext.dhcp;

import bitel.billing.server.ext.dhcp.DHCPAdminSocketThread;
import bitel.billing.server.ext.dhcp.DHCPPacket;
import bitel.billing.server.ext.dhcp.DHCPSetup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public abstract class DHCPProcessor
extends BGLogger {
    protected static short FLAG_BROADCAST;
    protected final DHCPSetup setup;
    protected final DatagramChannel channel;
    protected final byte[] serverIdentifier;
    protected final Map<DHCPIpAddress, DHCPClientIdentifier> occupiedIPs = new HashMap<DHCPIpAddress, DHCPClientIdentifier>(512);
    protected final Map<DHCPIpAddress, DHCPClientIdentifier> offeredIPs = new HashMap<DHCPIpAddress, DHCPClientIdentifier>(512);
    protected final DelayQueue<OccupiedIP> occupiedIPQueue = new DelayQueue();
    protected final DelayQueue<OccupiedIP> offeredIPQueue = new DelayQueue();
    protected static final byte AGENT_CIRCUIT_ID = 1;
    protected static final byte AGENT_REMOTE_ID = 2;
    protected static final InetAddress broadcastAddress;
    protected static final InetSocketAddress broadcastAddress68;
    protected final Object mutex = new Object();
    private static final Pattern patternSpace;
    private static final Pattern patternDot;
    private static final Pattern patternComma;

    protected static DHCPClientIdentifier getDHCPClientIdentifier(DHCPPacket request) {
        DHCPPacket.DHCPOption clientId;
        DHCPPacket.DHCPSubOption remote;
        DHCPPacket.DHCPSubOption circuit;
        if (request.optionAgentInformation != null) {
            circuit = request.optionAgentInformation.getSubOption((byte)1);
            remote = request.optionAgentInformation.getSubOption((byte)2);
        } else {
            circuit = null;
            remote = null;
        }
        int len = 0;
        if (remote != null) {
            len += remote.value.length;
        }
        if (circuit != null) {
            len += circuit.value.length;
            clientId = null;
        } else {
            clientId = request.getOption((byte)61);
            if (clientId != null) {
                len += clientId.value.length;
            }
            len += 1 + request.chaddr.length;
        }
        byte[] id = new byte[len];
        len = 0;
        if (remote != null) {
            System.arraycopy(remote.value, 0, id, len, len += remote.value.length);
        }
        if (circuit != null) {
            System.arraycopy(circuit.value, 0, id, len, circuit.value.length);
            len += circuit.value.length;
        } else {
            if (clientId != null) {
                System.arraycopy(clientId.value, 0, id, len, clientId.value.length);
                len += clientId.value.length;
            }
            id[len++] = request.htype;
            System.arraycopy(request.chaddr, 0, id, len, request.chaddr.length);
        }
        return new DHCPClientIdentifier(request.xid, id);
    }

    public DHCPProcessor(DHCPSetup setup, DatagramChannel channel) {
        this.setup = setup;
        this.channel = channel;
        this.serverIdentifier = this.getServerIdentifier(channel);
        this.getLogger().info("dhcp.server.identifier=" + this.convertIPToString(this.serverIdentifier));
    }

    public void init() {
        new OccupiedIPCleaner("occupiedIpCleaner", this.occupiedIPs, this.occupiedIPQueue);
        new OccupiedIPCleaner("offeredIpCleaner", this.offeredIPs, this.offeredIPQueue);
    }

    protected byte[] getServerIdentifier(DatagramChannel channel) {
        byte[] result;
        String id = this.setup.get("dhcp.server.identifier", null);
        if (id != null && (result = this.convertStringToIP4(id)) != null) {
            return result;
        }
        return new byte[]{0, 0, 0, 0};
    }

    public void processRequest(InetSocketAddress requestAddress, DHCPPacket request) {
    }

    private final void sendResponse(InetSocketAddress address, DHCPPacket response) throws IOException {
        byte[] data = response.serialize();
        this.channel.send(ByteBuffer.wrap(data), address);
    }

    public final void sendResponse(DHCPPacket request, DHCPPacket response) {
        try {
            if (request.isFromRelayAgent()) {
                this.sendResponse(new InetSocketAddress(InetAddress.getByAddress(request.giaddr), 67), response);
                return;
            }
            if (response.messageType == 6) {
                this.sendResponseBroadcast(response);
            } else {
                if (request.isClientAddressSet()) {
                    this.sendResponse(new InetSocketAddress(InetAddress.getByAddress(request.ciaddr), 68), response);
                    return;
                }
                if ((request.flags & FLAG_BROADCAST) > 0) {
                    this.sendResponseBroadcast(response);
                } else {
                    this.sendResponseBroadcast(response);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void sendResponseBroadcast(DHCPPacket response) {
        try {
            byte[] data = response.serialize();
            this.channel.send(ByteBuffer.wrap(data), broadcastAddress68);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void adminCommand(DHCPAdminSocketThread thread) throws Exception {
    }

    protected DHCPIpAddress getIpAddress(DHCPPacket request, DHCPClientIdentifier client) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean occupyIP(DHCPPacket request, DHCPPacket response) {
        Map<DHCPIpAddress, DHCPClientIdentifier> map = this.occupiedIPs;
        synchronized (map) {
            DHCPClientIdentifier client = DHCPProcessor.getDHCPClientIdentifier(request);
            DHCPIpAddress ip = this.getIpAddress(request, client);
            this.occupiedIPs.put(ip, client);
            this.occupiedIPQueue.offer(new OccupiedIP(ip, 100L, request.xid));
            response.yiaddr = ip.address;
        }
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean offerIP(DHCPPacket request, DHCPPacket response) {
        Map<DHCPIpAddress, DHCPClientIdentifier> map = this.offeredIPs;
        synchronized (map) {
        }
        throw new UnsupportedOperationException();
    }

    protected byte[] convertStringToIP(String ip) {
        if (ip == null) {
            return null;
        }
        try {
            String[] split = patternDot.split(ip);
            byte[] result = new byte[split.length];
            for (int i = 0; i < split.length; ++i) {
                result[i] = (byte)(Integer.parseInt(split[i]) & 0xFF);
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected byte[] convertStringToIP4(String ip) {
        if (ip == null) {
            return null;
        }
        try {
            String[] split = patternDot.split(ip);
            byte[] result = new byte[split.length];
            for (int i = 0; i < split.length && i < 4; ++i) {
                result[i] = (byte)(Integer.parseInt(split[i]) & 0xFF);
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected byte[] convertStringToIP4_x16(String ip) {
        if (ip == null) {
            return null;
        }
        try {
            String[] split = patternSpace.split(ip);
            byte[] result = new byte[split.length];
            for (int i = 0; i < split.length && i < 4; ++i) {
                result[i] = (byte)(Integer.parseInt(split[i], 16) & 0xFF);
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected byte[] convertStringToIP4List(String ip) {
        if (ip == null) {
            return null;
        }
        try {
            String[] splitComma = patternComma.split(ip);
            byte[] result = new byte[splitComma.length * 4];
            for (int i = 0; i < splitComma.length; ++i) {
                String[] split = patternDot.split(splitComma[i]);
                for (int j = 0; j < split.length && i < 4; ++j) {
                    result[i * 4 + j] = (byte)(Integer.parseInt(split[j]) & 0xFF);
                }
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected String convertIPToString(byte[] ip) {
        StringBuilder sb = new StringBuilder(20);
        for (int i = 0; i < ip.length; ++i) {
            sb.append(ip[i] & 0xFF);
            sb.append('.');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String convertIPToString_x16(byte[] ip) {
        return Utils.bytesToString((byte[])ip);
    }

    protected boolean notFilled(byte[] val) {
        for (int i = 0; i < val.length; ++i) {
            if (val[i] == 0) continue;
            return false;
        }
        return true;
    }

    static {
        InetAddress a;
        FLAG_BROADCAST = (short)16384;
        try {
            a = InetAddress.getByName("255.255.255.255");
        }
        catch (Exception e) {
            a = null;
            e.printStackTrace();
        }
        broadcastAddress = a;
        broadcastAddress68 = new InetSocketAddress(a, 68);
        patternSpace = Pattern.compile("\\s* \\s*");
        patternDot = Pattern.compile("\\s*\\.\\s*");
        patternComma = Pattern.compile("\\s*,\\s*");
    }

    protected static class DHCPClientIdentifier {
        protected String gateId;
        protected final int xid;
        protected final byte[] id;
        private int hashCode = 0;

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Arrays.hashCode(this.id);
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof DHCPClientIdentifier && !Arrays.equals(this.id, ((DHCPClientIdentifier)obj).id);
        }

        public DHCPClientIdentifier(int xid, byte[] id) {
            this.xid = xid;
            this.id = id;
        }
    }

    protected static class OccupiedIPCleaner
    extends Thread {
        private final Map<DHCPIpAddress, DHCPClientIdentifier> occupiedIPs;
        private final DelayQueue<OccupiedIP> occupiedIPQueue;

        public OccupiedIPCleaner(String name, Map<DHCPIpAddress, DHCPClientIdentifier> occupiedIPs, DelayQueue<OccupiedIP> occupiedIPQueue) {
            super(name);
            this.occupiedIPs = occupiedIPs;
            this.occupiedIPQueue = occupiedIPQueue;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        OccupiedIP ip = (OccupiedIP)this.occupiedIPQueue.take();
                        Map<DHCPIpAddress, DHCPClientIdentifier> map = this.occupiedIPs;
                        synchronized (map) {
                            this.occupiedIPs.remove(ip.ip);
                            Logger logger = LoggerFactory.getLogger(OccupiedIPCleaner.class);
                            if (logger.isDebugEnabled()) {
                                logger.debug("now is free: {}", (Object)IPUtils.convertIpToString((int)ip.ip.addressInt));
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    BGLogger.error(ex);
                    continue;
                }
                break;
            }
        }
    }

    protected static class DHCPIpAddress {
        public final byte[] address;
        public final int addressInt;

        public DHCPIpAddress(byte[] addr) {
            this.address = addr;
            int addressInt = addr[3] & 0xFF;
            addressInt |= addr[2] << 8 & 0xFF00;
            addressInt |= addr[1] << 16 & 0xFF0000;
            this.addressInt = addressInt |= addr[0] << 24 & 0xFF000000;
        }

        public int hashCode() {
            return this.addressInt;
        }

        public boolean equals(Object obj) {
            return this == obj || this.addressInt == ((DHCPIpAddress)obj).addressInt;
        }
    }

    protected static class OccupiedIP
    implements Delayed {
        protected final DHCPIpAddress ip;
        protected final long leaseTime;
        protected final int xid;

        public OccupiedIP(DHCPIpAddress ip, long leaseTime, int xid) {
            this.ip = ip;
            this.leaseTime = leaseTime;
            this.xid = xid;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.leaseTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.leaseTime - ((OccupiedIP)o).leaseTime);
        }

        public boolean equals(Object obj) {
            return this.ip.addressInt == ((OccupiedIP)obj).ip.addressInt;
        }

        public int hashCode() {
            return this.ip.addressInt;
        }

        public String toString() {
            return IPUtils.convertIpToString((int)this.ip.addressInt);
        }
    }
}

