/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractIdTitleComment;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class DialogContractSelect
extends BGDialog
implements ActionListener {
    private BGControlPanelListSelect selectPanel;
    private int withoutContract;

    public DialogContractSelect() {
        this(false, false, -1);
    }

    public DialogContractSelect(boolean singleSelect) {
        this(false, singleSelect, -1);
    }

    public DialogContractSelect(boolean okCancel, boolean singleSelect, int withoutContract) {
        this.withoutContract = withoutContract;
        this.setModal(true);
        this.setTitle(singleSelect ? " \u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " : " \u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 ");
        this.jbInit(singleSelect, okCancel);
        this.pack();
        this.moveWindowToCenterScreen();
        this.setData();
    }

    protected void jbInit(boolean singleSelect, boolean okCancel) {
        BGButtonPanel ctrlPanel;
        this.selectPanel = new BGControlPanelListSelect(singleSelect);
        this.selectPanel.setBorder(new BGTitleBorder(singleSelect ? " \u0414\u043e\u0433\u043e\u0432\u043e\u0440 " : " \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b "));
        this.selectPanel.setPreferredSize(new Dimension(800, 200));
        if (okCancel) {
            panel = new BGButtonPanelOkCancel();
            panel.addActionListener(this);
            ctrlPanel = panel;
        } else {
            panel = new BGButtonPanel(BGButtonPanel.GLUE, BGButtonPanel.CLOSE);
            panel.addActionListener(this);
            ctrlPanel = panel;
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.selectPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)ctrlPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        JList<BGUListItem> list = this.selectPanel.getList();
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int onmask = 2176;
                int offmask = 64;
                if ((event.getModifiersEx() & (onmask | offmask)) == onmask && event.getKeyCode() == 79) {
                    try {
                        String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                        for (String s : Utils.toList(data, "\\s*[,;\n]\\s*")) {
                            int id = Utils.parseInt(s, 0);
                            if (id <= 0) continue;
                            s = String.valueOf(Utils.parseInt(s, 0));
                            BGUListItem item = new BGUListItem(id, s);
                            DialogContractSelect.this.selectPanel.getListModel().addElement(item);
                        }
                        event.consume();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String cmd = actionEvent.getActionCommand();
        if ("help".equals(cmd)) {
            this.openHelp(this.getClass().getName());
        } else {
            this.result = cmd;
            this.setVisible(false);
        }
    }

    @Override
    public void setData() {
        for (ContractIdTitleComment contract : BGClientBase.getFrame().getTabbedPane().getContracts()) {
            if (this.withoutContract == contract.getId()) continue;
            BGUListItem item = new BGUListItem(contract.getId(), contract.getTitle());
            item.setAttribute("comment", contract.getComment());
            this.selectPanel.getListModel().addElement(item);
        }
    }

    public List<BGUListItem> getId() {
        ArrayList<BGUListItem> idList = new ArrayList<BGUListItem>();
        DefaultListModel<BGUListItem> model = this.selectPanel.getListModel();
        for (int i = 0; i < model.getSize(); ++i) {
            BGUListItem item;
            if (!(model.getElementAt(i) instanceof BGUListItem) || !(item = model.getElementAt(i)).isSelected()) continue;
            idList.add(item);
        }
        return idList;
    }

    public String getSingleId() {
        String result = null;
        List<BGUListItem> idList = this.getId();
        if (idList.size() > 0) {
            result = idList.get(0).getIdStr();
        }
        return result;
    }

    public String[] getSelected() {
        StringBuilder conTitle = new StringBuilder();
        StringBuilder listId = new StringBuilder();
        for (BGUListItem item : this.getId()) {
            int cid = item.getId();
            String title = item.toString();
            if (cid <= 0 || title == null) continue;
            if (conTitle.length() > 0) {
                conTitle.append(", ");
            }
            conTitle.append(title);
            if (listId.length() > 0) {
                listId.append(",");
            }
            listId.append(cid);
        }
        return new String[]{listId.toString(), conTitle.toString()};
    }

    public BGControlPanelListSelect getSelectPanel() {
        return this.selectPanel;
    }
}

