/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.server.bean.condition.ConditionCheckerFactory;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.common.model.Period;

public class PluginServerListener
extends WebMenuBase
implements OnInitServer,
OnDestroyServer,
EventListener<Event> {
    public void onInitServer(String applicationName) {
        for (BGInstalledModule instModule : ModuleCache.getInstance().getInstalledModulesList()) {
            String module = instModule.getName();
            try {
                Class<?> conditionClass = Class.forName("ru.bitel.bgbilling.plugins.dispatch.modules." + module + ".common.ModuleDispatchCondition");
                Class<?> checkerClass = Class.forName("ru.bitel.bgbilling.plugins.dispatch.modules." + module + ".server.ModuleDispatchConditionChecker");
                ConditionCheckerFactory.register(conditionClass, checkerClass);
            }
            catch (Exception exception) {}
        }
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
            EventProcessor.getInstance().addListener((EventListener)this, ContractCloseEvent.class);
            EventProcessor.getInstance().addListener((EventListener)this, ContractWrapEvent.class);
        }
        catch (BGException e) {
            this.getLogger().error("error add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            this.getLogger().error("error remove event listener", (Throwable)e);
        }
    }

    public void notify(Event event, EventListenerContext ctx) throws Exception {
        block8: {
            ContractWrapEvent cwEvent;
            ContactDao contactDao;
            SubscriptionDao subscriptionDao;
            int contractId;
            block9: {
                block7: {
                    Connection con = ctx.getConnection();
                    contractId = event.getContractId();
                    subscriptionDao = new SubscriptionDao(con);
                    contactDao = new ContactDao(con);
                    if (!(event instanceof ContractDeleteEvent)) break block7;
                    ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
                    if (cdEvent.isCheck()) break block8;
                    this.getLogger().debug("Delete contract subscriptions and contacts for contract " + contractId);
                    subscriptionDao.deleteContractSubscriptions(contractId);
                    contactDao.deleteContactByContractId(contractId);
                    break block8;
                }
                if (!(event instanceof ContractCloseEvent)) break block9;
                ContractCloseEvent ccEvent = (ContractCloseEvent)event;
                if (ccEvent.isCheck()) break block8;
                this.getLogger().debug("Close subscriptions period for contract " + contractId);
                List<Subscription> subscriptionList = subscriptionDao.getList(-1, contractId, true);
                for (Subscription subscription : subscriptionList) {
                    subscription.setActive(false);
                    Period period = subscription.getSubscriptionPeriod();
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateTo(ccEvent.getDate());
                    subscription.setSubscriptionPeriod(period);
                    subscriptionDao.update(subscription);
                }
                break block8;
            }
            if (event instanceof ContractWrapEvent && !(cwEvent = (ContractWrapEvent)event).isCheck()) {
                this.getLogger().debug("Wrap contract subscriptions and contacts from contract " + contractId + " to contract " + cwEvent.getToContractId());
                List<Contact> oldContactList = contactDao.getContactsOfContract(contractId);
                List<Subscription> oldSubscriptionList = subscriptionDao.getList(-1, contractId, true);
                HashMap<Integer, Contact> contactMappings = new HashMap<Integer, Contact>();
                this.getLogger().debug("\tCreating contacts (total " + oldContactList.size() + ")");
                for (Contact contact : oldContactList) {
                    Contact newContact = new Contact();
                    newContact.setContactTypeId(contact.getContactTypeId());
                    newContact.setContractId(cwEvent.getToContractId());
                    newContact.setValue(contact.getValue());
                    contactDao.update(newContact);
                    contactMappings.put(contact.getId(), newContact);
                }
                this.getLogger().debug("\tCreating subscriptions (total " + oldSubscriptionList.size() + ")");
                for (Subscription oldSubscription : oldSubscriptionList) {
                    oldSubscription.setActive(false);
                    Period period = oldSubscription.getSubscriptionPeriod();
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateTo(cwEvent.getDateClose());
                    oldSubscription.setSubscriptionPeriod(period);
                    subscriptionDao.update(oldSubscription);
                    Subscription newSubscription = new Subscription();
                    newSubscription.setActive(true);
                    newSubscription.setComment(oldSubscription.getComment());
                    newSubscription.setContractId(cwEvent.getToContractId());
                    newSubscription.setDispatch(oldSubscription.getDispatch());
                    newSubscription.setPreferences(oldSubscription.getPreferences());
                    newSubscription.setRepeatTime(oldSubscription.getRepeatTime());
                    newSubscription.setSubscriptionPeriod(new Period(cwEvent.getDateOpen(), null));
                    for (Contact contact : oldSubscription.getContacts()) {
                        newSubscription.addContact((Contact)contactMappings.get(contact.getId()));
                    }
                    subscriptionDao.update(newSubscription);
                }
            }
        }
    }
}

