/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptServiceCost;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffContext;
import ru.bitel.bgbilling.modules.cerbercrypt.server.tariff.CerbercryptTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class PacketSetFilterTariffTreeNode
extends ModuleServiceTariffTreeNode<CerbercryptTariffContext, CerbercryptServiceCost, CerbercryptTariffRequest> {
    private Set<Integer> packets = new HashSet<Integer>();
    private int andOrNotModeValue = 1;
    private boolean onContractTotal = false;

    public PacketSetFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String packets = parameterMap.get("packets");
        if (Utils.notBlankString((String)packets)) {
            this.packets.addAll(Utils.toIntegerList((String)packets));
        }
        this.andOrNotModeValue = parameterMap.getInt("andornot_mode", -1);
        this.onContractTotal = Utils.parseBoolean((String)parameterMap.get("on_contract_total"));
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, CerbercryptTariffRequest tariffRequest, TariffTreeNodeHolder holder, CerbercryptTariffContext tariffContext, TreeContext treeContext, ThreadContext workerContext) {
        List<Packet> _curr_card_packets;
        List<Packet> list = _curr_card_packets = this.onContractTotal ? tariffRequest.getPacketListOnContract() : tariffRequest.getPacketList();
        if (_curr_card_packets != null) {
            HashSet<Integer> curr_card_packets = new HashSet<Integer>();
            for (Packet c : _curr_card_packets) {
                curr_card_packets.add(c.getId());
            }
            boolean check = false;
            switch (this.andOrNotModeValue) {
                case 1: {
                    check = curr_card_packets.containsAll(this.packets);
                    this.getLogger().debug("AND: 1) subscr packs: {}; 2) tariff packs: {}; 1 contains all 2: {}", new Object[]{curr_card_packets, this.packets, check});
                    break;
                }
                case 2: {
                    check = !Collections.disjoint(curr_card_packets, this.packets);
                    System.out.println("OR: 1) subscr packs: " + String.valueOf(curr_card_packets) + "; 2) tariff packs: " + String.valueOf(this.packets) + "; 1 intersects 2: " + check);
                    break;
                }
                case 3: {
                    check = !curr_card_packets.containsAll(this.packets);
                    System.out.println("NOT-AND: 1) subscr packs: " + String.valueOf(curr_card_packets) + "; 2) tariff packs: " + String.valueOf(this.packets) + "; not (1 contains all 2): " + check);
                    break;
                }
                case 4: {
                    check = Collections.disjoint(curr_card_packets, this.packets);
                    System.out.println("NOT-OR: 1) subscr packs: " + String.valueOf(curr_card_packets) + "; 2) tariff packs: " + String.valueOf(this.packets) + "; 1 no intersects 2: " + check);
                }
            }
            if (check) {
                this.executeChildren(parentTreeNodeId, tariffRequest, holder, tariffContext, treeContext, workerContext);
            }
        }
        return 1;
    }
}

