/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.DropMode;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.BooleanTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ContractParametersEditor
extends BGPanel {
    private BGUTable table = null;
    private ParameterTableModel model = new ParameterTableModel();
    private ContractParameterService contractParameterService = null;

    public ContractParametersEditor() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        this.table.setDragEnabled(true);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setTransferHandler(new TableRowTransferHandler(this.table));
        this.table.enableSearchField();
        JLabel infoLabel = new JLabel("\u0414\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u0435\u0440\u0435\u0442\u0430\u0449\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u043c\u044b\u0448\u043a\u043e\u0439");
        infoLabel.setForeground(Color.GRAY);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)infoLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b  "));
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        jPanel3.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleLDMouseClicked(this.table, e -> this.editItem());
    }

    public void reorder(int nextIndex) {
        try {
            List<ContractParameterGroupAttr> listPrefParameter = this.getContractParameterService().contractParameterGroupAttrList();
            int indexSelectedRow = this.table.getSelectedRow();
            int oldPosition = listPrefParameter.get(indexSelectedRow).getOrder();
            if (nextIndex < indexSelectedRow) {
                int topPoint = nextIndex;
                listPrefParameter.get(indexSelectedRow).setOrder(listPrefParameter.get(topPoint).getOrder());
                for (int x = topPoint; x < indexSelectedRow; ++x) {
                    if (topPoint - indexSelectedRow >= 0) continue;
                    ContractParameterGroupAttr first = listPrefParameter.get(x);
                    ContractParameterGroupAttr second = listPrefParameter.get(x + 1);
                    if (x == indexSelectedRow) continue;
                    first.setOrder(x + 1 == indexSelectedRow ? oldPosition : second.getOrder());
                }
            } else {
                int endPosition = nextIndex;
                int topPoint = indexSelectedRow;
                listPrefParameter.get(indexSelectedRow).setOrder(listPrefParameter.get(nextIndex).getOrder());
                for (int i = endPosition; i > topPoint; --i) {
                    ContractParameterGroupAttr test = listPrefParameter.get(i);
                    ContractParameterGroupAttr test2 = listPrefParameter.get(i - 1);
                    if (i == indexSelectedRow) continue;
                    test.setOrder(i - 1 == indexSelectedRow ? oldPosition : test2.getOrder());
                }
            }
            this.getContractParameterService().contractParameterGroupAttrOrderSet(listPrefParameter);
            this.setData();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = this.getContext().getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    @Override
    public void setData() {
        try {
            this.model.setData(this.getContractParameterService().contractParameterGroupAttrList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            this.deleteItem();
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    @Override
    public void newItem() {
        new ParameterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", new ContractParameterGroupAttr()).open();
    }

    @Override
    public void editItem() {
        this.model.optSelectedRow().ifPresentOrElse(a -> new ParameterEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", (ContractParameterGroupAttr)((Object)a)).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!"));
    }

    @Override
    public void deleteItem() {
        try {
            ContractParameterGroupAttr contractParameterGroupAttr = (ContractParameterGroupAttr)((Object)this.model.getSelectedRow());
            if (contractParameterGroupAttr == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (!ClientUtils.confirmDelete(contractParameterGroupAttr.getTitle())) {
                return;
            }
            this.getContractParameterService().contractParameterGroupAttrDelete(contractParameterGroupAttr.getId());
            this.setData();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    class ParameterTableModel
    extends BGTableModel<ContractParameterGroupAttr> {
        public ParameterTableModel() {
            super(ParameterTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430", 100, 100, 100, "order", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0422\u0438\u043f \u043f\u043e\u043b\u044f", 200, 200, 200, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044f", -1, -1, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0441\u0435\u0433\u0434\u0430 \u0432\u0438\u0434\u0438\u043c\u044b\u0439", 120, 120, 120, "alwaysVisible", true, new BooleanTableCellRenderer());
            this.addColumn("\u0427\u0442\u0435\u043d\u0438\u0435 \u0432 \u041b\u041a", 100, 100, 100, "customerRead", true, new BooleanTableCellRenderer());
            this.addColumn("\u041f\u0440\u0430\u0432\u043a\u0430 \u0432 \u041b\u041a", 100, 100, 100, "customerWrite", true, new BooleanTableCellRenderer());
            this.addColumn("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", 100, 100, 100, "history", true, new BooleanTableCellRenderer());
        }

        @Override
        public Object getValueAt(ContractParameterGroupAttr contractParameterGroupAttr, int column) throws Exception {
            String i = this.getIdentifier(column);
            if ("type".equals(i)) {
                return EntitySpecAttrType.optEntitySpecAttrType((int)contractParameterGroupAttr.getType()).map(a -> a.getTypeTitle()).orElse("???");
            }
            return super.getValueAt(contractParameterGroupAttr, column);
        }
    }

    class TableRowTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(Integer.class, "Integer Row Index");
        private JTable table = null;

        public TableRowTransferHandler(JTable table) {
            this.table = table;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new Transferable(){

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return true;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{TableRowTransferHandler.this.localObjectFlavor};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return TableRowTransferHandler.this.table.getSelectedRow();
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            BGUTable table = (BGUTable)info.getComponent();
            for (RowSorter.SortKey sortKey : table.getRowSorter().getSortKeys()) {
                if (SortOrder.UNSORTED.equals((Object)sortKey.getSortOrder())) continue;
                if (ClientUtils.confirm("\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u0432 \u0440\u0435\u0436\u0438\u043c \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435")) {
                    table.getRowSorter().setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.UNSORTED)));
                    table.revalidate();
                }
                return false;
            }
            boolean b = info.getComponent() == table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
            table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
            return b;
        }

        @Override
        protected void exportDone(JComponent c, Transferable t, int act) {
            if (act == 2 || act == 0) {
                this.table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            JTable target = (JTable)info.getComponent();
            JTable.DropLocation dropLocation = (JTable.DropLocation)info.getDropLocation();
            int index = dropLocation.getRow();
            int max = this.table.getModel().getRowCount() - 1;
            if (index < 0 || index > max) {
                index = max;
            }
            target.setCursor(Cursor.getPredefinedCursor(0));
            try {
                Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
                if (rowFrom != -1 && rowFrom != index) {
                    ContractParametersEditor.this.reorder(index);
                    if (index > rowFrom) {
                        --index;
                    }
                    return true;
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            return false;
        }
    }

    class ParameterEditor
    extends BGEditorDialog<ContractParameterGroupAttr> {
        private BGUComboBox<EntitySpecAttrType> typeParameter;
        private BGTextField title;
        private JCheckBox read;
        private JCheckBox write;
        private JCheckBox history;
        private JCheckBox alwaysVisible;

        public ParameterEditor(String title, ContractParameterGroupAttr data) {
            super(title, data);
            this.typeParameter = new BGUComboBox();
            this.title = new BGTextField();
            this.read = new JCheckBox(" \u0447\u0442\u0435\u043d\u0438\u0435 \u0432 \u041b\u041a");
            this.write = new JCheckBox(" \u043f\u0440\u0430\u0432\u043a\u0430 \u0432 \u041b\u041a");
            this.history = new JCheckBox(" \u0438\u0441\u0442\u043e\u0440\u0438\u044f");
            this.alwaysVisible = new JCheckBox(" \u0432\u0441\u0435\u0433\u0434\u0430 \u0432\u0438\u0434\u0438\u043c\u044b\u0439");
        }

        @Override
        public void doDialogPanel() {
            List<EntitySpecAttrType> listParam = Arrays.asList(EntitySpecAttrType.UNKNOWN, EntitySpecAttrType.TEXT, EntitySpecAttrType.ADDRESS, EntitySpecAttrType.EMAIL, EntitySpecAttrType.SERVICING_PERSON, EntitySpecAttrType.BOOLEAN, EntitySpecAttrType.DATE, EntitySpecAttrType.LIST, EntitySpecAttrType.CONTRACT, EntitySpecAttrType.PHONE, EntitySpecAttrType.SEPARATOR, EntitySpecAttrType.MULTILIST);
            this.typeParameter.setData(listParam);
            JPanel flagsPanel = new JPanel(new GridBagLayout());
            flagsPanel.add((Component)new JLabel("\u0424\u043b\u0430\u0433\u0438: "), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            flagsPanel.add((Component)this.read, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            flagsPanel.add((Component)this.write, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            flagsPanel.add((Component)this.history, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            flagsPanel.add((Component)this.alwaysVisible, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add(this.typeParameter, new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.panel.add((Component)flagsPanel, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
            this.typeParameter.setSelectedIndex(0);
            this.typeParameter.setEnabled(((ContractParameterGroupAttr)((Object)this.data)).getType() == EntitySpecAttrType.UNKNOWN.getCode());
            int len = this.typeParameter.getItemCount();
            for (int index = 0; index < len; ++index) {
                EntitySpecAttrType entitySpecAttrType = (EntitySpecAttrType)this.typeParameter.getItemAt(index);
                if (entitySpecAttrType.getCode() != ((ContractParameterGroupAttr)((Object)this.data)).getType()) continue;
                this.typeParameter.setSelectedIndex(index);
            }
            this.title.setText(((ContractParameterGroupAttr)((Object)this.data)).getTitle());
            this.history.setSelected(((ContractParameterGroupAttr)((Object)this.data)).isHistory());
            this.write.setSelected(((ContractParameterGroupAttr)((Object)this.data)).isCustomerWrite());
            this.read.setSelected(((ContractParameterGroupAttr)((Object)this.data)).isCustomerRead());
            this.alwaysVisible.setSelected(((ContractParameterGroupAttr)((Object)this.data)).isAlwaysVisible());
        }

        @Override
        public boolean doApply() throws Exception {
            EntitySpecAttrType pref = (EntitySpecAttrType)this.typeParameter.getSelectedItem();
            if (pref == null || pref == EntitySpecAttrType.UNKNOWN) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u043e\u043b\u044f");
                return false;
            }
            if (this.title.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            try {
                ((ContractParameterGroupAttr)((Object)this.data)).setTitle(this.title.getText().trim());
                ((ContractParameterGroupAttr)((Object)this.data)).setHistory(this.history.isSelected());
                ((ContractParameterGroupAttr)((Object)this.data)).setCustomerRead(this.read.isSelected());
                ((ContractParameterGroupAttr)((Object)this.data)).setCustomerWrite(this.write.isSelected());
                ((ContractParameterGroupAttr)((Object)this.data)).setAlwaysVisible(this.alwaysVisible.isSelected());
                ((ContractParameterGroupAttr)((Object)this.data)).setType(pref.getCode());
                ContractParametersEditor.this.getContractParameterService().contractParameterGroupAttrUpdate((ContractParameterGroupAttr)((Object)this.data));
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog(e1);
            }
            finally {
                ContractParametersEditor.this.setData();
            }
            return true;
        }
    }
}

