/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMapItem;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.CostMapManager;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.GeographicCodeManager;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.voiceip.common.bean.VoiceIpOperatorPrefixCost;
import ru.bitel.bgbilling.modules.voiceip.common.service.VoiceIpService;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSession;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voiceip.common.service.VoiceIpService")
public class VoiceIpServiceImpl
extends AbstractService
implements VoiceIpService {
    public String geographicCodeTree() throws BGException, BGMessageException {
        return new GeographicCodeManager(this.getConnection(), this.moduleId).getTreeJson().toString();
    }

    public List<CostMap> costMapList(String orderBy) throws BGException, BGMessageException {
        try (CostMapManager costMapManager = new CostMapManager(this.getConnection(), this.moduleId);){
            List list = costMapManager.list(orderBy);
            return list;
        }
    }

    public List<VoiceIpOperatorPrefixCost> voiceIpOperatorPrefixCostList(String prefix, int serviceId, int callTypeId, int groupId) throws BGException, BGMessageException {
        if (Utils.notEmptyString((String)prefix)) {
            VoiceIpSession voiceIpSession = new VoiceIpSession();
            voiceIpSession.setMid(this.moduleId);
            VoiceUtils voiceUtils = new VoiceUtils();
            voiceUtils.init(this.getConnection(), this.moduleId);
            return voiceIpSession.getOperatorPrefixCostTable(this.getConnection(), voiceUtils, prefix, 1L << groupId, serviceId, callTypeId);
        }
        return new ArrayList<VoiceIpOperatorPrefixCost>();
    }

    public CostMap costMapGet(int id) throws BGException, BGMessageException {
        try (CostMapManager costMapManager = new CostMapManager(this.getConnection(), this.moduleId);){
            CostMap costMap = (CostMap)costMapManager.get(id);
            return costMap;
        }
    }

    public void costMapUpdate(int id, String title) throws BGException, BGMessageException {
        if (Utils.isBlankString((String)title)) {
            throw new BGMessageException("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e");
        }
        try (CostMapManager costMapManager = new CostMapManager(this.getConnection(), this.moduleId);){
            CostMap costMap = new CostMap();
            costMap.setId(id);
            costMap.setTitle(title);
            costMapManager.update((Object)costMap);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void costMapDelete(int id) throws BGException, BGMessageException {
        try (CostMapManager costMapManager = new CostMapManager(this.getConnection(), this.moduleId);){
            costMapManager.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public String costMapTree(int id) throws BGException, BGMessageException {
        JSONObject json = new JSONObject();
        try (CostMapManager costMapManager = new CostMapManager(this.getConnection(), this.moduleId);){
            this.costMapTreeToJson(json, costMapManager.getTree(id, true));
        }
        return json.toString();
    }

    private void costMapTreeToJson(JSONObject json, CostMapItem costMapItem) {
        json.put("id", costMapItem.getId());
        json.put("code", (Object)costMapItem.getCode());
        json.put("cost", (Object)costMapItem.getCost());
        json.put("dest", (Object)costMapItem.getDestination());
        json.put("destId", costMapItem.getDestinationId());
        json.put("title", (Object)costMapItem.getTitle());
        if (costMapItem.getChildren() != null) {
            JSONArray childArray = new JSONArray();
            json.put("childs", (Object)childArray);
            for (CostMapItem item : costMapItem.getChildren()) {
                JSONObject childJson = new JSONObject();
                this.costMapTreeToJson(childJson, item);
                childArray.put((Object)childJson);
            }
        }
    }
}

