/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.voice.server.runtime.BCDecimal;

public class CodeRangeRuntime {
    private final byte[] code;
    private final byte[] rangeFrom;
    private final byte[] rangeTo;
    private final int prefixLength;
    private final int length;
    private final int level;
    private final int startLevel;
    private final int endLevel;
    private final CodeRangeRuntime[] children;
    private static final Pattern pattern = Pattern.compile("^(\\d+)\\s*\\(\\s*(\\d+)\\s*-\\s*(\\d+)\\s*\\)$");

    public CodeRangeRuntime(String code, int level, int startLevel, int endLevel, CodeRangeRuntime[] children) {
        if (code.endsWith(")")) {
            Matcher m = pattern.matcher(code);
            if (!m.matches()) {
                throw new IllegalArgumentException(code);
            }
            code = m.group(1);
            String rangeFrom = m.group(2);
            String rangeTo = m.group(3);
            this.code = BCDecimal.toBCDecimal(code);
            int codeLength = code.length();
            if (codeLength % 2 != 0 && rangeFrom != null) {
                char last = code.charAt(codeLength - 1);
                this.rangeFrom = BCDecimal.toBCDecimal(last + rangeFrom);
                int rangeFromLast = this.rangeFrom.length - 1;
                if (rangeFromLast >= 0 && (this.rangeFrom[rangeFromLast] & 0xF) == 15) {
                    int n = rangeFromLast;
                    this.rangeFrom[n] = (byte)(this.rangeFrom[n] & 0xF0);
                }
                this.rangeTo = BCDecimal.toBCDecimal(last + rangeTo);
                this.prefixLength = this.code.length - 1;
            } else {
                this.rangeFrom = BCDecimal.toBCDecimal(rangeFrom);
                int rangeFromLast = this.rangeFrom.length - 1;
                if (rangeFromLast >= 0 && (this.rangeFrom[rangeFromLast] & 0xF) == 15) {
                    int n = rangeFromLast;
                    this.rangeFrom[n] = (byte)(this.rangeFrom[n] & 0xF0);
                }
                this.rangeTo = BCDecimal.toBCDecimal(rangeTo);
                this.prefixLength = this.code.length;
            }
        } else {
            this.code = BCDecimal.toBCDecimal(code);
            this.rangeFrom = null;
            this.rangeTo = null;
            this.prefixLength = this.code.length;
        }
        assert (this.rangeFrom == null && this.rangeTo == null || this.rangeFrom.length == this.rangeTo.length);
        this.length = this.code.length + this.rangeFrom.length;
        this.level = level;
        this.startLevel = startLevel;
        this.endLevel = endLevel;
        this.children = children;
    }

    public CodeRangeRuntime find(byte[] bcd) {
        if (CodeRangeRuntime.startsWith(bcd, this)) {
            return CodeRangeRuntime.find(this, bcd);
        }
        return null;
    }

    public CodeRangeRuntime find(byte[] bcd, int startLevel, int endLevel) {
        if (CodeRangeRuntime.startsWith(bcd, this)) {
            return CodeRangeRuntime.find(this, bcd, startLevel, endLevel, true);
        }
        return null;
    }

    private static boolean startsWith(byte[] bcd, CodeRangeRuntime code) {
        if (BCDecimal.startsWith(bcd, code.code)) {
            if (code.rangeFrom != null) {
                if (bcd.length < code.length) {
                    return false;
                }
                if (BCDecimal.compare(bcd, code.prefixLength, code.rangeFrom, 0, code.rangeFrom.length) < 0 || BCDecimal.compare(bcd, code.prefixLength, code.rangeTo, 0, code.rangeTo.length) > 0) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static CodeRangeRuntime find(CodeRangeRuntime code, byte[] bcd) {
        if (!BCDecimal.equals(code.code, bcd) && code.children != null) {
            for (CodeRangeRuntime child : code.children) {
                CodeRangeRuntime result;
                if (!BCDecimal.startsWith(bcd, child.code) || (result = CodeRangeRuntime.find(child, bcd)) == null) continue;
                return result;
            }
        }
        return code;
    }

    private static CodeRangeRuntime find(CodeRangeRuntime code, byte[] bcd, int startLevel, int endLevel, boolean binarySearch) {
        block13: {
            if (code.startLevel > 0 && code.endLevel > 0) {
                startLevel = code.startLevel;
                endLevel = code.endLevel;
            }
            if (!BCDecimal.equals(code.code, bcd) && code.children != null) {
                if (binarySearch && code.children.length > 10) {
                    int low = 0;
                    int high = code.children.length - 1;
                    while (low <= high) {
                        int i;
                        int mid = low + high >>> 1;
                        CodeRangeRuntime child = code.children[mid];
                        int cmp = BCDecimal.compare(bcd, code.prefixLength, child.code, code.prefixLength, child.code.length);
                        if (cmp < 0) {
                            low = mid + 1;
                            continue;
                        }
                        if (cmp > 0) {
                            high = mid - 1;
                            continue;
                        }
                        CodeRangeRuntime result = CodeRangeRuntime.find(child, bcd, startLevel, endLevel, binarySearch);
                        if (result != null) {
                            return result;
                        }
                        for (i = mid - 1; i >= low; --i) {
                            child = code.children[i];
                            if (!BCDecimal.startsWith(bcd, child.code)) break;
                            result = CodeRangeRuntime.find(child, bcd, startLevel, endLevel, binarySearch);
                            if (result == null) continue;
                            return result;
                        }
                        for (i = mid + 1; i <= high; ++i) {
                            child = code.children[i];
                            if (BCDecimal.startsWith(bcd, child.code)) {
                                result = CodeRangeRuntime.find(child, bcd, startLevel, endLevel, binarySearch);
                                if (result == null) continue;
                                return result;
                            }
                            break block13;
                        }
                        break;
                    }
                } else {
                    for (CodeRangeRuntime child : code.children) {
                        CodeRangeRuntime result;
                        if (!BCDecimal.startsWith(bcd, child.code) || (result = CodeRangeRuntime.find(child, bcd, startLevel, endLevel, binarySearch)) == null) continue;
                        return result;
                    }
                }
            }
        }
        if (startLevel <= 0 || endLevel <= 0 || code.level >= startLevel && code.level <= endLevel) {
            return code;
        }
        return null;
    }

    public String toString() {
        if (this.rangeFrom == null) {
            return BCDecimal.toString(this.code);
        }
        String code = BCDecimal.toString(this.code);
        if (code.length() % 2 == 0) {
            return code + "(" + BCDecimal.toString(this.rangeFrom) + "-" + BCDecimal.toString(this.rangeTo) + ")";
        }
        return code + "(" + BCDecimal.toString(this.rangeFrom).substring(1) + "-" + BCDecimal.toString(this.rangeTo).substring(1) + ")";
    }

    public static void main(String[] args) {
        CodeRangeRuntime code = new CodeRangeRuntime("734(723-734)", 0, 0, 0, null);
        System.out.println(code);
        System.out.println(code.find(BCDecimal.toBCDecimal("73472302880")));
        System.out.println(code.find(BCDecimal.toBCDecimal("73473402880")));
        System.out.println(code.find(BCDecimal.toBCDecimal("73463402880")));
    }
}

