/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffCounter;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffCounterType;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class TariffCounterPanel
extends BGUPanel {
    private ButtonGroup filter\u0410ccessories = new ButtonGroup();
    private JCheckBox onlyRedefined = new JCheckBox("\u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0435\u0440\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
    private TariffCounterTableModel counterTableModel = new TariffCounterTableModel();
    private List<ContractTariffCounter> contractTariffCounters = new ArrayList<ContractTariffCounter>();
    private List<BGModule> modules;

    protected void jbInit() throws Exception {
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        BGUTable table = new BGUTable((TableModel)((Object)this.counterTableModel));
        table.setSelectionMode(0);
        table.setAutoRowHeight(true);
        table.setFont((Font)new FontUIResource(new Font(font.getName(), font.getStyle(), font.getSize() + 2)));
        table.addMouseListener((MouseListener)new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getTariffVariableTopPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
    }

    private JPanel getTariffVariableTopPanel() {
        ActionListener actionListener = e -> this.doFilterTariffCounters();
        FilterTypeButton anyButton = new FilterTypeButton("\u041b\u044e\u0431\u0430\u044f", "any", actionListener, this.filter\u0410ccessories, true);
        FilterTypeButton contractButton = new FilterTypeButton(TariffCounterType.CONTRACT, actionListener, this.filter\u0410ccessories);
        FilterTypeButton accountButton = new FilterTypeButton(TariffCounterType.ACCOUNT, actionListener, this.filter\u0410ccessories);
        FilterTypeButton counterButton = new FilterTypeButton(TariffCounterType.COUNTER, actionListener, this.filter\u0410ccessories);
        this.onlyRedefined.addChangeListener(e -> this.doFilterTariffCounters());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)anyButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)contractButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)accountButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)counterButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.onlyRedefined, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 0), 0, 0));
        return panel;
    }

    public void doFilterTariffCounters() {
        ArrayList<ContractTariffCounter> data = new ArrayList<ContractTariffCounter>();
        String access = this.filter\u0410ccessories.getSelection().getActionCommand();
        for (ContractTariffCounter contractTariffCounter : this.contractTariffCounters) {
            boolean add = "any".equals(access) || TariffCounterType.CONTRACT.name().equals(access) && contractTariffCounter.getCounterType() == TariffCounterType.CONTRACT || TariffCounterType.ACCOUNT.name().equals(access) && contractTariffCounter.getCounterType() == TariffCounterType.ACCOUNT || TariffCounterType.COUNTER.name().equals(access) && contractTariffCounter.getCounterType() == TariffCounterType.COUNTER;
            if (!(add = add && (!this.onlyRedefined.isSelected() || this.onlyRedefined.isSelected() && contractTariffCounter.isRedefined()))) continue;
            data.add(contractTariffCounter);
        }
        this.counterTableModel.setData(data);
    }

    public void showTariffCounters(int contractTariffId) {
        if (contractTariffId > 0) {
            Async.of(() -> {
                try {
                    this.contractTariffCounters = ((ContractTariffService)((ClientContext)this.getContext()).getWebService(ContractTariffService.class, 0)).contractTariffCounters(contractTariffId);
                    if (this.modules == null) {
                        this.modules = ((ModuleService)((ClientContext)this.getContext()).getWebService(ModuleService.class, 0)).moduleList();
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                finally {
                    this.doFilterTariffCounters();
                }
            });
        } else {
            this.contractTariffCounters.clear();
            this.doFilterTariffCounters();
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {});
    }

    class TariffCounterTableModel
    extends BGTableModel<ContractTariffCounter> {
        public TariffCounterTableModel() {
            super(TariffCounterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 250, 250, 250, "moduleId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", 200, 200, 200, "tariffNodeKey", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 400, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u0431\u043b\u0430\u0441\u0442\u044c \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430", 150, 150, 150, "counterType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0430", 100, 100, 100, "entityId", true, new ValueTableCellRenderer());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435(\u043e\u0431\u044a\u0435\u043c)", 200, 250, -1, "value", true, new ValueTableCellRenderer());
        }

        public Object getValue(ContractTariffCounter val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("moduleId".equals(identifier)) {
                return TariffCounterPanel.this.modules.stream().filter(a -> a.getId() == val.getModuleId()).findFirst().map(a -> a.getName() + " [#" + a.getId() + "]").orElse("??? [#" + val.getModuleId() + "]");
            }
            return super.getValue((Object)val, column);
        }
    }

    class FilterTypeButton
    extends JToggleButton {
        FilterTypeButton(TariffCounterType tariffCounterType, ActionListener actionListener, ButtonGroup buttonGroup) {
            this(tariffCounterType.getTitle(), tariffCounterType.name(), actionListener, buttonGroup, false);
        }

        FilterTypeButton(String title, String actionCommand, ActionListener actionListener, ButtonGroup buttonGroup, boolean selected) {
            super(title, selected);
            this.setActionCommand(actionCommand);
            this.addActionListener(actionListener);
            buttonGroup.add(this);
        }
    }

    class ValueTableCellRenderer
    extends DefaultTableCellRenderer {
        ValueTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ContractTariffCounter contractTariffCounter = (ContractTariffCounter)((Object)TariffCounterPanel.this.counterTableModel.getRows().get(row));
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.setFont(contractTariffCounter.isRedefined() ? table.getFont().deriveFont(1) : table.getFont());
            return this;
        }
    }
}

