/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.ContractRemover;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.util.db.ColumnValue;
import jakarta.annotation.PreDestroy;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.ConfigParameter;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailContractPasswordReset;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailSendWebPassword;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractFilters;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractSearchParam;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.PersonalTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractMode;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterHistoryData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.dto.ContractSearchDto;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractCommentUpdateEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractDomainModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedModuleEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractPasswordChangedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.PatternContractMasterHandler;
import ru.bitel.bgbilling.kernel.contract.plugin.PluginTreeNodeInterface;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractHistoryRecord;
import ru.bitel.bgbilling.kernel.contract.search.server.ContractHistoryRecordDao;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractAddingSubEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamBeforeChangeEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.GetContractCardsListEvent;
import ru.bitel.bgbilling.kernel.event.events.ValidateTextParamEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.IdTitleValue;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttrText;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService")
public class ContractServiceImpl
extends AbstractService
implements ContractService {
    private ContractDao contractDao;

    private ContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.getConnection(), this.userId);
        }
        return this.contractDao;
    }

    @PreDestroy
    private void destroy() {
        try {
            if (this.contractDao != null) {
                this.contractDao.close();
                this.contractDao = null;
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    @Override
    public Contract contractGet(int contractId) throws Exception {
        return (Contract)this.getContractDao().get(contractId);
    }

    @Override
    public Contract contractByTitle(String contractTitle) throws Exception {
        return this.getContractDao().getByTitle(contractTitle);
    }

    @Override
    public void contractGroupRemove(int contractId, int contractGroupId) throws Exception {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
        ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
        if (contractGroup == null) {
            throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        if (!contractGroup.isEditable()) {
            throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
        }
        new ContractManager(this.getConnection()).deleteContractGroup(contractId, contractGroupId);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public void contractGroupAdd(int contractId, int contractGroupId) throws Exception {
        if (contractId < 0 || contractGroupId < 0) {
            return;
        }
        Directory<ContractGroup> contractGroupDir = this.context.getDirectory(ContractGroup.class, 0);
        ContractGroup contractGroup = contractGroupDir.get(contractGroupId);
        if (contractGroup == null) {
            throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        if (!contractGroup.isEditable()) {
            throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u044f\u0442\u044c \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e (\u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430).");
        }
        new ContractManager(this.getConnection()).addContractGroup(contractId, contractGroupId);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public List<Contract> contractSubList(int contractId, int subMode, boolean withSuperContractId, Date onDate) throws Exception {
        Contract contract = null;
        ArrayList<Contract> list = new ArrayList<Contract>();
        if (subMode == 0 || withSuperContractId) {
            contract = (Contract)this.getContractDao().get(contractId);
        }
        if (subMode == 0) {
            list.addAll(this.getContractDao().getContracts(contract.getDependSubList()).stream().filter(a -> onDate == null || TimeUtils.dateInPeriod((Date)onDate, (Period)new Period(a.getDateFrom(), a.getDateTo()))).toList());
        } else {
            list.addAll(this.getContractDao().getSubContracts(contractId, subMode).stream().filter(a -> onDate == null || TimeUtils.dateInPeriod((Date)onDate, (Period)new Period(a.getDateFrom(), a.getDateTo()))).toList());
        }
        if (withSuperContractId) {
            list.add(0, contract);
        }
        return list;
    }

    @Override
    public SearchResult<ContractSearchDto> searchContractByParameter(ContractSearchParam contractSearchParam) throws Exception {
        Objects.requireNonNull(contractSearchParam, "contractSearchParam must be not null");
        SearchResult searchResult = new SearchResult(contractSearchParam.getPage());
        if (contractSearchParam.getEntityFilter().isEmpty()) {
            return searchResult;
        }
        ContractFilters contractFilters = new ContractFilters().setContractId(contractSearchParam.getContractId()).setFaceType(contractSearchParam.getFaceType()).setSubContracts(contractSearchParam.isShowSubContracts()).setClosed(contractSearchParam.isShowClosed()).setHidden(contractSearchParam.isShowHidden());
        FilterEntityAttr filterEntityAttr = contractSearchParam.getEntityFilter().get(0);
        if (filterEntityAttr instanceof FilterEntityAttrText) {
            FilterEntityAttrText attrText = (FilterEntityAttrText)filterEntityAttr;
            this.getContractDao().searchContractByParameterText((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrText);
        } else if (filterEntityAttr instanceof FilterEntityAttrDate) {
            FilterEntityAttrDate attrDate = (FilterEntityAttrDate)filterEntityAttr;
            this.getContractDao().searchContractByParameterDate((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrDate);
        } else if (filterEntityAttr instanceof FilterEntityAttrEmail) {
            FilterEntityAttrEmail attrEmail = (FilterEntityAttrEmail)filterEntityAttr;
            this.getContractDao().searchContractByParameterEmail((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrEmail);
        } else if (filterEntityAttr instanceof FilterEntityAttrMultiList) {
            FilterEntityAttrMultiList attrMultiList = (FilterEntityAttrMultiList)filterEntityAttr;
            this.getContractDao().searchContractByParameterMultiList((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrMultiList);
        } else if (filterEntityAttr instanceof FilterEntityAttrList) {
            FilterEntityAttrList attrList = (FilterEntityAttrList)filterEntityAttr;
            this.getContractDao().searchContractByParameterList((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrList);
        } else if (filterEntityAttr instanceof FilterEntityAttrPhone) {
            FilterEntityAttrPhone attrPhone = (FilterEntityAttrPhone)filterEntityAttr;
            this.getContractDao().searchContractByParameterPhone((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrPhone);
        } else if (filterEntityAttr instanceof FilterEntityAttrAddress) {
            FilterEntityAttrAddress attrAddress = (FilterEntityAttrAddress)filterEntityAttr;
            this.getContractDao().searchContractByParameterAddress((SearchResult<ContractSearchDto>)searchResult, contractFilters, attrAddress);
        }
        return searchResult;
    }

    @Override
    public SearchResult<ContractSearchDto> searchContractByObjectParameter(ContractSearchParam contractSearchParam) throws Exception {
        return null;
    }

    @Override
    public SearchResult<ContractSearchDto> searchContractList(ContractSearchParam contractSearchParam) throws Exception {
        List<Contract> findedContracts;
        String title = contractSearchParam.getContractTitle();
        String comment = contractSearchParam.getContractComment();
        boolean inAllLabels = contractSearchParam.isInAllLabels();
        List<FilterEntityAttr> entityFilter = contractSearchParam.getEntityFilter();
        Set<Integer> labelsIds = contractSearchParam.getContractLabelsIds();
        ContractFilters contractFilters = new ContractFilters().setContractId(contractSearchParam.getContractId()).setFaceType(contractSearchParam.getFaceType()).setSubContracts(contractSearchParam.isShowSubContracts()).setClosed(contractSearchParam.isShowClosed()).setHidden(contractSearchParam.isShowHidden());
        Page page = Optional.ofNullable(contractSearchParam.getPage()).orElse(new Page(1, 25));
        if (title != null && comment != null) {
            contractFilters.setTitle(title).setComment(comment);
            findedContracts = this.getContractDao().list(contractFilters, entityFilter, page, labelsIds, inAllLabels);
        } else if (comment != null) {
            contractFilters.setComment(comment);
            findedContracts = this.getContractDao().list(contractFilters, entityFilter, page, labelsIds, inAllLabels);
        } else if (title != null) {
            contractFilters.setTitle(title);
            findedContracts = this.getContractDao().list(contractFilters, entityFilter, page, labelsIds, inAllLabels);
            if (Utils.isEmptyCollection(findedContracts)) {
                contractFilters.setTitle(null).setComment(title);
                findedContracts = this.getContractDao().list(contractFilters, entityFilter, page, labelsIds, inAllLabels);
            }
        } else {
            findedContracts = this.getContractDao().list(contractFilters, entityFilter, page, labelsIds, inAllLabels);
        }
        contractSearchParam.setPage(page);
        SearchResult searchResult = new SearchResult(page);
        searchResult.setList(findedContracts.stream().map(a -> new ContractSearchDto().setContractId(a.getId()).setContractTitle(a.getTitle()).setContractComment(a.getComment()).setPeriod(new Period(a.getDateFrom(), a.getDateTo()))).toList());
        return searchResult;
    }

    @Override
    public SearchResult<ContractSearchDto> contractList(int contractId, String title, String comment, int fc, long groupMask, List<FilterEntityAttr> entityFilter, boolean subContracts, boolean closed, boolean hidden, Page page) throws Exception {
        ContractSearchParam contractSearchParam = new ContractSearchParam().setContractId(contractId).setContractTitle(title).setContractComment(comment).setFaceType(fc).setContractLabelsIds(new HashSet<Integer>(Utils.toIntegerList((String)Utils.maskToEnum((long)groupMask)))).setEntityFilter(entityFilter).setShowSubContracts(subContracts).setShowClosed(closed).setShowHidden(hidden).setInAllLabels(false).setPage(page);
        return this.searchContractList(contractSearchParam);
    }

    @Override
    public void contractPasswordUpdate(int contractId, String password, boolean generate) throws Exception {
        if (contractId < 0) {
            throw new BGIllegalArgumentException();
        }
        if (generate) {
            password = PswdGen.generatePassword((ParameterMap)this.getSetup());
        } else {
            int passwordMin = PswdGen.getPasswordLengthMin((ParameterMap)this.getSetup());
            int passwordMax = PswdGen.getPasswordLengthMax((ParameterMap)this.getSetup());
            String passwordChars = PswdGen.getPasswordChars((ParameterMap)this.getSetup());
            if (Utils.isEmptyString((String)password)) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if ((password = password.trim()).length() < passwordMin || password.length() > passwordMax) {
                throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!");
            }
            if (!PswdGen.checkChars(password, passwordChars)) {
                throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432: " + passwordChars);
            }
        }
        this.getContractDao().updatePassword(contractId, password);
        this.context.publishAfterCommit(new ContractPasswordChangedEvent(this.userId, contractId, password));
        new ContractPasswordLogDao(this.getConnection()).addContractPasswordLogItem(ContractPasswordLogItem.builder().setDatetime(new Date()).setContractId(contractId).setUserId(this.userId).build());
    }

    @Override
    public void sendWebPasswordOfContractToEmail(String email, int contractId) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Setup setup = Setup.getSetup();
            Contract contract = (Contract)contractDao.get(contractId);
            String messageBody = "URL \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0430): " + setup.get("web.mail.server.url", null) + "\n\u041b\u043e\u0433\u0438\u043d:  \t" + contract.getTitle() + "\n\u041f\u0430\u0440\u043e\u043b\u044c: \t" + contract.getPassword();
            new MailMsg(setup).sendMessage(new MailSendWebPassword().setRecipients(email.replaceAll("\n", ", ")).setSubject("\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 " + contract.getTitle()).addTextPart("text", messageBody));
        }
    }

    @Override
    public boolean hasModuleInstance(int contractId, int moduleId) throws Exception {
        return new ContractModuleManager(this.getConnection()).getContractModuleSet(contractId).contains(moduleId);
    }

    @Override
    public void contractPasswordReset(int contractId, String email) throws Exception {
        Setup setup = Setup.getSetup();
        Connection con = this.getConnection();
        Contract contract = this.contractGet(contractId);
        if (contract == null) {
            throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "passwordReset.contract.notFound");
        }
        int paramId = setup.getInt("contract.password.forgot.email.param.id", -1);
        try (ContractDao contractDao = new ContractDao(con, this.userId);
             ContractParameterManager contractParameterManager = new ContractParameterManager(con);){
            Integer authMode;
            String contractEmail = contractDao.getEmailFromContractParameter(contractId, paramId);
            if (contractEmail == null) {
                throw new BGMessageException("Email \u0434\u043b\u044f \u0441\u0431\u0440\u043e\u0441\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d", "passwordReset.email.notFound");
            }
            if (email != null && !this.checkEmail(email, contractEmail)) {
                throw new BGMessageException("Email \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", "passwordReset.email.notValid");
            }
            PasswordManager passwordManager = new PasswordManager(con);
            long passwordExpireHour = setup.getLong("contract.password.forgot.expire.hour", 24L);
            Object emailLink = setup.get("contract.password.forgot.link", "http://localhost:8080/bgbilling/webexecuter?action=ChangePassword&mid=contract&passwordOnce=${password}");
            String emailSubject = setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f");
            String emailText = setup.get("contract.password.forgot.email.body", "\u0414\u043b\u044f \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract} - \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0438\u0436\u0435 (\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 {hour} \u0447\u0430\u0441\u043e\u0432) \u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
            String charArray = setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
            String password = passwordManager.getOncePassword(charArray);
            HashMap<Integer, Integer> authModes = new HashMap<Integer, Integer>();
            String modes = setup.get("web.auth.modes", null);
            if (modes != null) {
                String[] parts = modes.split(";");
                for (int i = 0; i < parts.length; ++i) {
                    String[] mid_mode = parts[i].split(":");
                    if (mid_mode.length != 2) continue;
                    authModes.put(Utils.parseInt((String)mid_mode[0].trim(), (int)0), Utils.parseInt((String)mid_mode[1].trim(), (int)0));
                }
            }
            if ((authMode = (Integer)authModes.get(0)) != null && authMode > 0 && authMode < 3) {
                if (authMode == 1) {
                    passwordManager.deleteByContract(contract.getTitle());
                    passwordManager.addPassword(contract.getTitle(), passwordExpireHour, password);
                } else if (authMode == 2) {
                    paramId = setup.getInt("web.auth.contract.text.parameter", 0);
                    if (paramId > 0) {
                        String value = contractParameterManager.getTextlikeParam(contract.getId(), paramId);
                        passwordManager.deleteByContract(value);
                        passwordManager.addPassword(value, passwordExpireHour, password);
                    } else {
                        this.getLogger().error("Not set parameter 'web.auth.contract.text.parameter' in config!");
                    }
                }
                emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
                emailText = emailText.replaceAll("\\{hour\\}", String.valueOf(passwordExpireHour));
                emailLink = ((String)emailLink).contains("${password}") ? ((String)emailLink).replaceAll("\\$\\{password\\}", password) : (String)emailLink + "&passwordOnce=" + password;
                new MailMsg(setup).sendMessage(new MailContractPasswordReset().setPassword(password).setPasswordExpireHour(passwordExpireHour).setEmailLink((String)emailLink).setEmailText(emailText).setContractId(contractId).setRecipients(contractEmail).setSubject(emailSubject).addTextPart("text", emailText + "\n" + (String)emailLink));
                return;
            }
        }
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", "passwordReset.webAuthModes.notValid");
    }

    private boolean checkEmail(String email, String emailList) {
        boolean result;
        block1: {
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            StringTokenizer st = new StringTokenizer(emailList, "\n");
            email = email.toLowerCase();
            while (st.hasMoreTokens() && !(result = (token = st.nextToken().toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    @Override
    public int contractPasswordOnceCheck(String passwordOnce) throws Exception {
        PasswordManager passwordManager = new PasswordManager(this.getConnection());
        String contractTitle = passwordManager.findContractTitle(passwordOnce);
        passwordManager.deleteContractTitle(passwordOnce);
        Contract contract = this.getContractDao().getByTitle(contractTitle);
        if (contract != null) {
            return contract.getId();
        }
        return 0;
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMap(int contractId, int paramGroupId) throws Exception {
        Map<Integer, EntityAttr> result = this.getContractDao().getContractParameters(contractId, paramGroupId);
        if (this.userId != 0 && this.userId != 1 && result != null && result.size() > 0) {
            Iterator<Integer> iter = result.keySet().iterator();
            while (iter.hasNext()) {
                if (PermissionOfRoles.checkReadContractParameter(iter.next(), this.userId)) continue;
                iter.remove();
            }
        }
        return new MapHolder(result);
    }

    @Override
    @Deprecated
    public ContractParameterGroup contractParameterGroupGet(int id) throws Exception {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    @Deprecated
    public List<ContractParameterGroup> contractParameterGroupList() throws Exception {
        return this.context.getDirectory(ContractParameterGroup.class, 0).list();
    }

    @Override
    public SearchResult<ContractHistoryRecord> searchContractHistoryRecord(Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        new ContractHistoryRecordDao(this.getConnection()).searchContractHistoryRecord((SearchResult<ContractHistoryRecord>)searchResult, this.userId);
        return searchResult;
    }

    @Override
    public void updateContractHistoryRecord(int contractId) throws Exception {
        ContractHistoryRecord contractHistoryRecord = new ContractHistoryRecord().setContractId(contractId).setUserId(this.userId).setLastOpen(new Date());
        new ContractHistoryRecordDao(this.getConnection()).update(contractHistoryRecord);
    }

    @Override
    public String contractModuleConfigGet(int contractId, int moduleId, String key) throws Exception {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);){
            String string = contractModuleConfigDao.get(contractId, key);
            return string;
        }
    }

    @Override
    public void contractModuleConfigSet(int contractId, int moduleId, String key, String value) throws Exception {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), moduleId);){
            if (Utils.isBlankString((String)value)) {
                contractModuleConfigDao.delete(contractId, key);
            } else {
                contractModuleConfigDao.update(contractId, key, value);
            }
        }
    }

    @Override
    public void contractDomainUpdate(int contractId, int domainId) throws Exception {
        int oldDomainId = ((Contract)this.getContractDao().get(contractId)).getDomainId();
        this.getContractDao().updateDomain(contractId, domainId);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        this.context.publishAfterCommit(new ContractDomainModifiedEvent(contractId, oldDomainId, domainId, this.userId));
    }

    @Override
    public void contractsDomainUpdate(List<Integer> contractIds, int domainId) {
        if (contractIds != null) {
            contractIds.forEach(contractId -> {
                try {
                    this.contractDomainUpdate((int)contractId, domainId);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            });
        }
    }

    @Override
    public EntityAttr contractParameterGet(int contractId, int parameterId) throws Exception {
        if (this.userId != 0 && this.userId != 1 && !PermissionOfRoles.checkReadContractParameter(parameterId, this.userId)) {
            throw new BGIllegalAccessException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u043e\u0441\u043c\u0430\u0442\u0440\u0438\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440");
        }
        return this.getContractDao().getContractParameter(contractId, parameterId);
    }

    @Override
    public void contractUpdate(int contractId, Contract contract) throws Exception {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        if (contract == null) {
            throw new BGIllegalArgumentException("contract");
        }
        if (contract.getId() <= 0) {
            contract.setId(contractId);
        } else if (contract.getId() != contractId) {
            throw new BGIllegalArgumentException("contractId");
        }
        this.getContractDao().update((Object)contract);
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contract.getId()));
    }

    @Override
    public MapHolder<Integer, EntityAttr> contractParameterMapByType(int contractId, int parameterType) throws Exception {
        MapHolder map = new MapHolder();
        List parametersIds = this.context.getService(ContractParameterService.class, this.moduleId).contractParameterGroupAttrList().stream().filter(a -> a.getType() == parameterType).map(Id::getId).collect(Collectors.toList());
        Iterator iterator = parametersIds.iterator();
        while (iterator.hasNext()) {
            int parameterId = (Integer)iterator.next();
            if (!PermissionOfRoles.checkReadContractParameter(parameterId, this.userId)) continue;
            map.getMap().put(parameterId, this.getContractDao().getContractParameter(contractId, parameterId));
        }
        return map;
    }

    @Override
    public void contractDelete(int contractId, boolean save, String folder) throws Exception {
        Contract contract = (Contract)this.getContractDao().get(contractId);
        if (contract != null) {
            if (contract.getSuperCid() != 0) {
                throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430!");
            }
            if (Utils.isBlankString((String)folder)) {
                folder = "/";
            }
            if (contractId < 0) {
                throw new BGIllegalArgumentException();
            }
            try (ContractRemover contractRemover = new ContractRemover(this.getConnection(), folder);){
                String error = contractRemover.removeContracts(Collections.singletonList(contractId), save);
                if (Utils.notBlankString((String)error)) {
                    throw new BGMessageException(error);
                }
            }
        }
    }

    @Override
    public String contractListByFilter(ContractFilters contractFilters, List<FilterEntityAttr> entityFilter, Holder<Page> pageHolder) throws Exception {
        Page page;
        if (pageHolder == null || (page = (Page)pageHolder.value) == null) {
            page = new Page(1, 25);
        }
        String list = this.getContractDao().contractListByFilter(contractFilters, entityFilter, page);
        if (pageHolder != null) {
            pageHolder.value = page;
        }
        return list;
    }

    @Override
    public JSONObject contractInfoGet(int contractId) throws Exception {
        boolean checkPermission;
        JSONObject contractInfo = new JSONObject();
        JSONObject contractJson = new JSONObject();
        contractInfo.put("contract", (Object)contractJson);
        this.addMainContractInfo(contractJson, contractId);
        this.addContractObjectsInfo(contractJson, contractId);
        this.addContractComment(contractJson, contractId);
        JSONObject infoJson = new JSONObject();
        contractInfo.put("info", (Object)infoJson);
        this.addContractLabelsInfoTree(infoJson, contractId);
        JSONArray tariffJson = new JSONArray();
        infoJson.put("tariff", (Object)tariffJson);
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        mapRequest.put("action", "PersonalTariffTable");
        mapRequest.put("module", "contract.tariff");
        ModuleAction action = FindAction.find(new String[]{"0"}, mapRequest);
        boolean bl = checkPermission = Setup.getSetup().getInt("bgsecure.check", 1) > 0;
        if (checkPermission || action == null || PermissionOfRoles.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            this.addPersonalContractTariffPlansInfo(tariffJson, contractId);
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractTariffPlans");
        mapRequest.put("module", "contract");
        action = FindAction.find(new String[]{"0"}, mapRequest);
        if (checkPermission || action == null || PermissionOfRoles.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            this.addGlobalContractTariffPlansInfo(tariffJson, contractId);
        }
        mapRequest.clear();
        mapRequest.put("action", "ContractBalanceGeneral");
        mapRequest.put("module", "contract");
        action = FindAction.find(new String[]{"0"}, mapRequest);
        if (checkPermission || action == null || PermissionOfRoles.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            this.addBalanceInfo(infoJson, contractId);
        }
        this.addModulesInfo(infoJson, contractId);
        mapRequest.clear();
        mapRequest.put("action", "ContractScriptTable");
        mapRequest.put("module", "contract");
        action = FindAction.find(new String[]{"0"}, mapRequest);
        if (checkPermission || action == null || PermissionOfRoles.getInstance().checkActionAllow(mapRequest, "0", action, this.userId, contractId) == null) {
            this.addScriptsInfo(infoJson, contractId);
        }
        this.addPluginsInfo(infoJson, contractId);
        return contractInfo;
    }

    private void addMainContractInfo(JSONObject contractJson, int contractId) throws Exception {
        block24: {
            Connection con = this.getConnection();
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                Contract contract = (Contract)contractDao.get(contractId);
                if (contract == null) break block24;
                contractJson.put("domainId", contract.getDomainId());
                contractJson.put("title", (Object)contract.getTitle());
                contractJson.put("comment", (Object)contract.getComment());
                contractJson.put("limit", (Object)Utils.formatBigDecimalSumm((BigDecimal)contract.getBalanceLimit()));
                contractJson.put("mode", (int)contract.getBalanceMode());
                contractJson.put("date1", (Object)TimeUtils.formatDate((Date)contract.getDateFrom()));
                contractJson.put("date2", (Object)TimeUtils.formatDate((Date)contract.getDateTo()));
                contractJson.put("fc", (int)contract.getPersonType());
                contractJson.put("del", contract.isHidden() ? 1 : 0);
                contractJson.put("status", (Object)StatusCache.getInstance().getStatusTitle(contract.getStatus()));
                if (contract.getSuperCid() == 0) {
                    contractJson.put("hierarchy", (Object)"independent");
                    break block24;
                }
                if (contract.getSuperCid() == -1) {
                    contractJson.put("hierarchy", (Object)"super");
                    try (PreparedStatement ps = con.prepareStatement("SELECT sub_mode FROM contract WHERE scid=?");){
                        ps.setInt(1, contractId);
                        int dep = 0;
                        int indep = 0;
                        try (ResultSet rs = ps.executeQuery();){
                            while (rs.next()) {
                                if (rs.getInt(1) == 0) {
                                    ++dep;
                                    continue;
                                }
                                ++indep;
                            }
                        }
                        contractJson.put("hierarchyDep", dep);
                        contractJson.put("hierarchyIndep", indep);
                        break block24;
                    }
                }
                if (contract.getBalanceSubMode() == 0) {
                    contractJson.put("hierarchy", (Object)"depend_sub");
                } else if (contract.getBalanceSubMode() == 1) {
                    contractJson.put("hierarchy", (Object)"independ_sub");
                }
            }
        }
    }

    private void addContractObjectsInfo(JSONObject contractJson, int contractId) throws Exception {
        String query = "SELECT ( isNUll(date1) OR not date1>now() ) AND ( isNull(date2) OR not date2<now() ) FROM object WHERE cid=?";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, contractId);
            int objectCountAll = 0;
            int objectCountActive = 0;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (rs.getBoolean(1)) {
                        ++objectCountActive;
                    }
                    ++objectCountAll;
                }
            }
            contractJson.put("objects", (Object)(objectCountActive + "/" + objectCountAll));
        }
    }

    private void addContractComment(JSONObject contractJson, int contractId) throws Exception {
        String query = "SELECT count(*) FROM contract_comment WHERE cid=?";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    contractJson.put("comments", (Object)rs.getString(1));
                }
            }
        }
    }

    private void addContractLabelsInfoTree(JSONObject infoJson, int contractId) throws Exception {
        JSONArray groupsJson = new JSONArray();
        infoJson.put("groups", (Object)groupsJson);
        ContractLabelManager contractLabelManager = new ContractLabelManager(this.getConnection());
        List<Integer> contractLabelIds = contractLabelManager.getContractLabelIds(contractId);
        List<ContractLabelItem> allItems = contractLabelManager.getContractLabelItemList(false);
        List contractItems = allItems.stream().filter(i -> contractLabelIds.contains(i.getId())).collect(Collectors.toList());
        Collections.sort(contractItems);
        for (ContractLabelItem item : contractItems) {
            JSONObject jsonItem = new JSONObject();
            jsonItem.put("id", item.getId());
            jsonItem.put("title", (Object)item.getTitle());
            groupsJson.put((Object)jsonItem);
        }
    }

    private void addPersonalContractTariffPlansInfo(JSONArray tariffPlansInfo, int contractId) throws Exception {
        for (PersonalTariff personalTariff : new PersonalTariffManager(this.getConnection()).getPersonalTariffList(contractId, new Date())) {
            JSONObject jsonItem = new JSONObject().put("id", personalTariff.getId()).put("title", (Object)("\u041f\u0422: " + personalTariff.getTitle()));
            tariffPlansInfo.put((Object)jsonItem);
        }
    }

    private void addGlobalContractTariffPlansInfo(JSONArray tariffPlansInfo, int contractId) throws Exception {
        String query = "SELECT t2.id, title FROM contract_tariff AS t1, tariff_plan AS t2 WHERE cid=? AND tpid=t2.id AND emid=0 AND eid=0 AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("id", rs.getInt(1));
                    jsonItem.put("title", (Object)rs.getString(2));
                    tariffPlansInfo.put((Object)jsonItem);
                }
            }
        }
    }

    private void addBalanceInfo(JSONObject infoJson, int contractId) throws Exception {
        JSONObject balanceJson = new JSONObject();
        infoJson.put("balance", (Object)balanceJson);
        LocalDate now = LocalDate.now();
        int yy = now.getYear();
        int mm = now.getMonthValue();
        Connection con = this.getConnection();
        try (BalanceDao balanceDao = new BalanceDao(con);){
            ContractBalance contractBalance = balanceDao.getContractBalance(contractId, yy, mm);
            GregorianCalendar paybackFrom = new GregorianCalendar();
            paybackFrom.set(contractBalance.getYear(), contractBalance.getMonth() - 1, 1, 0, 0, 0);
            Calendar paybackTo = (Calendar)((Calendar)paybackFrom).clone();
            paybackTo.add(2, 1);
            BigDecimal payback = new ChargeDao(con).getSum(contractId, paybackFrom.getTime(), paybackTo.getTime(), 0, 1, true);
            balanceJson.put("summa1", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.getIncomingSaldo()));
            balanceJson.put("summa2", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.getPayments()));
            balanceJson.put("summa3", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.getAccounts()));
            balanceJson.put("summa4", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.getCharges().subtract(payback)));
            balanceJson.put("summa5", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.toBalanceWithoutReserves()));
            balanceJson.put("summa6", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.toBalance()));
            balanceJson.put("summa7", (Object)Utils.formatBigDecimalSumm((BigDecimal)payback));
            balanceJson.put("summa8", (Object)Utils.formatBigDecimalSumm((BigDecimal)contractBalance.getReserve()));
            balanceJson.put("yy", contractBalance.getYear());
            balanceJson.put("mm", contractBalance.getMonth());
        }
    }

    private void addScriptsInfo(JSONObject infoJson, int contractId) throws Exception {
        JSONArray scriptJson = new JSONArray();
        infoJson.put("script", (Object)scriptJson);
        String query = "SELECT s.id, s.title FROM contract_script cs LEFT JOIN script s ON cs.script_id=s.id WHERE cid=? AND ( isNull( date1 ) OR date1<=CURDATE() ) AND ( isNull( date2 ) OR date2>=CURDATE() )";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JSONObject jsonItem = new JSONObject();
                    jsonItem.put("id", rs.getInt(1));
                    jsonItem.put("title", (Object)rs.getString(2));
                    scriptJson.put((Object)jsonItem);
                }
            }
        }
    }

    private void addModulesInfo(JSONObject infoJson, int contractId) throws Exception {
        JSONArray modulesJson = new JSONArray();
        infoJson.put("modules", (Object)modulesJson);
        Connection connection = this.getConnection();
        for (BGModule module : new ContractModuleManager(connection).getContractModules(contractId)) {
            JSONObject itemJson = new JSONObject();
            itemJson.put("id", module.getId());
            itemJson.put("title", (Object)module.getTitle());
            BGInstalledModule bgInstalledModule = module.getInstalledModule();
            if (bgInstalledModule != null) {
                itemJson.put("package", (Object)module.getInstalledModule().getPackageClient());
                String className = module.getInstalledModule().getPackageServer() + ".Module";
                ApplicationModule moduleClass = (ApplicationModule)Utils.newInstance((String)className, ApplicationModule.class);
                if (moduleClass != null) {
                    itemJson.put("status", (Object)moduleClass.getStatus(connection, module.getId(), contractId));
                }
            }
            modulesJson.put((Object)itemJson);
        }
    }

    private void addPluginsInfo(JSONObject infoJson, int contractId) throws Exception {
        JSONArray pluginsJson = new JSONArray();
        infoJson.put("plugins", (Object)pluginsJson);
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions("bitel.billing.server.contract.action.ActionContractInfo", true)) {
            Element extensionElement = extension.getElement();
            BGPluginServer plugin = (BGPluginServer)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("treeNode");
            for (int index = 0; index < list.getLength(); ++index) {
                Element treeNode = (Element)list.item(index);
                String key = plugin.getResourceString(treeNode.getAttribute("key"));
                String className = treeNode.getAttribute("class");
                PluginTreeNodeInterface node = (PluginTreeNodeInterface)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                JSONObject itemJson = new JSONObject();
                itemJson.put("key", (Object)key);
                itemJson.put("title", (Object)node.getTitle(this.context, contractId));
                itemJson.put("value", (Object)node.getValue(this.context, contractId));
                pluginsJson.put((Object)itemJson);
            }
        }
    }

    @Override
    public JSONObject contractTitleAndCommentGet(int contractId) throws Exception {
        JSONObject json = new JSONObject();
        if (contractId > 0) {
            ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
            Contract contract = (Contract)contractDao.get(contractId);
            contractDao.close();
            if (contract != null) {
                json.put("title", (Object)contract.getTitle());
                json.put("comment", (Object)contract.getComment());
            }
        }
        return json;
    }

    @Override
    public void contractTitleAndCommentUpdate(int contractId, String title, String comment, int patternId) throws Exception {
        if (contractId > 0) {
            Connection con = this.getConnection();
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                if (Utils.notBlankString((String)title) && new ContractPatternDao(con).isContractTitleDuplicated(title.trim(), false, contractId)) {
                    throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                }
                Contract contract = (Contract)contractDao.get(contractId);
                ContractPatternDao.removeContractTitleFromLastTitles(contract.getTitle());
                if (title != null) {
                    contract.setTitle(title.trim());
                }
                if (comment != null) {
                    contract.setComment(comment.trim());
                }
                if (patternId > -1) {
                    contract.setCommentPatternId(patternId);
                }
                contractDao.update((Object)contract);
            }
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
        }
    }

    @Override
    public JSONObject contractCommentPatternList(int contractId) throws Exception {
        JSONObject json = new JSONObject();
        if (contractId > 0) {
            Connection con = this.getConnection();
            try (ContractDao contractDao = new ContractDao(con, this.userId);){
                Contract contract = (Contract)contractDao.get(contractId);
                if (contract != null) {
                    json.put("contractPatternId", contract.getCommentPatternId());
                }
            }
        }
        JSONArray patterns = new JSONArray();
        JSONObject withoutPattern = new JSONObject();
        withoutPattern.put("id", 0);
        withoutPattern.put("title", (Object)"\u0411\u0435\u0437 \u0448\u0430\u0431\u043b\u043e\u043d\u0430");
        patterns.put((Object)withoutPattern);
        for (IdTitle idTitle : new CommentPatternManager(this.getConnection()).getContractCommentPatternList()) {
            JSONObject item = new JSONObject();
            item.put("id", idTitle.getId());
            item.put("title", (Object)idTitle.getTitle());
            patterns.put((Object)item);
        }
        json.put("patterns", (Object)patterns);
        return json;
    }

    @Override
    public String contractCommentPatternValue(int contractId, int patternId) throws Exception {
        if (patternId > 0 && contractId > 0) {
            return new CommentPatternManager(this.getConnection()).transformValueToComment(patternId, contractId);
        }
        return "";
    }

    @Override
    public List<ContractCard> contractCardList(int contractId) throws Exception {
        ArrayList<ContractCard> cards = new ArrayList<ContractCard>();
        String card = "";
        Contract contract = null;
        if (contractId > 0) {
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                contract = (Contract)contractDao.get(contractId);
            }
        }
        Setup setup = Setup.getSetup();
        int i = 1;
        while (card != null) {
            String[] arr;
            card = setup.get("contractcard." + i, null);
            if (card != null && (arr = card.split(":", 3)).length > 1 && (contract == null || arr.length <= 2 || (contract.getGroups() & Utils.enumToMask((String)arr[2])) != 0L)) {
                cards.add(new ContractCard().setId(String.valueOf(i)).setTitle(arr[1]));
            }
            ++i;
        }
        EventProcessor.getInstance().request(new GetContractCardsListEvent(this.userId, contractId, cards));
        return cards;
    }

    @Override
    public void contractParameterUpdate(int contractId, EntityAttr entityAttr) throws Exception {
        ContractParameterListItem item;
        EntityAttrList a;
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId=" + contractId);
        }
        if (entityAttr == null) {
            throw new BGIllegalArgumentException("entityAttr==null");
        }
        if (entityAttr.getEntityId() != 0 && contractId != entityAttr.getEntityId()) {
            throw new BGIllegalArgumentException("entityAttr.entityId");
        }
        entityAttr.setEntityId(contractId);
        this.getContractDao().checkContractParameter(entityAttr);
        if (entityAttr instanceof EntityAttrList && (a = (EntityAttrList)entityAttr).getValue() > 0 && (item = this.context.getDirectory(ContractParameterListItem.class, a.getEntitySpecAttrId()).get(a.getValue())) != null && item.getId() == a.getValue()) {
            a.setTitle(item.getTitle());
        }
        if (entityAttr instanceof EntityAttrText) {
            ValidateTextParamEvent event = new ValidateTextParamEvent(contractId, ((EntityAttrText)entityAttr).getValue());
            event = EventProcessor.getInstance().request(event);
            if (Utils.notBlankString((String)event.getError())) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438: " + event.getError());
            }
        }
        ContractParamBeforeChangeEvent checkEvent = new ContractParamBeforeChangeEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr);
        checkEvent = EventProcessor.getInstance().request(checkEvent);
        if (Utils.notBlankString((String)checkEvent.getError())) {
            throw new BGMessageException(checkEvent.getError());
        }
        this.getContractDao().updateContractParameter(contractId, entityAttr);
        this.context.publishAfterCommit(new ContractCommentUpdateEvent(this.userId, contractId));
        this.context.publishAfterCommit(new ContractParamChangedEvent(this.userId, contractId, entityAttr.getEntitySpecAttrId(), entityAttr));
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }

    @Override
    public void contractParameterTextUpdate(int contractId, EntityAttrText parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterDateUpdate(int contractId, EntityAttrDate parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterBooleanUpdate(int contractId, EntityAttrBoolean parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterPhoneUpdate(int contractId, EntityAttrPhone parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterListUpdate(int contractId, EntityAttrList parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterIntUpdate(int contractId, EntityAttrInt parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterAddressUpdate(int contractId, EntityAttrAddress parameter) throws Exception {
        if (parameter != null && parameter.getHouseId() > 0 && parameter.getTitle() == null) {
            String key = Optional.ofNullable(parameter.getFormatKey()).filter(a -> !a.isBlank()).orElse("0");
            this.context.getService(AddressService.class, 0).addressFormat(parameter, EntityType.CONTRACT_PARAMETER).stream().filter(a -> a.getKey().equals(key)).forEach(a -> {
                parameter.setTitle(a.getValue());
                parameter.setFormatKey(a.getKey());
            });
        }
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterEmailUpdate(int contractId, EntityAttrEmail parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterContractUpdate(int contractId, EntityAttrContract parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public void contractParameterMultiListUpdate(int contractId, EntityAttrMultiList parameter) throws Exception {
        this.contractParameterUpdate(contractId, (EntityAttr)parameter);
    }

    @Override
    public List<ConfigParameter> configParameterList(String className) throws Exception {
        if (Utils.isEmptyString((String)className)) {
            return Collections.emptyList();
        }
        ArrayList<ConfigParameter> configParameters = new ArrayList<ConfigParameter>();
        try {
            Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
            Method method = clazz.getMethod("configParameterList", new Class[0]);
            Object object = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            configParameters.addAll((List)method.invoke(object, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configParameters;
    }

    @Override
    public ContractPattern contractPatternGet(int patternId) throws Exception {
        return new ContractPatternDao(this.getConnection()).getPattern(patternId);
    }

    @Override
    public void contractPatternDelete(int patternId) throws Exception {
        new ContractPatternDao(this.getConnection()).delete(patternId);
    }

    @Override
    public List<ContractParameterHistoryData> contractParameterHistoryList(int contractId, int parameterId, int parameterType) throws Exception {
        return new ContractParameterManager(this.getConnection()).getParameterHistory(contractId, parameterId).stream().map(a -> ContractParameterHistoryData.builder().setWho(a.getUser()).setWhen(TimeUtils.convertDateToLocalDateTime((Date)a.getDate())).setValue(PermissionOfRoles.checkReadContractParameter(parameterId, this.userId) ? (a.getValue() == null ? "\u0423\u0414\u0410\u041b\u0415\u041d\u041e" : a.getValue()) : "<\u0421\u041a\u0420\u042b\u0422\u041e>").build()).toList();
    }

    @Override
    public int contractCreate(ContractCreateData data) throws Exception {
        if (data.getPatternId() < 0) {
            throw new BGIllegalArgumentException();
        }
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            ContractPatternDao contractPatternDao = new ContractPatternDao(this.getConnection());
            if (data.getContractSuperId() > 0) {
                Contract superContract = (Contract)contractDao.get(data.getContractSuperId());
                if (superContract.isSub()) {
                    throw new BGMessageException("\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0441\u0443\u043f\u0435\u0440\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u044b\u0441\u0442\u0443\u043f\u0430\u0442\u044c \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                }
                ContractAddingSubEvent event = new ContractAddingSubEvent(this.userId, superContract, null);
                EventProcessor.getInstance().request(event);
                if (Utils.notBlankString((String)event.getError())) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + event.getError());
                }
            }
            data.setPassword(PswdGen.generatePassword((ParameterMap)Setup.getSetup()));
            if (Utils.notBlankString((String)data.getTitle()) && !contractDao.checkContractTitleOnDublication(data.getTitle(), -1)) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            ContractPattern contractPattern = contractPatternDao.getPattern(data.getPatternId());
            if (contractPattern != null && Utils.notBlankString((String)contractPattern.getMasterHandlerClass())) {
                try {
                    PatternContractMasterHandler handler = DynamicClassManager.getInstance().newInstance(PatternContractMasterHandler.class, contractPattern.getMasterHandlerClass());
                    handler.validateContractParameters(data);
                    handler.validateTariffs(data);
                }
                catch (Exception ex) {
                    throw new BGMessageException(ex.getMessage());
                }
            }
            Contract cont = contractDao.createFromPattern(data, true);
            if (data.getCopyParameterIds() != null && !data.getCopyParameterIds().isEmpty()) {
                String where = "cid=" + data.getContractSuperId() + " AND pid IN (" + Utils.toString(data.getCopyParameterIds()) + ")";
                HashMap<String, ColumnValue> valuesPairs = new HashMap<String, ColumnValue>();
                valuesPairs.put("cid", new ColumnValue(true, cont.getId()));
                try (ContractParameterManager contractParameterManager = new ContractParameterManager(this.getConnection());){
                    contractParameterManager.copyContractParams(where, valuesPairs);
                }
            }
            if (data.getContractParameters() != null) {
                data.getContractParameters().forEach(a -> {
                    try {
                        this.contractParameterUpdate(cont.getId(), (EntityAttr)a);
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                });
            }
            new CommentPatternManager(this.getConnection()).updateContractComment(cont.getId());
            if (!this.getConnection().getAutoCommit()) {
                this.getConnection().commit();
            }
            EventProcessor.getInstance().request(new ContractCreatedEvent(cont, this.userId, data.getPatternId()));
            int n = cont.getId();
            return n;
        }
    }

    @Override
    public void contractCreateValidateParameters(ContractCreateData contractCreateData) throws Exception {
        block7: {
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                ContractPatternDao contractPatternDao = new ContractPatternDao(this.getConnection());
                ContractPattern contractPattern = contractPatternDao.getPattern(contractCreateData.getPatternId());
                if (contractPattern == null || !Utils.notBlankString((String)contractPattern.getMasterHandlerClass())) break block7;
                try {
                    DynamicClassManager.getInstance().newInstance(PatternContractMasterHandler.class, contractPattern.getMasterHandlerClass()).validateContractParameters(contractCreateData);
                }
                catch (Exception ex) {
                    throw new BGMessageException(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void contractCreateValidateTariffs(ContractCreateData contractCreateData) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            ContractPatternDao contractPatternDao = new ContractPatternDao(this.getConnection());
            ContractPattern contractPattern = contractPatternDao.getPattern(contractCreateData.getPatternId());
            if (contractPattern != null && Utils.notBlankString((String)contractPattern.getMasterHandlerClass())) {
                DynamicClassManager.getInstance().newInstance(PatternContractMasterHandler.class, contractPattern.getMasterHandlerClass()).validateTariffs(contractCreateData);
            }
        }
    }

    @Override
    public void contractModuleAdd(int contractId, List<Integer> moduleIds) throws Exception {
        ContractModuleManager manager = new ContractModuleManager(this.getConnection());
        for (int moduleId : moduleIds) {
            if (moduleId <= 0) continue;
            manager.addContractModule(contractId, moduleId);
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
            EventProcessor.getInstance().request(new ContractModifiedModuleEvent(moduleId, contractId, this.userId, ContractModifiedModuleEvent.ModifiedModuleType.ADDED));
        }
    }

    @Override
    public void contractModuleDelete(int contractId, List<Integer> moduleIds) throws Exception {
        ContractModuleManager manager = new ContractModuleManager(this.getConnection());
        for (int moduleId : moduleIds) {
            manager.deleteContractModule(contractId, moduleId);
            this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
            EventProcessor.getInstance().request(new ContractModifiedModuleEvent(moduleId, contractId, this.userId, ContractModifiedModuleEvent.ModifiedModuleType.REMOVED));
        }
    }

    @Override
    public void contractDateToUpdate(int contractId, Date dateTo) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            contractDao.closeContract(contractId, this.moduleId, this.userId, dateTo);
        }
    }

    @Override
    public void contractParameterGroupSet(int contractId, int paramGroupId) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            contract.setParamGroupId(paramGroupId);
            contractDao.update((Object)contract);
        }
    }

    @Override
    public List<IdTitleValue> contractParameterList(int contractId) throws Exception {
        ContractParameterManager parameterManager = new ContractParameterManager(this.getConnection());
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
             ContractParameterGroupAttrDao groupAttrDao = new ContractParameterGroupAttrDao(this.getConnection());){
            Contract contract = (Contract)contractDao.get(contractId);
            if (contract != null) {
                List<ContractParameterGroupAttr> attrs = groupAttrDao.list(contract.getParamGroupId());
                List<Integer> parameterIds = attrs.stream().map(Id::getId).toList();
                HashMap<Integer, String> parameterValueMap = parameterManager.getValuesForPids(parameterIds, contractId);
                List<IdTitleValue> list = attrs.stream().filter(a -> a.getType() != EntitySpecAttrType.SERVICING_PERSON.getCode()).map(a -> new IdTitleValue(a.getId(), a.getTitle(), (String)parameterValueMap.get(a.getId()))).toList();
                return list;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public SearchResult<ContractPasswordLogItem> contractPasswordLogs(int contractId, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page, sort);
        new ContractPasswordLogDao(this.getConnection()).searchContractPasswordLogItemByContractId((SearchResult<ContractPasswordLogItem>)searchResult, contractId);
        return searchResult;
    }

    @Override
    public void contractModeUpdate(int contractId, ContractMode contractMode) throws Exception {
        try (ContractDao dao = new ContractDao(this.getConnection(), this.userId);){
            dao.updateMode(contractId, contractMode);
        }
    }

    @Override
    public void contractFaceUpdate(int contractId, ContractFace contractFace) throws Exception {
        try (ContractDao dao = new ContractDao(this.getConnection(), this.userId);){
            dao.updateFace(contractId, contractFace);
        }
    }

    @Override
    public void contractParametersCopy(int fromContractId, int toContractId, Set<Integer> parameterIds, String mode) throws Exception {
        String MODE_REPLACE = "replace";
        try (ContractDao contractDao = new ContractDao(this.getConnection(), 0);
             ContractParameterManager parameterManager = new ContractParameterManager(this.getConnection());){
            Map<Integer, EntityAttr> toParamMap = null;
            Map<Integer, MultiListParamValues> multiListParamMap = null;
            if (!"replace".equals(mode)) {
                toParamMap = contractDao.getContractParameters(toContractId, parameterIds);
                multiListParamMap = parameterManager.getMultiListParamValueMap(toContractId, parameterIds);
            }
            Map<Integer, EntityAttr> fromParamMap = contractDao.getContractParameters(fromContractId, parameterIds);
            for (Map.Entry<Integer, EntityAttr> entry : fromParamMap.entrySet()) {
                EntityAttr entityAttrPhone;
                EntityAttr entityAttr;
                boolean update;
                boolean bl = update = "replace".equals(mode) || !toParamMap.containsKey(entry.getKey());
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrText) {
                    EntityAttrText attrText = (EntityAttrText)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(toContractId, (EntityAttr)new EntityAttrText(toContractId, entry.getKey().intValue(), attrText.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrPhone) {
                    EntityAttrPhone attrPhone = (EntityAttrPhone)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    entityAttrPhone = new EntityAttrPhone(toContractId, entry.getKey().intValue());
                    entityAttrPhone.setContactList(attrPhone.getContactList());
                    contractDao.updateContractParameter(toContractId, entityAttrPhone);
                    continue;
                }
                if (update && (entityAttrPhone = entry.getValue()) instanceof EntityAttrEmail) {
                    EntityAttrEmail attrEmail = (EntityAttrEmail)entityAttrPhone;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    EntityAttrEmail entityAttrEmail = new EntityAttrEmail(toContractId, entry.getKey().intValue());
                    entityAttrEmail.setContactList(attrEmail.getContactList());
                    contractDao.updateContractParameter(toContractId, (EntityAttr)entityAttrEmail);
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrDate) {
                    EntityAttrDate attrDate = (EntityAttrDate)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(toContractId, (EntityAttr)new EntityAttrDate(toContractId, entry.getKey().intValue(), attrDate.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrBoolean) {
                    EntityAttrBoolean attrBoolean = (EntityAttrBoolean)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(toContractId, (EntityAttr)new EntityAttrBoolean(toContractId, entry.getKey().intValue(), attrBoolean.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrList) {
                    EntityAttrList attrList = (EntityAttrList)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(toContractId, (EntityAttr)new EntityAttrList(toContractId, entry.getKey().intValue(), attrList.getValue(), attrList.getTitle()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrAddress) {
                    EntityAttrAddress attrAddress = (EntityAttrAddress)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(toContractId, (EntityAttr)EntityAttrAddress.builder((int)toContractId, (int)entry.getKey()).setHouseId(attrAddress.getHouseId()).setPod(attrAddress.getPod()).setFloor(attrAddress.getFloor()).setFlat(attrAddress.getFlat()).setRoom(attrAddress.getRoom()).setComment(attrAddress.getComment()).setFormatKey(attrAddress.getFormatKey()).setTitle(attrAddress.getTitle()).build());
                    continue;
                }
                if (!update || !((entityAttr = entry.getValue()) instanceof EntityAttrContract)) continue;
                EntityAttrContract attrContract = (EntityAttrContract)entityAttr;
                if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                contractDao.updateContractParameter(toContractId, (EntityAttr)new EntityAttrContract(toContractId, entry.getKey().intValue(), attrContract.getValue(), attrContract.getTitle()));
            }
            for (Map.Entry<Integer, Object> entry : parameterManager.getMultiListParamValueMap(fromContractId, parameterIds).entrySet()) {
                if (!"replace".equals(mode) && multiListParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                parameterManager.updateMultiListParameterAndItems(toContractId, entry.getKey(), (MultiListParamValues)entry.getValue(), this.userId);
            }
        }
        new CommentPatternManager(this.getConnection()).updateContractComment(toContractId);
    }
}

