/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.CheckTreeCellRenderer;
import bitel.billing.module.common.ModTreeNode;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CheckTree
extends JTree {
    private DefaultTreeModel treeModel;
    private ModTreeNode treeTopNode;
    private ModTreeNode filteredRoot;
    private boolean conteintSearch;
    private String lastSerarchText;
    private CheckTreeCellRenderer cellRenderer = new CheckTreeCellRenderer();

    public CheckTree(ModTreeNode treeTopNode) {
        this(treeTopNode, null, null, null);
    }

    private CheckTree(ModTreeNode treeTopNode, String openIcon, String closedIcon, String leafIcon) {
        this.setTreeTopNode(treeTopNode);
        DefaultTreeCellRenderer r = this.cellRenderer.getTreeCellRenderer();
        if (openIcon != null) {
            r.setOpenIcon(ClientUtils.getIcon(openIcon));
        }
        if (closedIcon != null) {
            r.setClosedIcon(ClientUtils.getIcon(closedIcon));
        }
        if (leafIcon != null) {
            r.setLeafIcon(ClientUtils.getIcon(leafIcon));
        }
        this.setCellRenderer(this.cellRenderer);
        NodeSelectionListener l = new NodeSelectionListener();
        this.addMouseListener(l);
        this.addKeyListener(l);
    }

    public void setTreeTopNode(ModTreeNode treeTopNode) {
        this.treeTopNode = treeTopNode;
        this.treeModel = new DefaultTreeModel(treeTopNode);
        this.setModel(this.treeModel);
        this.repaint();
    }

    public void setCodes(String codes) {
        this.setCodes(codes, true);
    }

    public void setDisabledNode(String codes) {
        this.setCodes(codes, false);
    }

    private void setCodes(String codes, boolean select) {
        HashSet<String> codesSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(codes, ",");
        while (st.hasMoreTokens()) {
            codesSet.add(st.nextToken().trim());
        }
        if (select) {
            this.setNodeSelect(this.treeTopNode, codesSet);
        } else {
            this.setNodeDisable(this.treeTopNode, codesSet);
        }
        if (this.filteredRoot != null) {
            this.search(this.lastSerarchText, this.conteintSearch);
        }
        this.updateUI();
    }

    public void setNodeSelect(ModTreeNode node, Set<String> selectCodes) {
        node.setSel(selectCodes.remove(node.getAttribute("id")));
        boolean allChildsSelect = true;
        boolean anyoneChildSelect = false;
        int childs = node.getChildCount();
        for (int i = 0; i < childs; ++i) {
            ModTreeNode child = (ModTreeNode)node.getChildAt(i);
            this.setNodeSelect(child, selectCodes);
            allChildsSelect = allChildsSelect && child.isSel();
            anyoneChildSelect = anyoneChildSelect || child.isSel() || child.isMark();
        }
        node.setSel(node.isSel() || childs > 0 && allChildsSelect);
        node.setMark(anyoneChildSelect);
        this.selParentNodes(node);
        this.markParentNodes(node);
    }

    private void setNodeDisable(ModTreeNode node, Set<String> selectCodes) {
        node.setEn(!selectCodes.remove(node.getAttribute("id")));
        int childs = node.getChildCount();
        for (int i = 0; i < childs; ++i) {
            ModTreeNode child = (ModTreeNode)node.getChildAt(i);
            this.setNodeDisable(child, selectCodes);
        }
    }

    public String getCodes() {
        return this.getCodes(false);
    }

    public String getCodes(boolean leaf) {
        return this.getCodes(this.treeTopNode, leaf);
    }

    public String getCodes(ModTreeNode node, boolean leaf) {
        StringBuffer result = new StringBuffer(1500);
        this.getNodeSelect(node == null ? this.treeTopNode : node, result, leaf);
        return result.toString();
    }

    private void getNodeSelect(ModTreeNode node, StringBuffer buffer, boolean leaf) {
        if (node.isSel() && !node.getAttribute("id").equals("0") && (!leaf || "0".equals(node.getAttribute("type")))) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(node.getAttribute("id"));
        }
        int childs = node.getChildCount();
        for (int i = 0; i < childs; ++i) {
            ModTreeNode child = (ModTreeNode)node.getChildAt(i);
            this.getNodeSelect(child, buffer, leaf);
        }
    }

    public void setDefaultTree(String rootName) {
        ModTreeNode mainNode = new ModTreeNode();
        mainNode.setAttribute("id", "0");
        mainNode.setAttribute("type", "1");
        mainNode.setText(rootName);
        this.setTreeTopNode(mainNode);
    }

    public void setTreeFromDocument(Document doc, String dir) throws Exception {
        Element info = XMLUtils.selectElement(doc, dir);
        if (info.hasChildNodes()) {
            this.treeTopNode.removeAllChildren();
            this.treeTopNode.setSel(false);
            NodeList list = info.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                this.addNodes(this.treeTopNode, list.item(i), true);
            }
        }
        this.treeModel.reload();
        ClientUtils.expandTree(this, this.treeTopNode);
    }

    public void addNodes(ModTreeNode mainNode, Node addNode) {
        this.addNodes(mainNode, addNode, false);
    }

    public void addNodes(ModTreeNode mainNode, Node addNode, boolean enBranch) {
        String id = XMLUtils.getAttribute((Element)addNode, "id", "-1");
        String title = XMLUtils.getAttribute((Element)addNode, "title", "?");
        String type = XMLUtils.getAttribute((Element)addNode, "type", "0");
        String edit = XMLUtils.getAttribute((Element)addNode, "edit", "0");
        ModTreeNode node = new ModTreeNode(title);
        if ("1".equals(type)) {
            node.setEn(enBranch);
        }
        node.setAttribute("id", id);
        node.setAttribute("title", title);
        node.setAttribute("edit", edit);
        node.setAttribute("type", type);
        mainNode.add(node);
        this.expandPath(new TreePath(node));
        NodeList list = addNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            this.addNodes(node, list.item(i), enBranch);
        }
    }

    public void selNodes(ModTreeNode mainNode) {
        ModTreeNode node = mainNode;
        if (node.isEn()) {
            node.setSel(true);
        }
        for (int i = 0; i < mainNode.getChildCount(); ++i) {
            this.selNodes((ModTreeNode)mainNode.getChildAt(i));
        }
    }

    public void deselectNode(ModTreeNode node) {
        if (node.isEn()) {
            node.setSel(false);
            node.setMark(false);
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            ModTreeNode child = (ModTreeNode)node.getChildAt(i);
            this.deselectNode(child);
        }
    }

    private void selParentNodes(ModTreeNode node) {
        boolean allSel = true;
        if (node.getParent() == null) {
            return;
        }
        for (int i = 0; i < node.getParent().getChildCount(); ++i) {
            ModTreeNode child = (ModTreeNode)node.getParent().getChildAt(i);
            boolean bl = allSel = allSel && child.isSel();
            if (!allSel) break;
        }
        if (allSel) {
            ModTreeNode parentNode = (ModTreeNode)node.getParent();
            parentNode.setSel(true);
            this.selParentNodes(parentNode);
        }
    }

    private void markParentNodes(ModTreeNode node) {
        if (node.getParent() == null) {
            return;
        }
        boolean anyoneChildSel = false;
        for (int i = 0; i < node.getParent().getChildCount(); ++i) {
            ModTreeNode child = (ModTreeNode)node.getParent().getChildAt(i);
            boolean bl = anyoneChildSel = child.isMark() || child.isSel();
            if (anyoneChildSel) break;
        }
        ((ModTreeNode)node.getParent()).setMark(anyoneChildSel);
        this.markParentNodes((ModTreeNode)node.getParent());
    }

    private void clearParentNodes(ModTreeNode mainNode) {
        if (mainNode.getParent() == null) {
            return;
        }
        ModTreeNode parentNode = (ModTreeNode)mainNode.getParent();
        parentNode.setSel(false);
        this.clearParentNodes(parentNode);
    }

    public void search(String text, boolean conteintSearch) {
        this.conteintSearch = conteintSearch;
        if (Utils.isBlankString(text)) {
            this.cellRenderer.setSearchText(null, conteintSearch, false);
            this.treeModel.setRoot(this.treeTopNode);
            this.filteredRoot = null;
        } else {
            String textLow = text.trim().toLowerCase();
            if (this.lastSerarchText == null || textLow.length() < 2 || !textLow.substring(0, textLow.length() - 1).equals(this.lastSerarchText)) {
                this.filteredRoot = this.copyNode(this.treeTopNode);
            }
            TreeNodeBuilder builder = new TreeNodeBuilder(textLow);
            this.filteredRoot = builder.cut((ModTreeNode)this.filteredRoot.getRoot());
            this.cellRenderer.setSearchText(text, conteintSearch, false);
            this.treeModel.setRoot(this.filteredRoot);
            this.updateUI();
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.expandRow(i);
            }
            ModTreeNode leaf = (ModTreeNode)this.filteredRoot.getNextNode();
            int count = this.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (leaf == null) continue;
                ModTreeNode nextLeaf = (ModTreeNode)leaf.getNextNode();
                if (leaf.getAttribute("col") != null) {
                    this.collapsePath(new TreePath(leaf.getPath()));
                }
                leaf = nextLeaf;
            }
            this.lastSerarchText = text;
        }
    }

    private ModTreeNode copyNode(ModTreeNode orig) {
        ModTreeNode newOne = new ModTreeNode(orig.getText());
        newOne.setUserObject(orig.getUserObject());
        newOne.setSel(orig.isSel());
        newOne.setAttribute("OrigPath", orig.getPath());
        Enumeration<TreeNode> enm = orig.children();
        while (enm.hasMoreElements()) {
            ModTreeNode child = (ModTreeNode)enm.nextElement();
            newOne.add(this.copyNode(child));
        }
        return newOne;
    }

    private final class NodeSelectionListener
    extends MouseAdapter
    implements KeyListener {
        private NodeSelectionListener() {
        }

        private void action(ModTreeNode node) {
            if (node == null || !node.isEn()) {
                return;
            }
            boolean isSelected = !node.isSel();
            node.setSel(isSelected);
            if (isSelected && node.getChildCount() != 0) {
                CheckTree.this.selNodes(node);
            }
            if (isSelected) {
                CheckTree.this.selParentNodes(node);
            } else {
                CheckTree.this.clearParentNodes(node);
            }
            if (!isSelected) {
                CheckTree.this.deselectNode(node);
                this.checkAllTree(CheckTree.this.filteredRoot != null ? CheckTree.this.filteredRoot : CheckTree.this.treeTopNode);
                this.checkAllTree2(CheckTree.this.filteredRoot != null ? CheckTree.this.filteredRoot : CheckTree.this.treeTopNode);
            }
            CheckTree.this.markParentNodes(node);
            CheckTree.this.repaint();
        }

        private boolean checkAllTree(ModTreeNode node) {
            if (node.getChildCount() != 0) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    ModTreeNode child = (ModTreeNode)node.getChildAt(i);
                    if (!this.checkAllTree(child)) continue;
                    return false;
                }
            } else {
                CheckTree.this.selParentNodes(node);
                return true;
            }
            return false;
        }

        private boolean checkAllTree2(ModTreeNode node) {
            if (node.getChildCount() != 0) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    ModTreeNode child = (ModTreeNode)node.getChildAt(i);
                    if (!this.checkAllTree2(child)) continue;
                    return false;
                }
            } else {
                CheckTree.this.markParentNodes(node);
                return true;
            }
            return false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int y;
            int x = e.getX();
            int row = CheckTree.this.getRowForLocation(x, y = e.getY());
            TreePath path = CheckTree.this.getPathForRow(row);
            if (path != null) {
                ModTreeNode selectNode = (ModTreeNode)path.getLastPathComponent();
                if (SwingUtilities.isLeftMouseButton(e) && selectNode != null) {
                    this.action(selectNode);
                    if (CheckTree.this.filteredRoot != null) {
                        TreeNode[] origPath = (TreeNode[])selectNode.getAttribute("OrigPath");
                        this.action((ModTreeNode)origPath[origPath.length - 1]);
                    }
                }
            }
        }

        @Override
        public final void keyReleased(KeyEvent keyevent) {
            int i = keyevent.getKeyCode();
            if (i == 32 || i == 10) {
                ModTreeNode selectNode = (ModTreeNode)CheckTree.this.getLastSelectedPathComponent();
                this.action(selectNode);
                if (CheckTree.this.filteredRoot != null) {
                    TreeNode[] origPath = (TreeNode[])selectNode.getAttribute("OrigPath");
                    this.action((ModTreeNode)origPath[origPath.length - 1]);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    public class TreeNodeBuilder {
        private String textToMatch;

        public TreeNodeBuilder(String textToMatch) {
            this.textToMatch = textToMatch;
        }

        public ModTreeNode cut(ModTreeNode root) {
            boolean badLeaves = true;
            while (badLeaves) {
                badLeaves = this.removeBadLeaves(root);
            }
            root = this.replaceLastLeafs(root);
            return root;
        }

        private boolean removeBadLeaves(ModTreeNode root) {
            boolean badLeaves = false;
            ModTreeNode leaf = (ModTreeNode)root.getFirstLeaf();
            if (leaf.isRoot()) {
                return false;
            }
            int leafCount = root.getLeafCount();
            for (int i = 0; i < leafCount; ++i) {
                ModTreeNode nextLeaf = (ModTreeNode)leaf.getNextLeaf();
                ModTreeNode parent = (ModTreeNode)leaf.getParent();
                if (parent != null) {
                    String str = leaf.toString().toLowerCase();
                    if (!CheckTree.this.conteintSearch && !str.startsWith(this.textToMatch) || CheckTree.this.conteintSearch && str.lastIndexOf(this.textToMatch) == -1) {
                        if (parent != null) {
                            parent.remove(leaf);
                        }
                        badLeaves = true;
                    }
                }
                leaf = nextLeaf;
            }
            return badLeaves;
        }

        private ModTreeNode replaceLastLeafs(ModTreeNode root) {
            if (root.getChildCount() > 0) {
                ModTreeNode leaf = (ModTreeNode)root.getFirstChild();
                int leafCount = root.getLeafCount();
                for (int i = 0; i < leafCount; ++i) {
                    TreeNode[] origPath;
                    ModTreeNode nextLeaf = (ModTreeNode)leaf.getNextNode();
                    ModTreeNode parent = (ModTreeNode)leaf.getParent();
                    if (leaf.getChildCount() == 0 && (origPath = (TreeNode[])leaf.getAttribute("OrigPath")) != null && parent != null) {
                        parent.remove(leaf);
                        leaf = CheckTree.this.copyNode((ModTreeNode)origPath[origPath.length - 1]);
                        leaf.setAttribute("col", "col");
                        parent.add(leaf);
                    }
                    leaf = nextLeaf;
                }
            }
            return root;
        }
    }
}

