/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.contract.ContractParameterTableRow;
import bitel.billing.module.contract.TableContractParameters;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;

class MultiRenderer
extends DefaultTableCellRenderer {
    private JCheckBox checkBox = new JCheckBox();

    public MultiRenderer(final TableContractParameters parentTable) {
        this.checkBox.setAlignmentX(2.0f);
        this.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int itsRow = parentTable.rowAtPoint(mouseEvent.getPoint());
                int itsColumn = parentTable.columnAtPoint(mouseEvent.getPoint());
                Object value = parentTable.getValueAt(itsRow, itsColumn);
                ContractParameterTableRow cptrow = (ContractParameterTableRow)parentTable.getValueAt(itsRow, 0);
                int pt = cptrow.getParameterType();
                if (value != null && mouseEvent.isControlDown()) {
                    if (value.toString().startsWith("http://") || value.toString().startsWith("https://")) {
                        try {
                            ClientUtils.openBrowser(new URI(value.toString()));
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog(e.getMessage());
                        }
                    }
                    if (pt == 8) {
                        try {
                            int pid = cptrow.getParameterId();
                            int cid = parentTable.getParentContractParamPanel().getContractId();
                            EntityAttrContract eac = (EntityAttrContract)parentTable.getParentContractParamPanel().getContext().getWebService(ContractService.class, 0).contractParameterGet(cid, pid);
                            ClientUtils.openContract(eac.getValue());
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog(e);
                        }
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(this){

            @Override
            public void mouseMoved(MouseEvent e) {
                int itsRow = parentTable.rowAtPoint(e.getPoint());
                int itsColumn = parentTable.columnAtPoint(e.getPoint());
                Object value = parentTable.getValueAt(itsRow, itsColumn);
                int pt = ((ContractParameterTableRow)parentTable.getValueAt(itsRow, 0)).getParameterType();
                if (e.isControlDown() && value != null && (value.toString().startsWith("http://") || value.toString().startsWith("https://") || pt == 8)) {
                    parentTable.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    parentTable.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str;
        ContractParameterTableRow row1 = (ContractParameterTableRow)table.getModel().getValueAt(row, 0);
        if (value instanceof Boolean) {
            this.checkBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.checkBox.setSelected((Boolean)value);
            return this.checkBox;
        }
        if (row1.getParameterType() == 10) {
            this.setBackground(table.getTableHeader().getBackground());
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        this.setBackground(null);
        String string = str = value == null ? "" : value.toString();
        if (str.startsWith("http://") || str.startsWith("https://")) {
            String url = "<html><a href=\"" + value.toString() + "\">" + value.toString() + "</a></html>";
            return super.getTableCellRendererComponent(table, url, isSelected, hasFocus, row, column);
        }
        return super.getTableCellRendererComponent(table, str, isSelected, hasFocus, row, column);
    }
}

