/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.common.bean.SchedulerTaskLog;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.kernel.task.server.emun.TaskStatus;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public abstract class TaskBase
extends BGLogger {
    private TaskStatus status = TaskStatus.STATUS_NOTSTARTED;
    private Date startTime;
    private Date finishTime;
    private Calendar operating_time;
    protected int taskId;
    private boolean initOk = true;
    protected Setup setup;
    protected Preferences taskSetup;
    protected int moduleId = -1;
    private int priority;
    protected Exception error = null;
    protected final String defaultDescription = this.taskId > 0 ? "\u041a\u043e\u0434 \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430: " + this.taskId + ". " : "";

    public TaskBase initTask(Setup setup, int taskId, String params) {
        this.taskId = taskId;
        this.setup = setup;
        this.taskSetup = new Preferences(params, "\r\n");
        this.initModuleId();
        this.initOk = this.initTask();
        return this;
    }

    public void run() {
        if (this.initOk) {
            this.putMyselfIntoTable();
            this.runImpl();
            if (this.taskId != 0 || this.taskId == 0 && this.setup.getBoolean("task.log.for.task.id.0", true)) {
                try (Connection con = this.setup.getDBConnectionFromPool();){
                    SchedulerTaskLog taskLog = new SchedulerTaskLog();
                    taskLog.setTaskId(this.taskId);
                    taskLog.setTaskTitle(this.getDescription());
                    taskLog.setStartTime(this.startTime.getTime());
                    taskLog.setFinishTime(this.finishTime.getTime());
                    new SchedulerManager(con).updateTaskLog(taskLog);
                }
                catch (SQLException | BGException ex) {
                    this.logError(ex);
                }
            }
            this.removeMyselfFromTable();
        } else {
            String key = "scheduler.task.init.error";
            StringBuilder message = new StringBuilder();
            message.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c ");
            message.append(this.taskId);
            message.append(".\n\u0414\u0435\u0442\u0430\u043b\u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u043d\u0430\u0439\u0442\u0438 \u0432 \u043b\u043e\u0433\u0430\u0445 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430.\n");
            message.append("\u041d\u0430\u0439\u0434\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443 \u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043a\u043e\u0434\u043e\u043c \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0437\u0430\u0434\u0430\u0447 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430 \u0438 \u0441\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u0443\u0439\u0442\u0435 \u0435\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e.");
            AlarmSender.sendAlarm("scheduler.task.init.error", 0L, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430", message.toString());
            this.getLogger().error("[taskId#" + this.taskId + "] Task init error!");
        }
    }

    public void runLocal() throws BGException {
        if (!this.initOk) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438");
        }
        this.runImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() {
        this.startTime = new Date();
        this.status = TaskStatus.STATUS_WORKING;
        int moduleId = this.taskSetup.getInt("mid", -1);
        ServerContext context = (ServerContext)ThreadContext.get();
        if (context == null) {
            context = new ServerContext(this.setup, ConnectionSet.newInstance((DefaultServerSetup)this.setup, true), moduleId, 0);
            ThreadContext parent = ThreadContext.push(context);
            try {
                this.executeTask();
                context.commit();
            }
            catch (BGException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
            finally {
                ThreadContext.pop(context, parent);
            }
        } else {
            this.executeTask();
            try {
                context.commit();
            }
            catch (BGException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
        this.finishTime = new Date();
        this.status = TaskStatus.STATUS_FINISHED;
        this.getLogger().info("Task finished time=" + (this.finishTime.getTime() - this.startTime.getTime()) + " ms.");
    }

    public TaskBase setExecutingTime(Calendar working_time) {
        this.operating_time = (Calendar)working_time.clone();
        return this;
    }

    public void startTask() {
        this.run();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public long getWorkingTime() {
        return this.finishTime != null && this.startTime != null ? this.finishTime.getTime() - this.startTime.getTime() : 0L;
    }

    public TaskStatus getTaskStatus() {
        return this.status;
    }

    protected Calendar getOperatingTime() {
        return this.operating_time;
    }

    public Preferences getTaskSetup() {
        return this.taskSetup;
    }

    protected void initModuleId() {
        if (this.moduleId == -1) {
            this.moduleId = this.taskSetup.getInt("mid", -1);
        }
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    protected void removeMyselfFromTable() {
        if (this.taskId <= 0) {
            return;
        }
        String sql = "UPDATE scheduled_periodic_run SET amount=amount-1 WHERE id=?";
        try (Connection con = this.setup.getDBConnectionFromPool();
             PreparedStatement ps = con.prepareStatement(sql);){
            ps.setInt(1, this.taskId);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMyselfIntoTable() {
        if (this.taskId <= 0) {
            return;
        }
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            String sql = "UPDATE scheduled_periodic_run SET amount=amount+1, description=? WHERE id=?";
            PreparedStatement ps = con.prepareStatement(sql);
            ps.setString(1, this.getDescription());
            ps.setInt(2, this.taskId);
            if (ps.executeUpdate() == 0) {
                ps.close();
                sql = "INSERT INTO scheduled_periodic_run(id,description,amount) VALUES(?,?,1)";
                ps = con.prepareStatement(sql);
                ps.setInt(1, this.taskId);
                ps.setString(2, this.getDescription());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public Exception getError() {
        return this.error;
    }

    protected abstract boolean initTask();

    protected abstract void executeTask();

    public abstract String getDescription();

    public List<TaskParameter> taskParameters() {
        return new ArrayList<TaskParameter>();
    }

    public <T extends TaskBase> T to(Class<T> clazz) {
        return (T)this;
    }
}

