/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class IPDataLogUtils {
    public static Iterable<IPHourlyDataLog> newIPHourlyDataLogIterable(final ParameterMap setup, final int sourceId, final Calendar hour1, final Calendar hour2) {
        return new Iterable<IPHourlyDataLog>(){

            @Override
            public Iterator<IPHourlyDataLog> iterator() {
                return new Iterator<IPHourlyDataLog>(){
                    private final Calendar hour;
                    private IPHourlyDataLog dataLog;
                    {
                        this.hour = (Calendar)hour1.clone();
                        this.dataLog = new IPHourlyDataLog(setup, sourceId, this.hour);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.dataLog != null;
                    }

                    @Override
                    public IPHourlyDataLog next() {
                        IPHourlyDataLog current = this.dataLog;
                        this.hour.add(11, 1);
                        this.dataLog = TimeUtils.compare(this.hour, hour2, 11) <= 0 ? new IPHourlyDataLog(setup, sourceId, this.hour) : null;
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<IPHourlyDataLog> newIPHourlyDataLogIterable(final ParameterMap setup, final String key, final int sourceId, final List<Calendar> hours) {
        return new Iterable<IPHourlyDataLog>(){

            @Override
            public Iterator<IPHourlyDataLog> iterator() {
                return new Iterator<IPHourlyDataLog>(){
                    private final Iterator<Calendar> hour;
                    private IPHourlyDataLog dataLog;
                    {
                        this.hour = hours.iterator();
                        this.dataLog = this.hour.hasNext() ? new IPHourlyDataLog(setup, key, sourceId, this.hour.next()) : null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.dataLog != null;
                    }

                    @Override
                    public IPHourlyDataLog next() {
                        IPHourlyDataLog current = this.dataLog;
                        this.dataLog = this.hour.hasNext() ? new IPHourlyDataLog(setup, key, sourceId, this.hour.next()) : null;
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<FlowArray<FlowDetail>> newFlowDetailIterable(final Iterable<IPHourlyDataLog> logsIterable, final FlowSelector selector, final int maxSort) {
        return new Iterable<FlowArray<FlowDetail>>(){

            @Override
            public Iterator<FlowArray<FlowDetail>> iterator() {
                return new FlowDetailIterator((Iterable<IPHourlyDataLog>)logsIterable, selector, maxSort);
            }
        };
    }

    public static Iterable<FlowReader> newFlowReaderIterable(final ParameterMap setup, final int sourceId, final Calendar hour1, final Calendar hour2) {
        return new Iterable<FlowReader>(){

            @Override
            public Iterator<FlowReader> iterator() {
                return new Iterator<FlowReader>(){
                    private final Calendar hour;
                    private IPHourlyDataLog dataLog;
                    private FlowReader next;
                    {
                        this.hour = (Calendar)hour1.clone();
                        this.dataLog = new IPHourlyDataLog(setup, sourceId, this.hour);
                        this.next = this.next();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public FlowReader next() {
                        FlowReader result = this.next;
                        while ((this.next = (FlowReader)this.dataLog.nextReader(null, false)) == null) {
                            this.hour.add(11, 1);
                            if (TimeUtils.compare(this.hour, hour2, 11) > 0) break;
                            this.dataLog = new IPHourlyDataLog(setup, sourceId, this.hour);
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<FlowArray<? extends Data>> newFlowArrayIterable(final ParameterMap setup, final int sourceId, final Calendar hour1, final Calendar hour2) {
        return new Iterable<FlowArray<? extends Data>>(){

            @Override
            public Iterator<FlowArray<? extends Data>> iterator() {
                return new Iterator<FlowArray<? extends Data>>(){
                    private Iterator<FlowReader> readerIterator;
                    private FlowReader reader;
                    private FlowArray<? extends Data> next;
                    {
                        this.readerIterator = IPDataLogUtils.newFlowReaderIterable(setup, sourceId, hour1, hour2).iterator();
                        this.reader = this.readerIterator.hasNext() ? this.readerIterator.next() : null;
                        this.next = this.reader != null ? this.next() : null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public FlowArray<? extends Data> next() {
                        FlowArray<? extends Data> result = this.next;
                        while ((this.next = this.reader.readChunk()) == null && this.readerIterator.hasNext()) {
                            this.reader = this.readerIterator.next();
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<FlowArray<? extends Data>> newFlowArrayIterable(ParameterMap setup, int sourceId, Calendar hour) {
        return IPDataLogUtils.newFlowArrayIterable(setup, sourceId, hour, hour);
    }

    static Iterable<Data> newFlowIterable(final FlowReader _reader) {
        return new Iterable<Data>(){

            @Override
            public Iterator<Data> iterator() {
                return new Iterator<Data>(){
                    private FlowReader reader;
                    private FlowArray<? extends Data> f;
                    private int pos;
                    {
                        this.reader = _reader;
                        this.pos = -1;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.pos < 0 && (this.f = this.reader.readChunk()) == null) {
                            return false;
                        }
                        while (this.pos >= this.f.size) {
                            this.f = this.reader.readChunk();
                            if (this.f == null) {
                                return false;
                            }
                            this.pos = 0;
                        }
                        return true;
                    }

                    @Override
                    public Data next() {
                        return this.f.array[this.pos++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void main(String[] args) {
        System.setProperty("log4j.configuration", "log4j-error.xml");
        Setup setup = new Setup("data", "data");
        setup.set("log.dir", "log/tmp");
        Iterable<IPHourlyDataLog> dataLogs = IPDataLogUtils.newIPHourlyDataLogIterable((ParameterMap)setup, 260, new GregorianCalendar(2011, 0, 1), new GregorianCalendar(2011, 0, 31));
        for (IPHourlyDataLog dataLog : dataLogs) {
            FlowReader reader;
            while ((reader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                FlowArray<? extends Data> flows;
                while ((flows = reader.readChunk()) != null) {
                    int size = flows.size;
                    for (int i = 0; i < size; ++i) {
                        Object flow = flows.array[i];
                        if (((Data)flow).octets <= 4000967295L) continue;
                        System.out.println(flow);
                    }
                }
            }
        }
    }

    static final class FlowDetailIterator
    extends FlowIterator<FlowDetail, DetailFlowArray> {
        private final FlowSelector selector;
        private DetailFlowArray current;

        public FlowDetailIterator(Iterable<IPHourlyDataLog> logsIterable, FlowSelector selector, int maxSort) {
            super(logsIterable, new DetailFlowArray(), maxSort);
            this.selector = selector;
            this.current = new DetailFlowArray();
            if (!this.fetch()) {
                this.next = null;
            }
        }

        @Override
        protected void read(FlowArray<? extends Data> f) {
            int size = f.size;
            for (int i = 0; i < size; ++i) {
                Object flow = f.array[i];
                FlowSelector.Result result = this.selector.test(this.hour, (Data)flow);
                if (!result.isClientRecord) continue;
                FlowDetail d = ((DetailFlowArray)this.next).get(((DetailFlowArray)this.next).size);
                Data.copy(d, flow);
                d.direction = result.direction;
                ++((DetailFlowArray)this.next).size;
            }
        }

        @Override
        public FlowArray<FlowDetail> next() {
            DetailFlowArray next = this.current;
            this.current = (DetailFlowArray)this.next;
            this.next = next;
            if (!this.fetch()) {
                this.next = null;
            }
            return this.current;
        }
    }

    static abstract class FlowIterator<D extends Data, A extends FlowArray<D>>
    implements Iterator<FlowArray<D>> {
        private final Comparator<D> comparator = new Comparator<D>(this){

            @Override
            public int compare(D o1, D o2) {
                return (int)(((Data)o1).getMilliseconds() - ((Data)o2).getMilliseconds());
            }
        };
        private Iterator<IPHourlyDataLog> logs;
        private IPHourlyDataLog log;
        long hour;
        protected A next;
        private DataLog<?> dataLog = null;
        private FlowReader reader = new FlowReader(this){

            public FlowArray<D> readChunk() {
                return null;
            }
        };
        private final int maxSort;
        private boolean needSort = false;

        public FlowIterator(Iterable<IPHourlyDataLog> logsIterable, A detail, int maxSort) {
            this.maxSort = maxSort;
            this.logs = logsIterable.iterator();
            if (this.logs.hasNext()) {
                this.log = this.logs.next();
                this.hour = this.log.getHourInMillis();
            }
            this.next = detail;
        }

        public boolean fetch() {
            ((FlowArray)this.next).size = 0;
            if (this.read()) {
                return true;
            }
            while (this.logs.hasNext()) {
                this.log = this.logs.next();
                this.hour = this.log.getHourInMillis();
                this.reader = (FlowReader)this.log.nextReader(null, false);
                if (!this.read()) continue;
                return true;
            }
            return false;
        }

        private boolean read() {
            FlowArray<? extends Data> f;
            if (this.reader == null) {
                return false;
            }
            if (this.needSort) {
                FlowArray<? extends Data> f2;
                while ((f2 = this.reader.readChunk()) != null) {
                    this.read(f2);
                    if (this.maxSort <= 0 || ((FlowArray)this.next).size <= this.maxSort) continue;
                    this.needSort = false;
                    Arrays.sort(((FlowArray)this.next).array, 0, ((FlowArray)this.next).size, this.comparator);
                    return true;
                }
                while ((this.reader = (FlowReader)this.log.nextReader(null, false)) != null) {
                    if (((DataLogReader)((Object)this.reader)).getDataLog() != this.dataLog) {
                        this.dataLog = ((DataLogReader)((Object)this.reader)).getDataLog();
                        this.needSort = this.dataLog instanceof IPDataLog;
                        break;
                    }
                    while ((f2 = this.reader.readChunk()) != null) {
                        this.read(f2);
                        if (this.maxSort <= 0 || ((FlowArray)this.next).size <= 10000) continue;
                        this.needSort = false;
                        Arrays.sort(((FlowArray)this.next).array, 0, ((FlowArray)this.next).size, this.comparator);
                        return true;
                    }
                }
                if (((FlowArray)this.next).size <= 0) {
                    if (this.reader == null) {
                        return false;
                    }
                    return this.read();
                }
                Arrays.sort(((FlowArray)this.next).array, 0, ((FlowArray)this.next).size, this.comparator);
                return true;
            }
            while ((f = this.reader.readChunk()) == null) {
                this.reader = (FlowReader)this.log.nextReader(null, false);
                if (this.reader != null) {
                    if (((DataLogReader)((Object)this.reader)).getDataLog() == this.dataLog) continue;
                    this.dataLog = ((DataLogReader)((Object)this.reader)).getDataLog();
                    this.needSort = this.dataLog instanceof IPDataLog;
                    if (!this.needSort) continue;
                    return this.read();
                }
                return false;
            }
            this.read(f);
            return true;
        }

        protected abstract void read(FlowArray<? extends Data> var1);

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class DetailFlowArray
    extends FlowArray<FlowDetail> {
        public DetailFlowArray() {
            super((Data[])DetailFlowArray.create());
        }

        private static final FlowDetail[] create() {
            FlowDetail[] detail = new FlowDetail[100];
            for (int i = 0; i < detail.length; ++i) {
                detail[i] = new FlowDetail();
            }
            return detail;
        }

        FlowDetail get(int index) {
            try {
                return ((FlowDetail[])this.array)[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FlowDetail[] recs = new FlowDetail[((FlowDetail[])this.array).length * 2];
                System.arraycopy(this.array, 0, recs, 0, ((FlowDetail[])this.array).length);
                int size = recs.length;
                for (int i = ((FlowDetail[])this.array).length; i < size; ++i) {
                    recs[i] = new FlowDetail();
                }
                this.array = recs;
                return ((FlowDetail[])this.array)[index];
            }
        }
    }

    public static class FlowDetail
    extends Data {
        public static final int DIRECTION_UNDEF = 0;
        public static final int DIRECTION_INCOMING = 1;
        public static final int DIRECTION_OUTGOING = 2;
        public int direction = 0;
    }
}

