/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;

public class ContractConfigManager {
    private final Connection con;

    public ContractConfigManager(Connection con) {
        this.con = con;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConfig(int contractId) throws BGException {
        String query = "SELECT `config` FROM `edo_contract_config` WHERE `contract_id`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string2 = rs.getString("config");
                return string2;
            }
            String string = "";
            return string;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void saveConfig(int contractId, String config) throws BGException {
        String query = "INSERT INTO `edo_contract_config` (`contract_id`, `config`) VALUES(?, ?) ON DUPLICATE KEY UPDATE `config`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setString(2, config);
            ps.setString(3, config);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

