/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.dialup;

import bitel.billing.server.contract.bean.ContractGroup;
import bitel.billing.server.contract.bean.ContractGroupManager;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Sitno_1
extends BGJasperReport {
    private PreparedStatement psGetContractTariff;
    private PreparedStatement psGetAliases;
    private String tableSessionAccount;
    private String tableSessionDetail;
    private String tableSessionLog;
    private Map<Integer, ContractGroup> contractGroupMap;

    public Report_Sitno_1() {
        this.id = "dialup_sitno_1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            Calendar date1 = TimeUtils.parseCalendar((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy");
            Calendar date2 = TimeUtils.parseCalendar((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy");
            String groups = filter.getStringParam("groups");
            String sids = filter.getStringParam("sids");
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            int mode = Utils.parseInt((String)filter.getStringParam("mode"), (int)1);
            long divisor = Utils.parseLong((String)filter.getStringParam("divisor"), (long)1L);
            DecimalFormat format = new DecimalFormat("### ### ### ### ###.##");
            BGDataSource data = new BGDataSource();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (date1 != null && date2 != null && Utils.notEmptyString((String)groups) && Utils.notEmptyString((String)sids) && mid > 0) {
                this.tableSessionAccount = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)date1.getTime(), (int)mid);
                this.tableSessionDetail = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)date1.getTime(), (int)mid);
                this.tableSessionLog = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date1.getTime(), (int)mid);
                String tableLogin = "user_login_" + mid;
                if (ServerUtils.tableExists((Connection)this.con, (String)tableLogin) && ServerUtils.tableExists((Connection)this.con, (String)this.tableSessionAccount) && ServerUtils.tableExists((Connection)this.con, (String)this.tableSessionLog) && ServerUtils.tableExists((Connection)this.con, (String)this.tableSessionDetail)) {
                    String dateString1 = "'" + TimeUtils.format((Calendar)date1, (String)"yyyy-MM-dd") + "'";
                    String dateString2 = "'" + TimeUtils.format((Calendar)date2, (String)"yyyy-MM-dd") + "'";
                    PreparedStatement ps = null;
                    StringBuffer query = new StringBuffer(300);
                    query.append("SELECT contract.id, CONCAT( contract.title, ' (' ,contract.comment, ')') AS title, login.id, login.login ");
                    query.append(" FROM ");
                    query.append(tableLogin);
                    query.append(" AS login ");
                    query.append(" INNER JOIN contract ON contract.id=login.cid");
                    query.append(" AND contract.gr&(1<<?)>0");
                    query.append(" LEFT JOIN ");
                    query.append(this.tableSessionLog);
                    query.append(" AS session ON login.id=session.lid");
                    query.append(" AND TO_DAYS(session.session_start)>=TO_DAYS(");
                    query.append(dateString1);
                    query.append(" ) AND TO_DAYS(session.session_start)<=TO_DAYS(");
                    query.append(dateString2);
                    query.append(" ) GROUP BY login.id ORDER BY title");
                    ps = this.con.prepareStatement(query.toString());
                    ArrayList<Integer> sidList = new ArrayList<Integer>();
                    StringTokenizer st = new StringTokenizer(sids, ",");
                    while (st.hasMoreTokens()) {
                        int sid = Utils.parseInt((String)st.nextToken().trim(), (int)0);
                        if (sid <= 0) continue;
                        sidList.add(sid);
                    }
                    int serviceCount = sidList.size();
                    ResultSet rs = null;
                    int cid = 0;
                    int groupID = 0;
                    int loginID = 0;
                    double sum = 0.0;
                    String groupTitle = null;
                    String contractTariff = null;
                    float[] sums = null;
                    double[] accountsValues = null;
                    StringBuffer accountsString = new StringBuffer(30);
                    HashMap<String, String> groupSums = new HashMap<String, String>();
                    params.put("accountsTitle", this.getServiceTitles(this.con, sids));
                    StringTokenizer groupsSt = new StringTokenizer(groups, ",");
                    while (groupsSt.hasMoreTokens()) {
                        int i;
                        groupID = Utils.parseInt((String)groupsSt.nextToken().trim(), (int)0);
                        groupTitle = this.getGroupTitle(this.con, groupID);
                        ps.setInt(1, groupID);
                        rs = ps.executeQuery();
                        sums = new float[serviceCount];
                        while (rs.next()) {
                            cid = rs.getInt(1);
                            contractTariff = this.getContractTariff(this.con, cid, dateString2);
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            row.put("group", groupTitle);
                            row.put("contract", rs.getString(2));
                            row.put("tariff", contractTariff);
                            loginID = rs.getInt(3);
                            row.put("login", rs.getString(4) + " (" + this.getAliases(this.con, mid, loginID) + ")");
                            accountsString.setLength(0);
                            accountsValues = this.getServiceAmount(this.con, mode, loginID, dateString1, dateString2, sidList);
                            i = 0;
                            while (i < serviceCount) {
                                sum = accountsValues[i];
                                if (mode == 2) {
                                    sum /= (double)divisor;
                                }
                                if (i != 0) {
                                    accountsString.append(" / ");
                                }
                                accountsString.append(format.format(sum));
                                int n = i++;
                                sums[n] = (float)((double)sums[n] + sum);
                            }
                            row.put("accounts", accountsString.toString());
                            data.addRow(row);
                        }
                        StringBuffer groupSum = new StringBuffer(100);
                        for (i = 0; i < serviceCount; ++i) {
                            if (i != 0) {
                                groupSum.append(" / ");
                            }
                            groupSum.append(format.format(sums[i]));
                        }
                        groupSums.put(groupTitle, groupSum.toString());
                    }
                    params.put("groupSums", groupSums);
                    StringBuffer period = new StringBuffer(50);
                    period.append(TimeUtils.formatDate((Calendar)date1));
                    period.append(" - ");
                    period.append(TimeUtils.formatDate((Calendar)date2));
                    params.put("period", period.toString());
                }
            }
            this.fillReportToStream("dialup_sitno_1", out, params, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    private double[] getServiceAmount(Connection con, int mode, int loginId, String dateString1, String dateString2, List<Integer> sidList) throws Exception {
        int size = sidList.size();
        double[] result = new double[size];
        StringBuffer query = new StringBuffer(300);
        if (mode == 1) {
            query.append("SELECT SUM(account.summa) FROM ");
            query.append(this.tableSessionLog);
            query.append(" AS log LEFT JOIN ");
            query.append(this.tableSessionAccount);
            query.append(" AS account ON log.id=account.session_id ");
            query.append(" WHERE TO_DAYS(log.session_start)>=TO_DAYS(");
            query.append(dateString1);
            query.append(") AND TO_DAYS(log.session_start)<=TO_DAYS(");
            query.append(dateString2);
            query.append(") AND log.lid=? AND account.sid=?");
        } else {
            query.append("SELECT SUM(detail.amount) FROM ");
            query.append(this.tableSessionLog);
            query.append(" AS log LEFT JOIN ");
            query.append(this.tableSessionDetail);
            query.append(" AS detail ON log.id=detail.session_id ");
            query.append(" WHERE TO_DAYS(log.session_start)>=TO_DAYS(");
            query.append(dateString1);
            query.append(") AND TO_DAYS(log.session_start)<=TO_DAYS(");
            query.append(dateString2);
            query.append(") AND log.lid=? AND detail.sid=?");
        }
        PreparedStatement ps = con.prepareStatement(query.toString());
        ps.setInt(1, loginId);
        ResultSet rs = null;
        for (int i = 0; i < size; ++i) {
            ps.setInt(2, sidList.get(i));
            rs = ps.executeQuery();
            if (!rs.next()) continue;
            result[i] = rs.getDouble(1);
        }
        rs.close();
        ps.close();
        return result;
    }

    private String getAliases(Connection con, int mid, int lid) throws Exception {
        StringBuffer result = new StringBuffer(150);
        if (this.psGetAliases == null) {
            String query = "SELECT login_alias FROM user_alias_" + mid + " WHERE login_id=?";
            this.psGetAliases = con.prepareStatement(query);
        }
        this.psGetAliases.setInt(1, lid);
        ResultSet rs = this.psGetAliases.executeQuery();
        while (rs.next()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(rs.getString(1));
        }
        rs.close();
        return result.toString();
    }

    private String getServiceTitles(Connection con, String sids) throws Exception {
        StringBuffer result = new StringBuffer(100);
        String query = "SELECT title FROM service WHERE id=?";
        PreparedStatement ps = con.prepareStatement(query);
        ResultSet rs = null;
        StringTokenizer st = new StringTokenizer(sids, ",");
        while (st.hasMoreTokens()) {
            ps.setString(1, st.nextToken().trim());
            rs = ps.executeQuery();
            if (rs.next()) {
                if (result.length() != 0) {
                    result.append(" / ");
                }
                result.append(rs.getString(1));
            }
            rs.close();
        }
        ps.close();
        return result.toString();
    }

    private String getGroupTitle(Connection con, int id) throws Exception {
        if (this.contractGroupMap == null) {
            this.contractGroupMap = new HashMap<Integer, ContractGroup>();
            for (ContractGroup contractGroup : new ContractGroupManager(con).getGroupList()) {
                this.contractGroupMap.put(contractGroup.getId(), contractGroup);
            }
        }
        return this.contractGroupMap.get(id).getTitle();
    }

    private String getContractTariff(Connection con, int cid, String dateString2) throws Exception {
        String result = "-";
        if (this.psGetContractTariff == null) {
            String query = "SELECT t2.title FROM contract_tariff AS t1, tariff_plan AS t2 WHERE t1.tpid=t2.id AND t1.cid=? AND t1.date1<= " + dateString2 + " ORDER BY t1.date1 DESC LIMIT 1";
            this.psGetContractTariff = con.prepareStatement(query);
        }
        this.psGetContractTariff.setInt(1, cid);
        ResultSet rs = this.psGetContractTariff.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        return result;
    }
}

