/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.autopayment.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.ContractAutopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.service.ContractAutopaymentService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractAutopaymentPanel
extends BGUPanel {
    private boolean enadled = false;
    private BGButton setButton = new BGButton();
    private ContractAutopaymentPanel contractAutopaymentPanel;
    private StateTextField stateTextField = new StateTextField();
    private LogTableModel logTableModel = new LogTableModel(LogPopup.class.getName());
    private BGUTable logTable = null;
    private LogPopup popup = null;
    private ContractAutopaymentService contractAutopaymentService = null;

    public ContractAutopaymentPanel() {
        this.contractAutopaymentPanel = this;
    }

    @Override
    protected void jbInit() {
        this.logTable = new BGUTable(this.logTableModel){
            {
                this.setOpaque(true);
                this.setForeground(Color.BLACK);
            }

            @Override
            public ClientContext getContext() {
                return (ClientContext)ContractAutopaymentPanel.this.contractAutopaymentPanel.getContext();
            }
        };
        this.popup = new LogPopup();
        BGButton logButton = new BGButton("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f...");
        logButton.addActionListener(e -> {
            this.tryCall(() -> {
                SearchResult<ContractAutopayment> searchResult = this.getContractAutopaymentService().searchContractAutopayment(((ClientContext)this.getContext()).getContractId(), null, new String[]{"dateFrom:1"}, new Page(1, 25));
                this.logTableModel.setData(searchResult.getList());
                this.refresh();
            });
            this.popup.show(this.contractAutopaymentPanel, this.contractAutopaymentPanel.getWidth() - this.popup.getWidth() - 10, this.contractAutopaymentPanel.getHeight());
        });
        this.setButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0, 3) == 0) {
                this.tryCall(() -> {
                    this.getContractAutopaymentService().setEnabled(((ClientContext)this.getContext()).getContractId(), !this.enadled);
                    this.refresh();
                });
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u043e\u043c"));
        this.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.stateTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.setButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 5, 0), 0, 0));
        this.add((Component)logButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 25, 5, 5), 0, 0));
    }

    public void refresh() {
        this.tryCall(() -> {
            this.enadled = this.getContractAutopaymentService().isEnabled(((ClientContext)this.getContext()).getContractId());
            this.stateTextField.setText(this.enadled ? "\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d" : "\u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d");
            this.setButton.setText(this.enadled ? "\u0417\u0410\u041f\u0420\u0415\u0422\u0418\u0422\u042c" : "\u0420\u0410\u0417\u0420\u0415\u0428\u0418\u0422\u042c");
        });
    }

    protected ContractAutopaymentService getContractAutopaymentService() {
        if (this.contractAutopaymentService == null) {
            this.contractAutopaymentService = ((ClientContext)this.getContext()).getPort(ContractAutopaymentService.class);
        }
        return this.contractAutopaymentService;
    }

    class StateTextField
    extends BGTextField {
        public StateTextField() {
            this.setColumns(15);
            this.setEnabled(false);
            this.setDisabledTextColor(this.getForeground());
            this.setHorizontalAlignment(0);
        }
    }

    class LogTableModel
    extends BGTableModel<ContractAutopayment> {
        static final String COLUMN_DATE_FROM = "dateFrom";
        static final String COLUMN_USER_FROM_NAME = "userFromName";
        static final String COLUMN_DATE_TO = "dateTo";
        static final String COLUMN_USER_TO_NAME = "userToName";

        public LogTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 150, 200, -1, COLUMN_DATE_FROM, false, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043b", 150, 150, -1, COLUMN_USER_FROM_NAME, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", 150, 200, -1, COLUMN_DATE_TO, false, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043b", 150, 150, -1, COLUMN_USER_TO_NAME, false, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(ContractAutopayment val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if (COLUMN_DATE_FROM.equals(identifier)) {
                Date date = null;
                PeriodWithTime period = val.getPeriod();
                if (period != null) {
                    date = period.getDateFrom();
                }
                return date;
            }
            if (COLUMN_DATE_TO.equals(identifier)) {
                Date date = null;
                PeriodWithTime period = val.getPeriod();
                if (period != null) {
                    date = period.getDateTo();
                }
                return date;
            }
            return super.getValue(val, column);
        }
    }

    class LogPopup
    extends JPopupMenu {
        public LogPopup() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.add((Component)new JScrollPane(ContractAutopaymentPanel.this.logTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(800, 500));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f")));
            this.add("Center", panel);
        }
    }
}

