/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AbstractTariffTreeBuilder
extends BGLogger {
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Class<?>>> _typesClasses = new ConcurrentHashMap();

    public InputStream getModuleTariffConfigIS(String module) {
        return AbstractTariffTreeBuilder.class.getResourceAsStream("/ru/bitel/bgbilling/modules/" + module + "/common/tariff.xml");
    }

    protected ConcurrentHashMap<String, Class<?>> getTypesClasses(String module) {
        ConcurrentHashMap<String, Class<?>> result = this._typesClasses.get(module);
        if (result == null) {
            try (InputStream inputStream = this.getModuleTariffConfigIS(module);){
                if (inputStream != null) {
                    result = this.loadChildsClasses(module, XMLUtils.parseDocument(new InputSource(inputStream), XMLUtils.ErrorShowType.EXCEPTION));
                    this._typesClasses.put(module, result);
                } else {
                    this.getLogger().error("getTypesClasses: inputStream is null for module={}", (Object)module);
                }
            }
            catch (IOException ex) {
                this.logError("getTypesClasses: io error module tariff config module=" + module, ex);
            }
            catch (Exception ex) {
                this.logError("getTypesClasses: error module tariff config module=" + module, ex);
            }
        }
        return result;
    }

    private ConcurrentHashMap<String, Class<?>> loadChildsClasses(String module, Document doc) throws Exception {
        ConcurrentHashMap result = new ConcurrentHashMap();
        if (doc != null) {
            for (Element item : XMLUtils.selectElements(doc, "/data/tree/node")) {
                String type = item.getAttribute("type");
                String className = item.getAttribute("class2");
                try {
                    result.put(type, Class.forName(className));
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        return result;
    }

    protected boolean addMTreeItems(Connection con, int treeId, int moduleId, Element tree, boolean editable, int deep) throws BGException {
        ResultSet rs;
        PreparedStatement ps;
        this.getLogger().debug("addMTreeItems: treeId={}; moduleId={}", (Object)treeId, (Object)moduleId);
        int mtree = 0;
        int mtreeParent = 0;
        boolean result = false;
        String query = "SELECT id, parent_tree FROM module_tariff_tree WHERE mid=? AND tree_id=?";
        try {
            ps = con.prepareStatement(query);
            try {
                ps.setInt(1, moduleId);
                ps.setInt(2, treeId);
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        mtree = rs.getInt(1);
                        mtreeParent = rs.getInt(2);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        this.getLogger().debug("addMTreeItems: mtree={}; mtreeParent={}", (Object)mtree, (Object)mtreeParent);
        if (mtree > 0) {
            if (mtreeParent == 0) {
                query = "SELECT parent_tree FROM tariff_tree WHERE id=?";
                try {
                    ps = con.prepareStatement(query);
                    try {
                        ps.setInt(1, treeId);
                        rs = ps.executeQuery();
                        try {
                            if (rs.next()) {
                                mtreeParent = rs.getInt(1);
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception ex) {
                    throw new BGException(ex);
                }
            }
            this.getLogger().debug("addMTreeItems: mtreeParent={}", (Object)mtreeParent);
            if (mtreeParent != 0) {
                this.addMTreeItems(con, mtreeParent, moduleId, tree, false, deep + 1);
            }
            tree.setAttribute("id", String.valueOf(mtree));
            query = "SELECT id, type, parent_node, data FROM mtree_node WHERE mtree_id=? ORDER BY pos";
            try {
                ps = con.prepareStatement(query);
                try {
                    ps.setInt(1, mtree);
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            Element item = XMLUtils.createElement(tree, "item");
                            item.setAttribute("id", rs.getString(1));
                            item.setAttribute("type", rs.getString(2));
                            item.setAttribute("parent", rs.getString(3));
                            item.setAttribute("data", rs.getString(4));
                            item.setAttribute("editable", String.valueOf(editable));
                            item.setAttribute("deep", String.valueOf(deep));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
            result = true;
        }
        return result;
    }

    protected final HashMap<String, String> getDataInHash(String _data) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer pairsSt = new StringTokenizer(_data, "%");
        while (pairsSt.hasMoreTokens()) {
            String pair = pairsSt.nextToken();
            StringTokenizer key_value = new StringTokenizer(pair, "&");
            if (key_value.countTokens() != 2) continue;
            String key = key_value.nextToken();
            String value = key_value.nextToken();
            result.put(key, value);
        }
        result.put("", _data);
        return result;
    }

    private Element getTreeElement(Connection con, int treeId, int moduleId) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element tree = doc.createElement("tree");
        doc.appendChild(tree);
        return this.addMTreeItems(con, treeId, moduleId, tree, true, 0) ? tree : null;
    }

    protected TariffModuleTree loadTariffModuleTree(Connection con, int treeId, int moduleId, String module) throws Exception {
        Element tree = this.getTreeElement(con, treeId, moduleId);
        this.getLogger().debug("loadTariffModuleTree: module = {}; moduleId = {}; treeId = {}; tree = {}", new Object[]{module, moduleId, treeId, tree});
        TariffTreeNodeHolder root = null;
        if (tree != null) {
            HashMap<Integer, List<TreeNode>> childsByParents = new HashMap<Integer, List<TreeNode>>();
            TreeNode rootNode = null;
            NodeList nodeList = tree.getElementsByTagName("item");
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Element item = (Element)nodeList.item(i);
                TreeNode node = new TreeNode(this);
                node.id = Utils.parseInt(item.getAttribute("id"), -1);
                node.type = item.getAttribute("type");
                node.data = this.getDataInHash(item.getAttribute("data"));
                node.deep = Integer.parseInt(item.getAttribute("deep"));
                node.parent = Integer.parseInt(item.getAttribute("parent"));
                if (node.parent == 0) {
                    rootNode = node;
                    continue;
                }
                ArrayList<TreeNode> childs = (ArrayList<TreeNode>)childsByParents.get(node.parent);
                if (childs == null) {
                    childs = new ArrayList<TreeNode>();
                    childsByParents.put(node.parent, childs);
                }
                childs.add(node);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("loadTariffModuleTree: rootNode={}; childsByParents.size()={}", rootNode, (Object)childsByParents.size());
            }
            if (rootNode != null) {
                ConcurrentHashMap<String, Class<?>> typesClasses = this.getTypesClasses(module);
                if (typesClasses != null) {
                    root = this.loadChild(treeId, typesClasses, rootNode, childsByParents, con, moduleId);
                } else {
                    this.getLogger().error("loadTariffModuleTree error: typesClasses = null for module = {}", (Object)module);
                }
            }
        }
        if (root == null) {
            this.getLogger().debug("loadTariffModuleTree: Root of tree not found for treeId: " + treeId + "; moduleId: " + moduleId);
            return null;
        }
        return new TariffModuleTree(root, treeId, moduleId, module);
    }

    private TariffTreeNodeHolder loadChild(int treeId, ConcurrentHashMap<String, Class<?>> typesClasses, TreeNode node, Map<Integer, List<TreeNode>> childsByParents, Connection con, int moduleId) {
        Class<?> clazz;
        List<TreeNode> children = childsByParents.remove(node.id);
        ArrayList<TariffTreeNodeHolder> childrenNodes = null;
        if (children != null) {
            childrenNodes = new ArrayList<TariffTreeNodeHolder>();
            for (TreeNode child : children) {
                TariffTreeNodeHolder n = this.loadChild(treeId, typesClasses, child, childsByParents, con, moduleId);
                if (n == null) continue;
                childrenNodes.add(n);
            }
        }
        if ((clazz = typesClasses.get(node.type)) != null) {
            try {
                Constructor<?> constr;
                TariffTreeNode result = null;
                try {
                    constr = clazz.getConstructor(Integer.TYPE, ParameterMap.class);
                    result = (TariffTreeNode)constr.newInstance(node.id, new ParameterMap.DefaultParameterMap(node.data));
                }
                catch (NoSuchMethodException ex) {
                    try {
                        constr = clazz.getConstructor(Connection.class, Integer.TYPE, Integer.TYPE, ParameterMap.class);
                        result = (TariffTreeNode)constr.newInstance(con, moduleId, node.id, new ParameterMap.DefaultParameterMap(node.data));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (result == null) {
                    return null;
                }
                TariffTreeNodeHolder[] ch = childrenNodes != null ? childrenNodes.toArray(new TariffTreeNodeHolder[childrenNodes.size()]) : null;
                long treeNodeId = 0xFFFFFFFF00000000L & (long)treeId << 32 | 0xFFFFFFFFL & (long)node.id;
                return new TariffTreeNodeHolder(treeNodeId, node.deep, result, ch);
            }
            catch (Exception ex) {
                this.getLogger().error("loadChild: error tree node type = {}; class = {}", new Object[]{node.type, clazz, ex});
            }
        }
        return null;
    }

    protected class TreeNode {
        int id;
        int parent;
        int deep;
        String type;
        Map<String, String> data;

        protected TreeNode(AbstractTariffTreeBuilder this$0) {
        }
    }
}

