/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserMenuTransferHandler;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserMenuTree;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserMenuUserObject;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.table.BGTableModel;

public class MenuManagerPanel
extends BGUPanel
implements PropertyChangeListener {
    private int menuCurrentId = 0;
    private BGUTable menuTable;
    private JTabbedPane tabbedPane;
    private MenuListTableModel menuListModel;
    private UserMenuTree userMenuTree;
    private MenuItemPropertyModel menuItemPropertyModel;
    private BGUTable table;
    private BGButtonPanel buttonPanel;
    private UserService userService;
    private ModuleService moduleService;

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getListPanel(), "West");
        this.add((Component)this.getEditorPanel(), "Center");
    }

    private JPanel getListPanel() {
        this.menuListModel = new MenuListTableModel();
        this.menuTable = new BGUTable(this.menuListModel);
        this.menuTable.setSelectionMode(0);
        this.menuTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (MenuManagerPanel.this.menuTable.isEnabled()) {
                    if (event.getClickCount() == 2) {
                        MenuManagerPanel.this.performAction("edit");
                    }
                    MenuManagerPanel.this.loadWebMenuTreeData();
                }
            }
        });
        Dimension dimension = new Dimension(500, 200);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setBorder(new BGTitleBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u0435\u043d\u044e"));
        panel.add((Component)new JScrollPane(this.menuTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void loadWebMenuTreeData() {
        this.tryCall(() -> {
            MenuItem menuItem = (MenuItem)this.menuListModel.getSelectedRow();
            this.menuCurrentId = menuItem != null ? menuItem.getId() : -1;
            this.userMenuTree.setEnabled(menuItem != null);
            this.userMenuTree.setData(this.getUserService().userMenuDataGet(this.menuCurrentId));
            this.menuItemPropertyModel.setData(new ArrayList());
            this.tabbedPane.setSelectedIndex(0);
        });
    }

    private JPanel getEditorPanel() {
        this.buttonPanel = new BGButtonPanel(BGButtonPanel.RESET, BGButtonPanel.GLUE, new BGButtonPanel.ButtonItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save"), BGButtonPanel.CANCEL);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.setEnabled(false);
        this.buttonPanel.getButton("save").addActionListener(e -> this.tryCall(() -> {
            this.buttonPanel.setEnabled(false);
            this.getUserService().userMenuDataUpdate(this.menuCurrentId, this.userMenuTree.getData());
            this.menuTable.setEnabled(true);
        }));
        this.buttonPanel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> {
            this.menuTable.setEnabled(true);
            this.buttonPanel.setEnabled(false);
            this.userMenuTree.setData("");
        });
        this.buttonPanel.getButton(BGButtonPanel.RESET).addActionListener(e -> {
            this.menuTable.setEnabled(true);
            this.buttonPanel.setEnabled(false);
            this.userMenuTree.reset();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getTreePanel(), "Center");
        panel.add((Component)this.getPropertiesAndTabPanel(), "East");
        panel.add((Component)this.buttonPanel, "South");
        return panel;
    }

    private JPanel getTreePanel() {
        this.userMenuTree = new UserMenuTree();
        this.userMenuTree.setData("");
        this.userMenuTree.setEnabled(false);
        this.userMenuTree.addPropertyChangeListener("changeData", this);
        this.userMenuTree.addPropertyChangeListener("deleteData", this);
        this.tryCall(() -> this.userMenuTree.initPopupMenu());
        this.userMenuTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object selectedObject;
                TreePath treePath = MenuManagerPanel.this.userMenuTree.getSelectionPath();
                if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    MenuManagerPanel.this.table.getDefaultEditor(String.class).cancelCellEditing();
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedObject;
                    if (treeNode.isRoot()) {
                        MenuManagerPanel.this.menuItemPropertyModel.setData(new ArrayList());
                    } else {
                        Element element = ((UserMenuUserObject)treeNode.getUserObject()).getElement();
                        ArrayList list = new ArrayList();
                        NamedNodeMap nodeMap = element.getAttributes();
                        for (int index = 0; index < nodeMap.getLength(); ++index) {
                            Node node = nodeMap.item(index);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("title", node.getNodeName());
                            map.put("value", node.getNodeValue());
                            list.add(map);
                        }
                        MenuManagerPanel.this.menuItemPropertyModel.setData(list);
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043c\u0435\u043d\u044e"));
        panel.add((Component)new JScrollPane(this.userMenuTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPropertiesAndTabPanel() {
        Dimension dimension = new Dimension(600, 200);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)this.getPropertiesPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getTabbedPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JTabbedPane getTabbedPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0443\u043d\u043a\u0442\u044b", this.getAvaibleItemsPanel());
        this.tabbedPane.add("\u041c\u043e\u0434\u0443\u043b\u0438", this.getModulePanel());
        this.tabbedPane.add("\u041f\u043b\u0430\u0433\u0438\u043d\u044b", this.getPluginPanel());
        return this.tabbedPane;
    }

    private JPanel getAvaibleItemsPanel() {
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(listModel);
        list.setDragEnabled(true);
        list.setTransferHandler(new UserMenuTransferHandler());
        this.tryCall(() -> {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(this.getUserService().userMenuDataDefault().getBytes("utf-8")));
            Element menuBar = doc.getDocumentElement();
            for (Element element : XMLUtils.selectElements(menuBar, "//*")) {
                listModel.addElement(new UserMenuUserObject(element));
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getModulePanel() {
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(listModel);
        list.setDragEnabled(true);
        list.setTransferHandler(new UserMenuTransferHandler());
        this.tryCall(() -> {
            Document doc = XMLUtils.newDocument();
            Element element = doc.createElement("modules");
            element.setAttribute("title", "<\u041c\u041e\u0414\u0423\u041b\u0418>");
            listModel.addElement(new UserMenuUserObject(element));
            for (BGModule bgModule : this.getModuleService().moduleList()) {
                element = doc.createElement("menuItem");
                element.setAttribute("id", String.valueOf(bgModule.getId()));
                element.setAttribute("mid", String.valueOf(bgModule.getId()));
                element.setAttribute("title", bgModule.getGuiTitle());
                element.setAttribute("name", bgModule.getTitle());
                element.setAttribute("className", bgModule.getInstalledModule().getPackageClient() + ".ActionServiceConfig");
                listModel.addElement(new UserMenuUserObject(element));
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPluginPanel() {
        DefaultListModel listModel = new DefaultListModel();
        JList list = new JList(listModel);
        list.setDragEnabled(true);
        list.setTransferHandler(new UserMenuTransferHandler());
        this.tryCall(() -> {
            for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions("bitel.billing.server.admin.action.ActionMenuAndToolBar", false)) {
                Element extensionElement = extension.getElement();
                BGPluginBase plugin = extension.getPlugin();
                NodeList menuList = extensionElement.getElementsByTagName("menu");
                for (int index1 = 0; index1 < menuList.getLength(); ++index1) {
                    Element menuElement = (Element)menuList.item(index1);
                    NodeList menuItemList = menuElement.getElementsByTagName("menuItem");
                    for (int index2 = 0; index2 < menuItemList.getLength(); ++index2) {
                        Element element = (Element)menuItemList.item(index2);
                        element.setAttribute("title", plugin.getResourceString(element.getAttribute("title")));
                        listModel.addElement(new UserMenuUserObject(element));
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPropertiesPanel() {
        this.menuItemPropertyModel = new MenuItemPropertyModel();
        this.table = new BGUTable(this.menuItemPropertyModel){

            @Override
            public void editingStopped(ChangeEvent event) {
                Object selectedObject;
                super.editingStopped(event);
                TreePath treePath = MenuManagerPanel.this.userMenuTree.getSelectionPath();
                if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedObject;
                    Element element = ((UserMenuUserObject)treeNode.getUserObject()).getElement();
                    for (Map map : MenuManagerPanel.this.menuItemPropertyModel.getRows()) {
                        element.setAttribute((String)map.get("title"), (String)map.get("value"));
                    }
                    ((DefaultTreeModel)MenuManagerPanel.this.userMenuTree.getModel()).reload(treeNode);
                    MenuManagerPanel.this.userMenuTree.aa("changeData");
                }
            }
        };
        this.table.setSelectionMode(0);
        Dimension dimension = new Dimension(600, 200);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setBorder(new BGTitleBorder("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430"));
        panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("deleteData".equals(event.getPropertyName())) {
            this.menuItemPropertyModel.setData(new ArrayList());
        }
        boolean fl = event.getNewValue().equals(event.getOldValue());
        this.menuTable.setEnabled(fl);
        this.buttonPanel.setEnabled(!fl);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.menuTable.setEnabled(true);
            this.menuListModel.setData(this.getUserService().userMenuList(false));
        });
        new AbstractBGUPanel.BGActionNew(e -> new MenuEditor("\u041d\u043e\u0432\u043e\u0435 \u043c\u0435\u043d\u044e", new MenuItem()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.menuListModel.optSelectedRow().ifPresentOrElse(menuItem -> new MenuEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0435\u043d\u044e", (MenuItem)menuItem).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u043d\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!")));
        new AbstractBGUPanel.BGActionDelete(e -> {
            MenuItem menuItem = (MenuItem)this.menuListModel.getSelectedRow();
            if (menuItem != null && menuItem.getRoleCount() == 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435\n\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u043c\u0435\u043d\u044e?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.getUserService().userMenuDelete(menuItem.getId());
                    this.loadWebMenuTreeData();
                    this.performAction("refresh");
                }
            } else {
                ClientUtils.showErrorMessageDialog("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a\n\u043c\u0435\u043d\u044e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445!");
            }
        });
    }

    private UserService getUserService() {
        if (this.userService == null) {
            this.userService = ((ClientContext)this.getContext()).getPort(UserService.class, 0);
        }
        return this.userService;
    }

    private ModuleService getModuleService() {
        if (this.moduleService == null) {
            this.moduleService = ((ClientContext)this.getContext()).getPort(ModuleService.class, 0);
        }
        return this.moduleService;
    }

    class MenuListTableModel
    extends BGTableModel<MenuItem> {
        public MenuListTableModel() {
            super(MenuListTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", 30, 30, 30, "default", false, new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", false);
            this.addColumn("\u0421\u0441\u044b\u043b\u043e\u043a", 100, 100, 100, "roleCount", false, DecimalTableCellRenderer.INTEGER());
        }
    }

    class MenuItemPropertyModel
    extends BGTableModel<Map<String, String>> {
        public MenuItemPropertyModel() {
            super(MenuItemPropertyModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 150, 150, "title", true);
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "value", false);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }

    class MenuEditor
    extends BGEditorDialog<MenuItem> {
        private BGTextField menuTitle;
        private JCheckBox menuDefault;

        public MenuEditor(String title, MenuItem data) {
            super(title, data);
            this.menuTitle = new BGTextField(30);
            this.menuDefault = new JCheckBox("\u043c\u0435\u043d\u044e \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }

        @Override
        public void doDialogPanel() {
            this.menuTitle.setText(((MenuItem)this.data).getTitle());
            this.menuDefault.setSelected(((MenuItem)this.data).isDefault());
            MenuManagerPanel.this.menuCurrentId = ((MenuItem)this.data).getId();
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.menuTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.menuDefault, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.menuTitle.getText().trim().isBlank()) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0435\u043d\u044e");
                return false;
            }
            ((MenuItem)this.data).setId(MenuManagerPanel.this.menuCurrentId);
            ((MenuItem)this.data).setTitle(this.menuTitle.getText());
            ((MenuItem)this.data).setDefault(this.menuDefault.isSelected());
            this.tryCall(() -> {
                this.data = MenuManagerPanel.this.getUserService().userMenuUpdate((MenuItem)this.data);
                if (MenuManagerPanel.this.menuCurrentId == 0) {
                    MenuManagerPanel.this.menuListModel.addRow((MenuItem)this.data);
                    MenuManagerPanel.this.menuListModel.setSelectedRow((MenuItem)this.data);
                }
                MenuManagerPanel.this.menuListModel.setData(MenuManagerPanel.this.getUserService().userMenuList(false), true);
                MenuManagerPanel.this.loadWebMenuTreeData();
            });
            return true;
        }
    }
}

