/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import bitel.billing.server.call.bean.Session;
import bitel.billing.server.call.bean.VoiceUtils;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.voice.calc.ItemZoneCostCache;
import bitel.billing.server.tariff.voice.calc.ItemZoneTrafficCache;
import bitel.billing.server.tariff.voice.calc.ZoneDestFindRequest;
import bitel.billing.server.tariff.voice.calc.ZoneDestFinder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.server.CostMapCache;
import ru.bitel.bgbilling.kernel.tariff.server.bean.VoiceTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.CostAdditionTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.voiceip.common.bean.VoiceIpOperatorPrefixCost;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLogin;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceIpSession
extends Session {
    private int serviceID = -1;
    public static final int TREE_NOT_FOUND = 1;
    public static final int PRICE_NOT_FOUND = 2;
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private int callType = -1;
    private int sessionTime = -1;
    private float minuteCost = 0.0f;
    private int destCode = -1;
    private int zoneCode = -1;
    private String disconnectCause;
    private String h323ID;
    private int roundSessionTime = 0;
    private BigDecimal sessionCost = BigDecimal.ZERO;
    private int operatorId;
    private int operRoundSessionTime = 0;
    private BigDecimal operSessionCost = BigDecimal.ZERO;
    private BigDecimal fakeCost = BigDecimal.ZERO;
    private ItemZoneTrafficCache itemZoneTrafficCache;
    private ItemZoneCostCache itemZoneCostCache;

    public void setItemZoneTrafficCache(ItemZoneTrafficCache itemZoneTrafficCache) {
        this.itemZoneTrafficCache = itemZoneTrafficCache;
    }

    public void setItemZoneCostCache(ItemZoneCostCache itemZoneCostCache) {
        this.itemZoneCostCache = itemZoneCostCache;
    }

    public int getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(int sessionTime) {
        this.sessionTime = sessionTime;
    }

    public int getCallType() {
        return this.callType;
    }

    public void setCallType(int value) {
        this.callType = value;
    }

    public void setServiceId(int value) {
        this.serviceID = value;
    }

    public int getServiceId() {
        return this.serviceID;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public void setOperatorId(int operatorId) {
        this.operatorId = operatorId;
    }

    public void checkAndCreateTables(Connection con, DefaultServerSetup setup) {
        super.checkAndCreateTables(con, setup);
        String query = "CREATE TABLE " + this.logSessionTableName + " ( id INT auto_increment PRIMARY KEY, type INT NOT NULL, nas_id INT NOT NULL, lid INT NOT NULL, cid INT NOT NULL, session_start DATETIME NOT NULL, session_time INT NOT NULL, round_session_time INT NOT NULL, from_number CHAR(24) NOT NULL, to_number CHAR(24) NOT NULL, dest_code INT NOT NULL,zone INT NOT NULL, min_cost FLOAT(10, 5) NOT NULL, session_cost DECIMAL(10, 5) NOT NULL, oper_id INT NOT NULL DEFAULT 0, oper_round_session_time INT NOT NULL DEFAULT 0, oper_session_cost DECIMAL(10, 5) NOT NULL DEFAULT 0, sid INT NOT NULL, h323_id CHAR(40) NOT NULL, dc CHAR(4),lr INT NOT NULL, fake_cost DECIMAL(10, 5) NOT NULL DEFAULT 0,KEY nas (nas_id),KEY lid (lid),KEY zone (zone), KEY cid_sid( cid, sid ),KEY oper_id (oper_id), KEY session_start(session_start) )";
        ServerUtils.checkAndCreatePeriodicTableName((Connection)con, (String)this.logSessionTableName, (String)query);
    }

    public static final void addColumns(Connection con, String tableName) {
        try {
            Statement st = con.createStatement();
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"zone")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD zone INT NOT NULL");
                st.executeUpdate("ALTER TABLE " + tableName + " ADD KEY zone(zone)");
            }
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"round_session_time")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD round_session_time INT NOT NULL");
            }
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"oper_round_session_time")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD oper_round_session_time INT NOT NULL DEFAULT 0");
            }
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"oper_session_cost")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD oper_session_cost DECIMAL(10, 5) NOT NULL DEFAULT 0");
            }
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"oper_id")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN oper_id INT NOT NULL DEFAULT 0, ADD KEY oper_id (oper_id)");
            }
            if (!ServerUtils.columnExist((Connection)con, (String)tableName, (String)"fake_cost")) {
                st.executeUpdate("ALTER TABLE " + tableName + " ADD COLUMN fake_cost DECIMAL(10, 5) NOT NULL DEFAULT 0");
            }
            st.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int calculate(Connection con) {
        return this.calculate(con, null);
    }

    public int calculate(Connection con, StringBuilder trace) {
        int result = 0;
        if (this.getServiceId() < 0 || this.getStartTime() == null || this.getCallType() < 0 || this.getOpponentStation() == null) {
            this.getLogger().warn("Error in params VoipSession.calculateSession() [serviceId=" + this.getServiceId() + "; startTime=" + TimeUtils.format((Calendar)this.getStartTime(), (String)"dd.MM.yyyy HH:mm:ss") + "; callType=" + this.getCallType() + "; opponentStation=" + this.getOpponentStation() + "; fromNumber=" + this.getFromNumber() + "]");
            return 0;
        }
        this.addLogDebug("VoiceIpSession calculate");
        List treeList = this.getContract().getTts().getTreeList(this.getStartTime());
        if (treeList.size() == 0) {
            result = 1;
        } else {
            CostMapCache costMapCache;
            result = 2;
            ZoneDestFinder zdf = ZoneDestFinder.getZoneFinder((Connection)con, (int)this.mid);
            try {
                costMapCache = CostMapCache.getInstance((Connection)con, (int)this.mid);
            }
            catch (BGException ex) {
                costMapCache = null;
                this.logError(ex);
            }
            for (TariffModuleTree tree : treeList) {
                TariffRequest req = this.initZonesRange(tree);
                req.setRequestParam("module", (Object)"voiceip");
                req.setRequestParam("mid", (Object)this.mid);
                req.setRequestParam("con", (Object)con);
                req.setRequestParam("time", (Object)this.getStartTime());
                req.setRequestParam("phone", (Object)this.getOpponentStation());
                req.setRequestParam("sid", (Object)this.getServiceId());
                req.setRequestParam("call_type", (Object)this.getCallType());
                req.setRequestParam("zdf", (Object)zdf);
                req.setRequestParam("costMapCache", (Object)costMapCache);
                req.setRequestParam("operatorId", (Object)this.getOperatorId());
                tree.processRequest(req);
                Integer destCode = (Integer)req.getResponseParam("dest");
                Float minCost = (Float)req.getResponseParam("min_cost");
                Float operMinCost = (Float)req.getResponseParam("opermin_cost");
                Integer zoneId = (Integer)req.getResponseParam("zone");
                if (!req.wasAccepted() || minCost == null || destCode == null) continue;
                if (zoneId != null) {
                    this.zoneCode = zoneId;
                }
                this.minuteCost = minCost.floatValue();
                this.destCode = destCode;
                this.roundSessionTime = this.sessionTime;
                Cost clientCost = new Cost(this, this.roundSessionTime, this.minuteCost, this.sessionCost);
                this.config((VoiceTariffConfig)req.getResponseParam("config"), (CostAdditionTariffTreeNode)req.getResponseParam("cost_addition"), clientCost);
                if (operMinCost != null) {
                    Cost operCost = new Cost(this, this.roundSessionTime, operMinCost.floatValue(), this.sessionCost);
                    this.config((VoiceTariffConfig)req.getResponseParam("operconfig"), (CostAdditionTariffTreeNode)req.getResponseParam("opercost_addition"), operCost);
                    this.operSessionCost = operCost.sessionCost;
                    this.operRoundSessionTime = operCost.roundSessionTime;
                }
                this.minuteCost = clientCost.minuteCost;
                this.sessionCost = clientCost.sessionCost;
                this.roundSessionTime = clientCost.roundSessionTime;
                this.fakeCost = clientCost.sessionCost;
                BigDecimal costPeriodRemain = (BigDecimal)req.getResponseParam("cost_period_remain");
                if (costPeriodRemain != null) {
                    BigDecimal cost = clientCost.sessionCost.subtract(costPeriodRemain);
                    BigDecimal bigDecimal = this.sessionCost = cost.compareTo(BigDecimal.ZERO) <= 0 ? BigDecimal.ZERO : cost;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.addLogDebug("minuteCost => " + this.minuteCost + "; destCode => " + destCode + "; zoneCode => " + this.zoneCode + "; roundSessionTime => " + this.roundSessionTime + "; fakeCost => " + String.valueOf(this.fakeCost) + "; sessionCost => " + String.valueOf(this.sessionCost));
                }
                result = 0;
                break;
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.addLogDebug("errorCode => " + result);
        }
        return result;
    }

    private void config(VoiceTariffConfig config, CostAdditionTariffTreeNode costAddition, Cost cost) {
        block13: {
            block12: {
                if (config != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.addLogDebug("Use config: " + config.toString());
                        this.addLogDebug("sessionTime before => " + cost.roundSessionTime);
                    }
                    cost.roundSessionTime = config.getRoundTime(cost.roundSessionTime);
                    if (this.getLogger().isDebugEnabled()) {
                        this.addLogDebug("sessionTime after => " + cost.roundSessionTime);
                    }
                }
                if (costAddition == null) break block12;
                switch (costAddition.getSubject()) {
                    case 1: {
                        cost.minuteCost += costAddition.getValue();
                        cost.sessionCost = new BigDecimal((float)cost.roundSessionTime / 60.0f * cost.minuteCost);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Cost addition: minuteCost " + costAddition.getValue());
                        }
                        break block13;
                    }
                    case 2: {
                        cost.sessionCost = new BigDecimal((float)cost.roundSessionTime / 60.0f * cost.minuteCost);
                        cost.sessionCost = cost.sessionCost.add(new BigDecimal(costAddition.getValue()));
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Cost addition: sessionCost " + costAddition.getValue());
                        }
                        break block13;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            cost.sessionCost = new BigDecimal((float)cost.roundSessionTime / 60.0f * cost.minuteCost);
        }
        if (config != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("Round session cost by config, before: " + cost.sessionCost.toPlainString());
            }
            cost.sessionCost = config.roundCost(cost.sessionCost, 5);
            if (this.getLogger().isDebugEnabled()) {
                this.addLogDebug("After round: " + cost.sessionCost.toPlainString());
            }
        }
    }

    protected TariffRequest initZonesRange(TariffModuleTree tree) {
        TariffRequest req = new TariffRequest();
        req.setRequestParam("time", (Object)this.getStartTime());
        req.setRequestParam("sid", (Object)this.getServiceId());
        req.setRequestParam("action", (Object)"reset");
        tree.processRequest(req);
        TariffRequest reqnew = new TariffRequest();
        this.initZonesTrafficRange(reqnew, req);
        this.initZonesCostRange(reqnew, req);
        return reqnew;
    }

    private void initZonesTrafficRange(TariffRequest reqnew, TariffRequest req) {
        Set zoneSet = (Set)req.getResponseParam("zone_set");
        if (zoneSet != null) {
            Calendar startMonth = TimeUtils.getStartMonth((Calendar)this.getStartTime());
            Calendar endMonth = TimeUtils.getEndMonth((Calendar)this.getStartTime());
            float part = TimeUtils.getPart((Calendar)TimeUtils.convertDateToCalendar((Date)this.login.getDate1()), (Calendar)TimeUtils.convertDateToCalendar((Date)this.login.getDate2()), (Calendar)startMonth, (Calendar)endMonth);
            reqnew.setRequestParam("part", (Object)Float.valueOf(part));
            Object[] array = zoneSet.toArray();
            for (int index = 0; index < array.length; ++index) {
                Integer zoneId = (Integer)array[index];
                reqnew.setRequestParam("zone_traf_" + zoneId, (Object)this.getZoneTraffic(zoneId, -1));
                reqnew.setRequestParam("zone_traf_in_" + zoneId, (Object)this.getZoneTraffic(zoneId, 2));
                reqnew.setRequestParam("zone_traf_out_" + zoneId, (Object)this.getZoneTraffic(zoneId, 1));
            }
        }
    }

    private Integer getZoneTraffic(int zoneId, int type) {
        Integer traffic = this.itemZoneTrafficCache.getZoneTraffic(Integer.valueOf(this.login.getId()), Integer.valueOf(zoneId), type);
        if (traffic == null) {
            traffic = 0;
        }
        return traffic;
    }

    private void initZonesCostRange(TariffRequest reqnew, TariffRequest req) {
        Set zoneSet = (Set)req.getResponseParam("zone_cost_set");
        if (zoneSet != null) {
            Calendar startMonth = TimeUtils.getStartMonth((Calendar)this.getStartTime());
            Calendar endMonth = TimeUtils.getEndMonth((Calendar)this.getStartTime());
            float part = TimeUtils.getPart((Calendar)TimeUtils.convertDateToCalendar((Date)this.login.getDate1()), (Calendar)TimeUtils.convertDateToCalendar((Date)this.login.getDate2()), (Calendar)startMonth, (Calendar)endMonth);
            reqnew.setRequestParam("part", (Object)Float.valueOf(part));
            Object[] array = zoneSet.toArray();
            for (int index = 0; index < array.length; ++index) {
                Integer zoneId = (Integer)array[index];
                reqnew.setRequestParam("zone_cost_" + zoneId, (Object)this.getZoneCost(zoneId, -1));
                reqnew.setRequestParam("zone_cost_in_" + zoneId, (Object)this.getZoneCost(zoneId, 2));
                reqnew.setRequestParam("zone_cost_out_" + zoneId, (Object)this.getZoneCost(zoneId, 1));
            }
        }
    }

    private BigDecimal getZoneCost(int zoneId, int type) {
        BigDecimal traffic = this.itemZoneCostCache.getZoneCost(Integer.valueOf(this.login.getId()), Integer.valueOf(zoneId), type);
        if (traffic == null) {
            traffic = BigDecimal.ZERO;
        }
        return traffic;
    }

    public String getOpponentStation() {
        String tariff_station = null;
        int tariffType = 2;
        tariffType = this.callType == 1 ? ((VoiceIpLogin)this.getLogin()).getOutTariffType() : ((VoiceIpLogin)this.getLogin()).getInTariffType();
        tariff_station = tariffType == 2 ? this.getToNumber() : (tariffType == 1 ? this.getFromNumber() : null);
        return tariff_station;
    }

    public boolean needTarification() {
        boolean result = false;
        result = this.getCallType() == 1 ? ((VoiceIpLogin)this.getLogin()).getOutTariffType() != 0 : ((VoiceIpLogin)this.getLogin()).getInTariffType() != 0;
        return result;
    }

    public String getDisconnectCause() {
        return this.disconnectCause;
    }

    public void setDisconnectCause(String disconnectCause) {
        this.disconnectCause = disconnectCause;
    }

    public String getH323ID() {
        return this.h323ID;
    }

    public void setH323ID(String h323ID) {
        this.h323ID = h323ID;
    }

    public float getMinuteCost() {
        return this.minuteCost;
    }

    public void setMinuteCost(float minuteCost) {
        this.minuteCost = minuteCost;
    }

    public int getDestCode() {
        return this.destCode;
    }

    public void setDestCode(int destCode) {
        this.destCode = destCode;
    }

    public BigDecimal getSessionCost() {
        return this.sessionCost;
    }

    public BigDecimal getOperSessionCost() {
        return this.operSessionCost;
    }

    public void setSessionCost(BigDecimal sessionCost) {
        this.sessionCost = sessionCost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(";\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430 ( 1 - \u0438\u0441\u0445, 2 - \u0432\u0445 ) => ");
        sb.append(this.callType);
        sb.append(";\u0421 \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440 => ");
        sb.append(this.fromNumber);
        sb.append(" / ");
        sb.append(this.toNumber);
        sb.append(";\u0412\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 => ");
        sb.append(TimeUtils.format((Calendar)this.startTime, (String)"dd.MM.yyyy HH:mm:ss"));
        sb.append(";ID => ");
        sb.append(this.logRecordId);
        sb.append("; dest => ");
        sb.append(this.destCode);
        sb.append("; min_cost => ");
        sb.append(this.minuteCost);
        sb.append("; session_cost => ");
        sb.append(this.sessionCost);
        return sb.toString();
    }

    public int getRoundSessionTime() {
        return this.roundSessionTime;
    }

    public int getOperRoundSessionTime() {
        return this.operRoundSessionTime;
    }

    public void setRoundSessionTime(int roundSessionTime) {
        this.roundSessionTime = roundSessionTime;
    }

    public int getZoneCode() {
        return this.zoneCode;
    }

    public void setZoneCode(int zoneCode) {
        this.zoneCode = zoneCode;
    }

    public ItemZoneTrafficCache getItemZoneTrafficCache() {
        return this.itemZoneTrafficCache;
    }

    public ItemZoneCostCache getItemZoneCostCache() {
        return this.itemZoneCostCache;
    }

    public List<VoiceIpOperatorPrefixCost> getOperatorPrefixCostTable(Connection con, VoiceUtils vu, String prefix, long gr, int serviceId, int callType) {
        ArrayList<VoiceIpOperatorPrefixCost> result = new ArrayList<VoiceIpOperatorPrefixCost>();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT id, title, comment FROM contract WHERE (gr&?)>0");
            ps.setLong(1, gr);
            ResultSet rs = ps.executeQuery();
            ContractManager cm = new ContractManager(con);
            GregorianCalendar now = new GregorianCalendar();
            this.startTime = now;
            this.serviceID = serviceId;
            this.itemZoneTrafficCache = new ItemZoneTrafficCache();
            this.itemZoneCostCache = new ItemZoneCostCache();
            this.login = new VoiceIpLogin();
            block4: while (rs.next()) {
                int cid = rs.getInt(1);
                String contractTitle = rs.getString(2) + " (" + rs.getString(3) + ")";
                TariffTreeSet tariffSet = cm.getTariffTreeSetForDay(cid, (Calendar)now, "voiceip", this.mid, false);
                List treeList = tariffSet.getTreeList((Calendar)now);
                if (treeList.size() <= 0) continue;
                for (TariffModuleTree tree : treeList) {
                    CostMapCache costMapCache;
                    TariffRequest req = this.initZonesRange(tree);
                    req.setRequestParam("module", (Object)"voiceip");
                    req.setRequestParam("mid", (Object)this.mid);
                    req.setRequestParam("con", (Object)con);
                    req.setRequestParam("time", (Object)now);
                    req.setRequestParam("phone", (Object)prefix);
                    req.setRequestParam("sid", (Object)serviceId);
                    req.setRequestParam("call_type", (Object)callType);
                    req.setRequestParam("zdf", (Object)ZoneDestFinder.getZoneFinder((Connection)con, (int)this.mid));
                    req.setRequestParam("operatorId", (Object)this.getOperatorId());
                    try {
                        costMapCache = CostMapCache.getInstance((Connection)con, (int)this.mid);
                    }
                    catch (BGException ex) {
                        costMapCache = null;
                        this.logError(ex);
                    }
                    req.setRequestParam("costMapCache", (Object)costMapCache);
                    tree.processRequest(req);
                    Integer destCode = (Integer)req.getResponseParam("dest");
                    Float minCost = (Float)req.getResponseParam("min_cost");
                    if (!req.wasAccepted() || minCost == null || destCode == null) continue;
                    String rest = (String)req.getRequestParam("phone_rest");
                    ZoneDestFindRequest destFindReq = (ZoneDestFindRequest)req.getRequestParam("zone_dest_find_request");
                    int relevance = req.getRelevance();
                    String resultPrefix = rest != null ? prefix.substring(0, prefix.length() - 1 - rest.length()) : (relevance >= 0 ? prefix.substring(0, relevance) : (destFindReq != null && destFindReq.relevance >= 0 ? prefix.substring(0, destFindReq.relevance) : prefix));
                    String destTitle = vu.getDestTitle(destCode.intValue());
                    VoiceIpOperatorPrefixCost cost = new VoiceIpOperatorPrefixCost();
                    cost.setContractId(cid);
                    cost.setContractTitle(contractTitle);
                    cost.setCost(minCost.floatValue());
                    cost.setDestId(destCode.intValue());
                    cost.setDestTitle(destTitle);
                    cost.setPrefix(resultPrefix);
                    result.add(cost);
                    continue block4;
                }
            }
            rs.close();
            ps.close();
            Collections.sort(result, new Comparator<VoiceIpOperatorPrefixCost>(this){

                @Override
                public int compare(VoiceIpOperatorPrefixCost o1, VoiceIpOperatorPrefixCost o2) {
                    return o2.getPrefix().length() - o1.getPrefix().length();
                }
            });
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public BigDecimal getFakeCost() {
        return this.fakeCost;
    }

    public void setFakeCost(BigDecimal fakeCost) {
        this.fakeCost = fakeCost;
    }

    class Cost {
        int roundSessionTime;
        float minuteCost;
        BigDecimal sessionCost;

        public Cost(VoiceIpSession this$0, int roundSessionTime, float minuteCost, BigDecimal sessionCost) {
            this.roundSessionTime = roundSessionTime;
            this.minuteCost = minuteCost;
            this.sessionCost = sessionCost;
        }
    }
}

