/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server.bean;

import bitel.billing.server.tariff.voice.bean.TableManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMapItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class RangeMapDao
extends AbstractDirectoryIdDao<RangeMap> {
    private final String itemTableName;
    private PreparedStatement insertItemPS = null;
    private PreparedStatement updateItemPS = null;

    public RangeMapDao(Connection con, int moduleId) {
        super(con, moduleId, TableManager.getPrefix(con, moduleId) + "range_map");
        String prefix = TableManager.getPrefix(con, moduleId);
        this.itemTableName = prefix + "range_map_item_" + moduleId;
    }

    protected RangeMap getFromRS(ResultSet rs) throws SQLException {
        RangeMap result = new RangeMap();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    protected void updateImpl(RangeMap b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title) VALUES (?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=? WHERE id=?");
            ps.setInt(2, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
        ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.moduleId);
    }

    public List<RangeMap> list(String orderBy) throws BGException {
        if (orderBy == null) {
            orderBy = "title";
        }
        return this.list(null, orderBy, new Object[0]);
    }

    public List<RangeMap> list() throws BGException {
        return this.list(null);
    }

    public RangeMap get(String title) throws BGException {
        return (RangeMap)((Object)this.get("title=?", new Object[]{title}));
    }

    public List<RangeMapItem> listItems(int costMapId, Date date) throws BGException {
        try {
            ArrayList<RangeMapItem> result = new ArrayList<RangeMapItem>();
            StringBuilder sb = new StringBuilder().append("SELECT item.id, item.rangeFrom, item.rangeTo, item.dateFrom, item.dateTo, item.title FROM ").append(this.itemTableName).append(" as item WHERE item.mapId=?");
            if (date != null) {
                sb.append(" AND (item.dateFrom IS NULL OR item.dateFrom<=?) AND (item.dateTo IS NULL OR item.dateTo>=?)");
            }
            sb.append(" ORDER BY item.rangeFrom");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, costMapId);
            if (date != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                RangeMapItem code = new RangeMapItem();
                code.setId(rs.getInt(1));
                code.setRangeFrom(rs.getString(2));
                code.setRangeTo(rs.getString(3));
                code.setDateFrom(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate(4)));
                code.setDateTo(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate(5)));
                code.setTitle(rs.getString(6));
                result.add(code);
            }
            rs.close();
            ps.close();
            result.trimToSize();
            return result;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateItem(int costMapId, RangeMapItem item) throws BGException {
        try {
            this.updateItemImpl(costMapId, item);
            if (this.updateItemPS != null) {
                this.updateItemPS.close();
                this.updateItemPS = null;
            }
            if (this.insertItemPS != null) {
                this.insertItemPS.close();
                this.insertItemPS = null;
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.moduleId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private void updateItemImpl(int rangeMapId, RangeMapItem item) throws SQLException {
        if (item.getId() > 0) {
            if (this.updateItemPS == null) {
                this.updateItemPS = this.con.prepareStatement("UPDATE " + this.itemTableName + " SET rangeFrom=?, rangeTo=?, dateFrom=?, dateTo=?, title=?, comment=? WHERE mapId=? AND id=?");
            }
            this.updateItemPS.setString(1, item.getRangeFrom());
            this.updateItemPS.setString(2, item.getRangeTo());
            this.updateItemPS.setDate(3, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
            this.updateItemPS.setDate(4, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
            this.updateItemPS.setString(5, item.getTitle());
            this.updateItemPS.setString(6, item.getComment());
            this.updateItemPS.setInt(7, rangeMapId);
            this.updateItemPS.setInt(8, item.getId());
            this.updateItemPS.executeUpdate();
        } else {
            if (this.insertItemPS == null) {
                this.insertItemPS = this.con.prepareStatement("INSERT INTO " + this.itemTableName + " (mapId, rangeFrom, rangeTo, dateFrom, dateTo, title, comment) VALUES (?,?,?,?,?,?,?)");
            }
            this.insertItemPS.setInt(1, rangeMapId);
            this.insertItemPS.setString(2, item.getRangeFrom());
            this.insertItemPS.setString(3, item.getRangeTo());
            this.insertItemPS.setDate(4, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
            this.insertItemPS.setDate(5, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
            this.insertItemPS.setString(6, item.getTitle());
            this.insertItemPS.setString(7, item.getComment());
            this.insertItemPS.executeUpdate();
        }
        ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.moduleId);
    }

    public void deleteItem(int rangeMapId, int id) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTableName + " WHERE mapId=? AND id=?");
            ps.setInt(1, rangeMapId);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.moduleId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void importMap(int costMapId, String data, String prfx, boolean update) throws BGException {
        try {
            if (Utils.isBlankString((String)prfx)) {
                prfx = null;
            }
            ArrayList<RangeMapItem> result = new ArrayList<RangeMapItem>();
            String[] strings = data.split("\n");
            for (String string : strings) {
                String rangeTo;
                String rangeFrom;
                int index;
                String title;
                Date dateTo;
                Date dateFrom;
                String[] params = string.split("[\\t]", -1);
                if (params.length <= 0) continue;
                String comment = null;
                if (params.length > 4) {
                    comment = params[4];
                }
                if (Utils.isBlankString(comment)) {
                    comment = params[0];
                }
                if (params.length > 3) {
                    dateFrom = TimeUtils.parseDate((String)params[2].trim(), (String)"dd.MM.yyyy");
                    dateTo = TimeUtils.parseDate((String)params[3].trim(), (String)"dd.MM.yyyy");
                    title = params[1];
                    if (Utils.isBlankString((String)title)) {
                        title = null;
                    }
                } else {
                    dateFrom = params.length > 1 ? TimeUtils.parseDate((String)params[1].trim(), (String)"dd.MM.yyyy") : null;
                    dateTo = params.length > 2 ? TimeUtils.parseDate((String)params[2].trim(), (String)"dd.MM.yyyy") : null;
                    title = null;
                }
                if ((index = params[0].indexOf(45)) >= 0) {
                    rangeFrom = params[0].substring(0, index);
                    rangeTo = params[0].substring(index + 1, params[0].length());
                } else {
                    rangeFrom = params[0];
                    rangeTo = params[0];
                }
                RangeMapItem item = new RangeMapItem();
                if (prfx == null) {
                    item.setRangeFrom(rangeFrom);
                    item.setRangeTo(rangeTo);
                } else {
                    item.setRangeFrom(prfx + rangeFrom);
                    item.setRangeTo(prfx + rangeTo);
                }
                item.setDateFrom(dateFrom);
                item.setDateTo(dateTo);
                item.setTitle(title);
                item.setComment(params[0]);
                result.add(item);
            }
            if (!update) {
                PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.itemTableName + " WHERE mapId=?");
                ps.setInt(1, costMapId);
                ps.executeUpdate();
                ps.close();
            }
            for (RangeMapItem item : result) {
                this.updateItemImpl(costMapId, item);
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.moduleId);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public String exportMap(int costMapId) throws BGException {
        List<RangeMapItem> list = this.listItems(costMapId, null);
        StringBuilder result = new StringBuilder(100);
        this.exportMap(list, result);
        return result.toString();
    }

    private void exportMap(List<RangeMapItem> children, StringBuilder sb) {
        if (children != null) {
            for (RangeMapItem child : children) {
                sb.append(child.getRangeFrom()).append('-').append(child.getRangeTo()).append("\t").append(Utils.maskNull((String)child.getTitle())).append("\t").append(TimeUtils.formatDate((Date)child.getDateFrom())).append("\t").append(TimeUtils.formatDate((Date)child.getDateTo())).append("\t").append(Utils.maskNull((String)child.getComment())).append("\n");
            }
        }
    }
}

