/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.agr.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.agr.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.agr.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.agr.common.service.AGRService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    protected BGButton checkStatusButton = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441");
    private BGUComboBox<IdTitle> agrPaymentSystems = new BGUComboBox();
    private BGUPanel.WebServiceHolder<AGRService> agrService = new BGUPanel.WebServiceHolder((BGUPanel)this, AGRService.class);

    public TransactionPanel() {
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
        try {
            List paymentSystems = ((AGRService)this.agrService.get()).getAgrPaymentSystemList();
            paymentSystems.add(0, new IdTitle(-1, "---"));
            this.agrPaymentSystems.setData(paymentSystems);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected JPanel getExtraFilterPanel() {
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.agrPaymentSystems, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.checkStatusButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        return filterPanel;
    }

    protected void initListeners() {
        super.initListeners();
        this.checkStatusButton.addActionListener(e -> {
            this.performAction("checkStatus");
            this.performAction("refresh");
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            IdTitle selectedAgrPaymentSystem = (IdTitle)this.agrPaymentSystems.getSelectedItem();
            SearchParam searchParam = SearchParam.builder().setContractId(this.getContractId()).setStatus(((AbstractTransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setPeriod(this.periodPanel.getPeriod()).setPage(this.pagePanel.getPage()).build();
            SearchResult searchResult = ((AGRService)this.agrService.get()).searchTransactionList(searchParam, selectedAgrPaymentSystem.getTitle());
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "checkStatus", "\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441", e -> this.tryCall(() -> ((AGRService)this.agrService.get()).checkPayment(this.getContractId(), this.periodPanel.getPeriod())));
    }
}

