/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.directory;

import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseOption;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class SmartHouseOptionPanel
extends BGUPanel {
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("Option");
    private BGUPanel.WebServiceHolder<SmartHouseService> smartHouseService = new BGUPanel.WebServiceHolder((BGUPanel)this, SmartHouseService.class);

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams();
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams);
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new OptionEditor("\u041d\u043e\u0432\u0430\u044f \u043e\u043f\u0446\u0438\u044f", new Id()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.tableModel.optSelectRow(Id.class).ifPresentOrElse(id -> new OptionEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0439", (Id)id).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")));
    }

    class OptionEditor
    extends BGEditorDialog<Id> {
        private SmartHouseOption option;
        private BGTextField title;
        private BGTextArea comment;
        private BGUComboBox<IdTitle> smarthouseService;
        private BGUComboBox<IdTitle> npayModule;
        private BGUComboBox<IdTitle> npayService;
        private List<IdTitle> smarthouseServiceItems;
        private List<IdTitle> npayModuleItems;
        private List<IdTitle> npayServiceItems;

        public OptionEditor(String title, Id data) {
            super(title, (Object)data);
            this.option = null;
            this.title = new BGTextField(50);
            this.comment = new BGTextArea(3, 50);
            this.smarthouseService = new BGUComboBox();
            this.npayModule = new BGUComboBox();
            this.npayService = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430 (smarthouse):", (JComponent)this.smarthouseService);
            this.addFieldV("\u041c\u043e\u0434\u0443\u043b\u044c (npay):", (JComponent)this.npayModule);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430 (npay):", (JComponent)this.npayService);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", new JScrollPane((Component)this.comment));
            this.tryCall(() -> {
                this.smarthouseServiceItems = new ArrayList<IdTitle>();
                this.smarthouseServiceItems.add(IdTitle.NO_SELECT);
                Async async1 = Async.of(() -> this.smarthouseServiceItems.addAll(((SmartHouseService)SmartHouseOptionPanel.this.smartHouseService.get()).smarthouseServices()));
                this.npayModuleItems = new ArrayList<IdTitle>();
                this.npayModuleItems.add(IdTitle.NO_SELECT);
                Async async2 = Async.of(() -> this.npayModuleItems.addAll(((SmartHouseService)SmartHouseOptionPanel.this.smartHouseService.get()).npayModules()));
                async1.get();
                async2.get();
                this.smarthouseService.setData(this.smarthouseServiceItems);
                this.npayModule.setData(this.npayModuleItems);
                this.npayModule.addItemListener(SmartHouseOptionPanel.this.comboBoxSelect(e -> this.setNpayServiceItems()));
                this.npayServiceItems = Arrays.asList(IdTitle.NO_SELECT);
                this.npayService.setData(this.npayServiceItems);
                this.option = ((SmartHouseService)SmartHouseOptionPanel.this.smartHouseService.get()).smarthouseOptionGet(((Id)this.data).getId());
                this.title.setText(this.option.getTitle());
                this.comment.setText(this.option.getComment());
                this.npayModule.setSelectedItem((Object)new Id().setId(this.option.getNpayModuleId()));
                this.npayService.setSelectedItem((Object)new Id().setId(this.option.getNpayServiceId()));
                this.smarthouseService.setSelectedItem((Object)new Id().setId(this.option.getSmarthouseServiceId()));
            });
        }

        private void setNpayServiceItems() {
            int moduleId = ((IdTitle)this.npayModule.getSelectedItem()).getId();
            this.npayServiceItems = new ArrayList<IdTitle>();
            this.npayServiceItems.add(IdTitle.NO_SELECT);
            if (moduleId > 0) {
                this.tryCall(() -> this.npayServiceItems.addAll(((SmartHouseService)SmartHouseOptionPanel.this.smartHouseService.get()).npayServices(moduleId)));
            }
            this.npayService.setData(this.npayServiceItems);
        }

        public boolean doApply() throws Exception {
            int npayModuleId = ((IdTitle)this.npayModule.getSelectedItem()).getId();
            int npayServiceId = ((IdTitle)this.npayService.getSelectedItem()).getId();
            if (!(npayModuleId == 0 && npayServiceId == 0 || npayModuleId > 0 && npayServiceId > 0)) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c npay \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433\u0430 npay");
                return false;
            }
            this.option.setTitle(this.title.getText());
            this.option.setComment(this.comment.getText()).setSmarthouseServiceId(((IdTitle)this.smarthouseService.getSelectedItem()).getId()).setNpayModuleId(npayModuleId).setNpayServiceId(npayServiceId);
            return this.tryCallBoolean(() -> {
                ((SmartHouseService)SmartHouseOptionPanel.this.smartHouseService.get()).smarthouseOptionUpdate(this.option);
                SmartHouseOptionPanel.this.performAction("refresh");
            });
        }
    }
}

