/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LoggingSOAPHandlerClient
implements SOAPHandler<SOAPMessageContext> {
    private final Service service;
    private final Logger logger;
    private final Level level;

    public LoggingSOAPHandlerClient(Service service, Logger logger, Level level) {
        this.service = service;
        this.logger = logger;
        this.level = level;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (!this.logger.isEnabled(this.level)) {
            return true;
        }
        try {
            boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
            if (outbound) {
                QName operation = (QName)context.get((Object)"jakarta.xml.ws.wsdl.operation");
                this.logger.log(this.level, String.valueOf(this.service.getWSDLDocumentLocation()) + " -> " + String.valueOf(context.get((Object)"jakarta.xml.ws.wsdl.service")) + (String)(operation != null ? ":" + operation.getLocalPart() : ""));
                if (!(context.getMessage().countAttachments() != 0 || operation != null && operation.getLocalPart().contains("File"))) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(500);
                    context.getMessage().writeTo((OutputStream)out);
                    this.logger.log(this.level, new String(out.toByteArray(), "UTF-8"));
                }
            } else if (context.getMessage().countAttachments() == 0) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(500);
                context.getMessage().writeTo((OutputStream)out);
                this.logger.log(this.level, new String(out.toByteArray(), "UTF-8"));
            }
        }
        catch (SOAPException ex) {
            this.logger.error((Object)ex);
        }
        catch (IOException ex) {
            this.logger.error((Object)ex);
        }
        return true;
    }
}

