/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.modules.inet.client.contract.OptionPanel;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServStatus;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class PatternModuleTabPanelItemFactory
implements PatternModuleTabPanel.PatternModuleTabPanelItemFactory {
    public Collection<PatternModuleTabPanel.PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int mid, String moduleTitle) {
        return Collections.singleton(new AddLogin(mid, moduleTitle));
    }

    private class AddLogin
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private JCheckBox check;
        private BGUComboBox<InetServType> serviceType;
        private BGUComboBox<IdTitle> status;
        private JComponent sessionCountLimitPanel;
        private BGUComboBox<IdTitle> sessionCountLimit;
        private volatile boolean onInetServSelected;
        private OptionPanel inetServOptionPanel;
        private String title;
        private final ClientContext context;

        public AddLogin(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.check = new JCheckBox("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c");
            this.onInetServSelected = true;
            this.title = null;
            this.context = new ClientContext("inet", moduleId, 0, 0, ((Object)((Object)this)).getClass().getPackage());
            this.inetServOptionPanel = new OptionPanel(this.context, null, true);
            this.setTitle("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441");
            this.check.setMinimumSize(new Dimension(150, 26));
            this.check.setPreferredSize(new Dimension(150, 26));
            this.add(this.check, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.serviceType = new BGUComboBox();
            this.serviceType.addActionListener(e -> {
                if (this.onInetServSelected) {
                    this.onInetServSelected();
                }
            });
            this.status = new BGUComboBox();
            this.status.setData(Stream.of(InetServStatus.values()).map(InetServStatus::toIdTitle).toList());
            this.sessionCountLimit = new BGUComboBox();
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            data.add(new IdTitle(0, "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e"));
            for (int i = 1; i <= 30; ++i) {
                data.add(new IdTitle(i, String.valueOf(i)));
            }
            this.sessionCountLimit.setData(data);
            JPanel row = new JPanel(new GridBagLayout());
            row.add((Component)BGSwingUtilites.wrapBorder(this.serviceType, (String)"\u0422\u0438\u043f"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            row.add((Component)BGSwingUtilites.wrapBorder(this.status, (String)"\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.sessionCountLimitPanel = BGSwingUtilites.wrapBorder(this.sessionCountLimit, (String)"\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439");
            row.add((Component)this.sessionCountLimitPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JTabbedPane tabbed = new JTabbedPane();
            tabbed.addTab("\u041e\u043f\u0446\u0438\u0438", (Component)((Object)this.inetServOptionPanel));
            this.add(row, new GridBagConstraints(1, 0, 1, 1, 0.45, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(tabbed, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 14, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        private void onInetServSelected() {
            InetServType inetServType = (InetServType)this.serviceType.getSelectedItem();
            if (inetServType == null) {
                return;
            }
            this.sessionCountLimitPanel.setVisible(!inetServType.isSessionCountLimitLock());
        }

        protected void init() {
            try {
                InetServService servService = (InetServService)this.context.getPort(InetServService.class, this.getModuleId());
                ArrayList<InetServType> servTypeList = servService.inetServTypeList();
                ArrayList<InetServType> newServTypeList = new ArrayList<InetServType>();
                for (InetServType type : servTypeList) {
                    if (type.getParentTypeIds() != null && type.getParentTypeIds().size() != 0) continue;
                    newServTypeList.add(type);
                }
                servTypeList = newServTypeList;
                this.onInetServSelected = false;
                this.serviceType.setData(servTypeList);
                this.onInetServSelected = true;
                this.inetServOptionPanel.setInetOptionList(servService.inetOptionList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected boolean isItemEnabled() {
            return this.check.isSelected();
        }

        protected void reset() {
        }

        protected void serialise(Element element) {
            List<InetServOption> inetServOptionList;
            IdTitle status;
            IdTitle sessionCountLimit;
            Element module = XMLUtils.createElement((Element)element, (String)"inet");
            module.setAttribute("mid", String.valueOf(this.getModuleId()));
            Element addInetServ = XMLUtils.createElement((Element)module, (String)"addInetServ");
            addInetServ.setAttribute("enable", this.check.isSelected() ? "1" : "0");
            InetServType servType = (InetServType)this.serviceType.getSelectedItem();
            if (servType != null) {
                addInetServ.setAttribute("inetServTypeId", String.valueOf(servType.getId()));
            }
            if ((sessionCountLimit = (IdTitle)this.sessionCountLimit.getSelectedItem()) != null) {
                addInetServ.setAttribute("sessionCountLimit", String.valueOf(sessionCountLimit.getId()));
            }
            if ((status = (IdTitle)this.status.getSelectedItem()) != null) {
                addInetServ.setAttribute("status", String.valueOf(status.getId()));
            }
            if ((inetServOptionList = this.inetServOptionPanel.getInetServOptionList()) != null) {
                for (InetServOption inetServOption : inetServOptionList) {
                    Element inetServOptionEl = XMLUtils.createElement((Element)addInetServ, (String)"inetServOption");
                    inetServOptionEl.setAttribute("optionId", String.valueOf(inetServOption.getOptionId()));
                }
            }
        }

        protected void setData(Element element) throws Exception {
            Element addInetServ = XMLUtils.selectElement((Node)element, (String)("data/modules/inet[@mid=" + this.getModuleId() + "]/addInetServ"));
            if (addInetServ != null) {
                this.check.setSelected("1".equals(addInetServ.getAttribute("enable")));
                this.serviceType.setSelectedItem((Object)Utils.parseInt((String)addInetServ.getAttribute("inetServTypeId")));
                this.sessionCountLimit.setSelectedItem((Object)Utils.parseInt((String)addInetServ.getAttribute("sessionCountLimit")));
                this.status.setSelectedItem((Object)Utils.parseInt((String)addInetServ.getAttribute("status")));
                ArrayList<InetServOption> inetServOptionList = new ArrayList<InetServOption>();
                for (Element inetServOptionEl : XMLUtils.selectElements((Node)addInetServ, (String)"inetServOption")) {
                    int optionId = Utils.parseInt((String)inetServOptionEl.getAttribute("optionId"), (int)0);
                    if (optionId <= 0) continue;
                    InetServOption inetServOption = new InetServOption();
                    inetServOption.setOptionId(optionId);
                    inetServOptionList.add(inetServOption);
                }
                this.inetServOptionPanel.setInetServOptionList(inetServOptionList);
            } else {
                this.check.setSelected(false);
                addInetServ = element.getOwnerDocument().createElement("addInetServ");
                element.appendChild(addInetServ);
                this.inetServOptionPanel.setInetServOptionList(new ArrayList<InetServOption>());
            }
        }
    }
}

