/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBooleanEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigDynamicEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigListEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigMultiDynamicEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigNumberEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigStringEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigTitle;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.io.Base64;

public class BGServiceConfigModulePatternPanel
extends BGPanel {
    private BGTableModel<ConfigTitle> patternModel;
    private BGUTable patternTable;
    private JEditorPane patternHelp;
    private BGSplitPane patternSplitPane;
    private ConfigStringEditor stringEditor;
    private ConfigNumberEditor numberEditor;
    private ConfigDynamicEditor dynamicEditor;
    private ConfigMultiDynamicEditor multiDynamicEditor;
    private ConfigListEditor listEditor;
    private ConfigBooleanEditor booleanEditor;
    private String configString;
    private BGTextField searchTextField;
    private Document configXmlDoc;

    public BGServiceConfigModulePatternPanel() {
        this.patternTable = new BGUTable(this.patternModel);
        this.patternHelp = new JEditorPane();
        this.stringEditor = new ConfigStringEditor();
        this.numberEditor = new ConfigNumberEditor();
        this.dynamicEditor = new ConfigDynamicEditor();
        this.multiDynamicEditor = new ConfigMultiDynamicEditor();
        this.listEditor = new ConfigListEditor();
        this.booleanEditor = new ConfigBooleanEditor();
        this.configString = new String();
        this.searchTextField = new BGTextField();
        this.configXmlDoc = null;
        this.patternTable = new BGUTable(this.patternModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component component = super.prepareRenderer(renderer, row, column);
                ConfigTitle rowConfig = BGServiceConfigModulePatternPanel.this.patternModel.getRows().get(row);
                component.setBackground(null);
                if (this.isCellSelected(row, column)) {
                    component.setBackground(this.selectionBackground);
                }
                if (rowConfig.getEl() != null) {
                    if (rowConfig.isBold()) {
                        component.setFont(new Font(component.getFont().getName(), 1, component.getFont().getSize()));
                    }
                    if (!rowConfig.isCorrect()) {
                        Color col = new Color(255, 133, 133);
                        component.setBackground(this.isCellSelected(row, column) ? col.darker() : col);
                    }
                } else {
                    component.setBackground(Color.GRAY);
                    if (this.isCellSelected(row, column)) {
                        component.setBackground(Color.DARK_GRAY);
                    }
                }
                return component;
            }
        };
        this.patternModel = new BGTableModel<ConfigTitle>("\u041a\u043e\u043d\u0444\u0438\u0433"){

            @Override
            protected void initColumns() {
                this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "type", true, HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 250, 300, 350, "key", true, HorizontalAlignmentTableCellRenderer.LEFT());
                this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 150, 150, -1, "value", true, HorizontalAlignmentTableCellRenderer.LEFT());
            }

            @Override
            public Object getValue(ConfigTitle val, int column) throws Exception {
                String searchText = BGServiceConfigModulePatternPanel.this.searchTextField.getText();
                String identifier = this.getIdentifier(column);
                if ("key".equals(identifier)) {
                    if (!Utils.isBlankString(searchText)) {
                        String keyStr = val.getKey();
                        if (keyStr.toLowerCase().indexOf(searchText.toLowerCase()) != -1) {
                            int indexStart = keyStr.toLowerCase().indexOf(searchText.toLowerCase());
                            int indexFinish = indexStart + searchText.length();
                            String start = keyStr.substring(0, indexStart);
                            String finish = keyStr.substring(indexFinish, keyStr.length());
                            String result = "<html><body>" + start + "<span style='color:FF0000;background-color:CBD2E5'>" + String.valueOf(keyStr.subSequence(indexStart, indexFinish)) + "</span>" + finish + "</body></html>";
                            return result;
                        }
                        return val.getKey();
                    }
                    return val.getKey();
                }
                if ("value".equals(identifier)) {
                    if (!Utils.isBlankString(searchText)) {
                        String valueStr = val.getValue();
                        if (valueStr.toLowerCase().indexOf(searchText.toLowerCase()) != -1) {
                            int indexStart = valueStr.toLowerCase().indexOf(searchText.toLowerCase());
                            int indexFinish = indexStart + searchText.length();
                            String start = valueStr.substring(0, indexStart);
                            String finish = valueStr.substring(indexFinish, valueStr.length());
                            String result = "<html><body>" + start + "<span style='color:FF0000;background-color:CBD2E5'>" + String.valueOf(valueStr.subSequence(indexStart, indexFinish)) + "</span>" + finish + "</body></html>";
                            return result;
                        }
                        return val.getValue();
                    }
                    return val.getValue();
                }
                if ("type".equals(identifier)) {
                    switch (val.getType()) {
                        case "list": {
                            if (val.isCorrect()) {
                                return "\u0421\u043f\u0438\u0441\u043e\u043a";
                            }
                            return "\u0421\u043f\u0438\u0441\u043e\u043a(\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                        case "dynamic": {
                            if (val.isCorrect() || val.getValue().equals("")) {
                                return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439";
                            }
                            return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439(\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                        case "doubleDynamic": {
                            if (val.isCorrect() || val.getValue().equals("|")) {
                                return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 - \u0434\u0432\u043e\u0439\u043d\u0430\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c";
                            }
                            return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 - \u0434\u0432\u043e\u0439\u043d\u0430\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c (\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                        case "tripleDynamic": {
                            if (val.isCorrect() || val.getValue().equals("||")) {
                                return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 - \u0442\u0440\u043e\u0439\u043d\u0430\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c";
                            }
                            return "\u0414\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439 - \u0442\u0440\u043e\u0439\u043d\u0430\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c (\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                        case "number": {
                            if (val.isCorrect()) {
                                return "\u0427\u0438\u0441\u043b\u043e";
                            }
                            return "\u0427\u0438\u0441\u043b\u043e(\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                        case "boolean": {
                            if (val.isCorrect()) {
                                return "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439";
                            }
                            return "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439(\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                        }
                    }
                    if (val.isCorrect()) {
                        return "\u0421\u0442\u0440\u043e\u043a\u0430";
                    }
                    return "\u0421\u0442\u0440\u043e\u043a\u0430(\u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!!!)";
                }
                return super.getValue(val, column);
            }
        };
        this.patternTable.setModel(this.patternModel);
        this.patternSplitPane = new BGSplitPane(1, new JScrollPane(this.patternTable), new JScrollPane(this.patternHelp));
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u041f\u043e\u0438\u0441\u043a:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.searchTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.patternSplitPane), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.patternHelp.setContentType("text/html");
        this.patternHelp.setEditable(false);
        this.patternTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Object text = "\u0421\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0434\u0430\u043d\u043d\u043e\u043c\u0443 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0443 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442";
            ConfigTitle selectRow = null;
            if (this.patternModel != null && (selectRow = this.patternModel.getSelectedRow()) != null && selectRow.getEl() != null) {
                try {
                    Element helpElement = XMLUtils.selectElement(this.patternModel.getSelectedRow().getEl(), "help");
                    if (helpElement != null) {
                        text = helpElement.getTextContent();
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
                if ("list".equals(selectRow.getType()) && selectRow.getEl().hasChildNodes()) {
                    ComboBoxItem item;
                    ConfigListEditor ed = new ConfigListEditor();
                    DefaultComboBoxModel<ComboBoxItem> boxModel = ed.buildComboBox(selectRow.getEl(), null, "value");
                    String defVal = selectRow.getDefaultValue();
                    for (int i = 0; i < boxModel.getSize() && !Utils.isBlankString((item = boxModel.getElementAt(i)).toString()); ++i) {
                        text = (String)text + "<br>" + String.valueOf(item);
                        if (!Utils.notBlankString(defVal) || !defVal.equals(item.getObject())) continue;
                        text = (String)text + " <b>(\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e)</b>";
                    }
                }
            }
            this.patternHelp.setText((String)text);
        });
        this.patternTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    ConfigTitle selectRow = BGServiceConfigModulePatternPanel.this.patternModel.getSelectedRow();
                    switch (selectRow.getType()) {
                        case "number": {
                            BGServiceConfigModulePatternPanel.this.numberEditor = new ConfigNumberEditor();
                            if (!BGServiceConfigModulePatternPanel.this.numberEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.numberEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.numberEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.numberEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        case "dynamic": {
                            BGServiceConfigModulePatternPanel.this.dynamicEditor = new ConfigDynamicEditor();
                            if (!BGServiceConfigModulePatternPanel.this.dynamicEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.dynamicEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.dynamicEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.dynamicEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        case "list": {
                            BGServiceConfigModulePatternPanel.this.listEditor = new ConfigListEditor();
                            if (!BGServiceConfigModulePatternPanel.this.listEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.listEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.listEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.listEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        case "boolean": {
                            BGServiceConfigModulePatternPanel.this.booleanEditor = new ConfigBooleanEditor();
                            if (!BGServiceConfigModulePatternPanel.this.booleanEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.booleanEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.booleanEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.booleanEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        case "doubleDynamic": {
                            BGServiceConfigModulePatternPanel.this.multiDynamicEditor = new ConfigMultiDynamicEditor();
                            if (!BGServiceConfigModulePatternPanel.this.multiDynamicEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.multiDynamicEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.multiDynamicEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.multiDynamicEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        case "tripleDynamic": {
                            BGServiceConfigModulePatternPanel.this.multiDynamicEditor = new ConfigMultiDynamicEditor();
                            if (!BGServiceConfigModulePatternPanel.this.multiDynamicEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.multiDynamicEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.multiDynamicEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.multiDynamicEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                            break;
                        }
                        default: {
                            BGServiceConfigModulePatternPanel.this.stringEditor = new ConfigStringEditor();
                            if (!BGServiceConfigModulePatternPanel.this.stringEditor.showDialog(selectRow).equals("ok")) break;
                            BGServiceConfigModulePatternPanel.this.editConfig(selectRow, BGServiceConfigModulePatternPanel.this.stringEditor.getResult());
                            selectRow.setValue(BGServiceConfigModulePatternPanel.this.stringEditor.getResult());
                            if (!BGServiceConfigModulePatternPanel.this.stringEditor.isReset()) break;
                            BGServiceConfigModulePatternPanel.this.resetParam(selectRow);
                        }
                    }
                    BGServiceConfigModulePatternPanel.this.setDataPatternTable(BGServiceConfigModulePatternPanel.this.configString);
                }
                super.mouseClicked(e);
            }
        });
        this.searchTextField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent arg0) {
                BGServiceConfigModulePatternPanel.this.setDataPatternTable(BGServiceConfigModulePatternPanel.this.configString);
            }
        });
    }

    public void setDataPatternTable(String config) {
        this.setDataPatternTable(config, false);
    }

    public void setDataPatternTable(String config, boolean local) {
        this.patternSplitPane.setDefaultDividerLocation(0.8);
        this.configString = config;
        String[] textConfig = config.split("\n");
        HashMap<String, String> configMap = new HashMap<String, String>();
        for (String str : textConfig) {
            int index;
            if (str.trim().startsWith("#") || (index = str.indexOf("=")) == -1) continue;
            configMap.put(str.substring(0, index), str.substring(index + 1));
        }
        ArrayList<ConfigTitle> listModel = new ArrayList<ConfigTitle>();
        try {
            Element con;
            String configInBase64;
            if (this.configXmlDoc == null) {
                Request request = new Request();
                request.setAction("GetConfigXml");
                request.setModule("admin");
                request.setModuleId(this.getModuleId());
                if (local) {
                    request.setAttribute("local", local);
                }
                this.configXmlDoc = TransferManager.getDocument(request);
            }
            if (ClientUtils.checkStatus(this.configXmlDoc) && !(configInBase64 = (con = XMLUtils.selectElement(this.configXmlDoc, "//configXml")).getAttribute("config")).isEmpty()) {
                Document configXml = XMLUtils.parseDocument(Base64.decode(Utils.stringToBytes(configInBase64, null)));
                for (Element el : XMLUtils.selectElements(configXml, "/data/key")) {
                    String subVal;
                    int sep;
                    String key = el.getAttribute("key");
                    String value = (String)configMap.get(key);
                    boolean isBold = true;
                    if (value == null) {
                        value = el.getAttribute("default");
                        isBold = false;
                    } else {
                        configMap.remove(key);
                    }
                    if (this.contains(key, value)) {
                        listModel.add(new ConfigTitle(value, el, isBold));
                    }
                    this.dynamic(key, value, el, configMap, configXml, listModel);
                    if (el.getAttribute("type").equals("doubleDynamic") && !value.equals("|")) {
                        sep = value.lastIndexOf(124);
                        if (sep > 0) {
                            subVal = value.substring(sep + 1);
                            value = value.substring(0, sep);
                            String[] valueMas = this.dynamicEditor.getValues(value);
                            String[] subValueMas = this.dynamicEditor.getValues(subVal);
                            if (valueMas != null && subValueMas != null) {
                                for (Element elSub : XMLUtils.selectElements(configXml, "/data/subKey[@parentKey='" + key + "']")) {
                                    for (int i = 0; i < valueMas.length; ++i) {
                                        String Bkey = elSub.getAttribute("mask").replaceFirst("%", valueMas[i]);
                                        for (int ind = 0; ind < subValueMas.length; ++ind) {
                                            String subKey = Bkey.replaceFirst("\\$", subValueMas[ind]);
                                            String valueSub = configMap.get(subKey);
                                            isBold = true;
                                            if (valueSub == null) {
                                                valueSub = elSub.getAttribute("default");
                                                isBold = false;
                                            } else {
                                                configMap.remove(subKey);
                                            }
                                            if (!this.contains(subKey, valueSub)) continue;
                                            listModel.add(new ConfigTitle(subKey, valueSub, elSub, isBold));
                                        }
                                    }
                                }
                            }
                        } else {
                            ClientUtils.showErrorMessageDialog("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0430\u0437\u0431\u043e\u0440\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430: \n" + key + "=" + value);
                        }
                    }
                    if (!el.getAttribute("type").equals("tripleDynamic")) continue;
                    sep = value.lastIndexOf(124);
                    subVal = value.substring(sep + 1);
                    String boofValue = value.substring(0, sep);
                    sep = boofValue.lastIndexOf(124);
                    String midVal = boofValue.substring(sep + 1);
                    value = boofValue.substring(0, sep);
                    String[] valueMas = this.dynamicEditor.getValues(value);
                    String[] subValueMas = this.dynamicEditor.getValues(subVal);
                    String[] midValueMas = this.dynamicEditor.getValues(midVal);
                    if (valueMas == null || subValueMas == null) continue;
                    for (Element elSub : XMLUtils.selectElements(configXml, "/data/subKey[@parentKey='" + key + "']")) {
                        for (int i = 0; i < valueMas.length; ++i) {
                            String Bkey = elSub.getAttribute("mask").replaceFirst("@", valueMas[i]);
                            for (int ind = 0; ind < midValueMas.length; ++ind) {
                                String Mkey = Bkey.replaceFirst("%", midValueMas[ind]);
                                for (int lInd = 0; lInd < subValueMas.length; ++lInd) {
                                    String subKey = Mkey.replaceFirst("\\$", subValueMas[lInd]);
                                    String valueSub = configMap.get(subKey);
                                    isBold = true;
                                    if (valueSub == null) {
                                        valueSub = elSub.getAttribute("default");
                                        isBold = false;
                                    } else {
                                        configMap.remove(subKey);
                                    }
                                    if (!this.contains(subKey, valueSub)) continue;
                                    listModel.add(new ConfigTitle(subKey, valueSub, elSub, isBold));
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        if (configMap.size() > 0) {
            for (Map.Entry entry : configMap.entrySet()) {
                if (!this.contains((String)entry.getKey(), (String)entry.getValue())) continue;
                listModel.add(new ConfigTitle((String)entry.getKey(), (String)entry.getValue(), null, false));
            }
        }
        this.patternModel.setData(listModel, false);
    }

    private void dynamic(String key, String value, Element el, Map<String, String> configMap, Document configXml, List<ConfigTitle> listModel) throws Exception {
        String[] valueMas;
        if (el.getAttribute("type").equals("dynamic") && (valueMas = this.dynamicEditor.getValues(value)) != null) {
            for (int i = 0; i < valueMas.length; ++i) {
                for (Element subEl : XMLUtils.selectElements(configXml, "/data/subKey[@parentKey='" + key + "']")) {
                    String subKey = subEl.getAttribute("mask").replaceFirst("\\$", valueMas[i]);
                    String subValue = configMap.get(subKey);
                    boolean isBold = true;
                    if (subValue == null) {
                        subValue = subEl.getAttribute("default");
                        isBold = false;
                    } else {
                        configMap.remove(subKey);
                    }
                    if (this.contains(subKey, subValue)) {
                        listModel.add(new ConfigTitle(subKey, subValue, subEl, isBold));
                    }
                    this.dynamic(subKey, subValue, subEl, configMap, configXml, listModel);
                }
            }
        }
    }

    private void editConfig(ConfigTitle selectRow, String resultText) {
        try {
            String oldText = selectRow.getRow();
            String newText = selectRow.getKey() + "=" + resultText;
            String nTxt = this.ecran(newText);
            if (this.configString.indexOf(oldText) != -1) {
                this.configString = this.configString.replaceFirst("(?m)^" + Pattern.quote(oldText), nTxt);
            } else {
                int prevIndex = this.getPreviousRowNumber(this.patternModel.getRows().indexOf(selectRow));
                if (prevIndex != -1) {
                    String prevString = this.patternModel.getRows().get(prevIndex).getRow();
                    String pStr = this.ecran(prevString);
                    this.configString = this.configString.replaceFirst("(?m)^" + Pattern.quote(prevString), pStr + "\n" + nTxt);
                } else {
                    this.configString = newText + "\n" + this.configString;
                }
            }
            selectRow.setBold(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String ecran(String newText) {
        String nTxt = newText.replaceAll("([\\\\])", "\\\\\\\\");
        nTxt = nTxt.replaceAll("([\\$])", "\\\\\\$");
        return nTxt;
    }

    public String getTextConfig() {
        return this.configString;
    }

    private int getPreviousRowNumber(int numberRow) {
        for (int i = numberRow - 1; i > 0; --i) {
            if (!this.patternModel.getRows().get(i).isBold()) continue;
            return i;
        }
        return -1;
    }

    private void resetParam(ConfigTitle selectRow) {
        if (selectRow.isBold()) {
            try {
                this.configString = this.configString.replaceFirst("(?m)^" + Pattern.quote(selectRow.getRow()) + "\n", "");
                selectRow.setBold(false);
                this.setDataPatternTable(this.configString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean contains(String key, String value) {
        if (!Utils.isBlankString(this.searchTextField.getText())) {
            return key.toLowerCase().indexOf(this.searchTextField.getText().toLowerCase()) != -1 || value.toLowerCase().indexOf(this.searchTextField.getText().toLowerCase()) != -1;
        }
        return true;
    }
}

