/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payonline.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.payonline.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.payonline.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.payonline.server.event.PayonlineAutopaymentEvent;
import ru.bitel.bgbilling.modules.payonline.server.service.PayOnlineServiceImpl;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.payonline.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), PayOnlineServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, final BGModule module) throws BGException {
        this.registerMBean(module);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<PayonlineAutopaymentEvent>(){

            public void notify(PayonlineAutopaymentEvent event, EventListenerContext ctx) throws Exception {
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode()) {
                    ContractDao contractDao = new ContractDao(con, 0);
                    Contract contract = (Contract)contractDao.get(contractId);
                    contractDao.close();
                    if (contract != null) {
                        // empty if block
                    }
                }
            }
        }, PayonlineAutopaymentEvent.class);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "payonline", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

