/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMap;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneCostMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService")
public class VoiceZoneServiceImpl
extends AbstractService
implements VoiceZoneService {
    private VoiceZoneCostMapDao voiceZoneCostMapDao;

    @PostConstruct
    private void init() {
        this.voiceZoneCostMapDao = new VoiceZoneCostMapDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<VoiceZone> searchVoiceZone(String[] sort, Page page) throws Exception {
        if (sort != null && sort.length == 0) {
            sort = new String[]{"title:0"};
        }
        SearchResult searchResult = new SearchResult(page, sort);
        try (VoiceZoneDao voiceZoneDao = new VoiceZoneDao(this.getConnection(), this.moduleId);){
            voiceZoneDao.searchVoiceZone((SearchResult<VoiceZone>)searchResult);
        }
        return searchResult;
    }

    public List<VoiceZone> voiceZoneList() throws Exception {
        List list = this.context.getDirectory(VoiceZone.class, this.moduleId).list();
        Collections.sort(list, new Comparator<VoiceZone>(this){

            @Override
            public int compare(VoiceZone o1, VoiceZone o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return list;
    }

    public VoiceZone voiceZoneGet(int zoneId) throws BGException {
        return (VoiceZone)this.context.getDirectory(VoiceZone.class, this.moduleId).get(zoneId);
    }

    public int voiceZoneUpdate(VoiceZone zone) throws BGException {
        try {
            this.context.newDirectory(VoiceZone.class, this.moduleId).update((Id)zone);
            return zone.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public int voiceZoneDelete(int zoneId) throws BGException {
        try {
            return this.context.newDirectory(VoiceZone.class, this.moduleId).delete(zoneId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<VoiceZoneCostMap> voiceZoneCostMapList() throws Exception {
        return this.voiceZoneCostMapDao.list();
    }

    public VoiceZoneCostMap voiceZoneCostMapGet(int id) throws Exception {
        VoiceZoneCostMap voiceZoneCostMap = (VoiceZoneCostMap)this.voiceZoneCostMapDao.get(id);
        voiceZoneCostMap.setCosts(this.voiceZoneCostMapDao.getCosts(id));
        return voiceZoneCostMap;
    }

    public int voiceZoneCostMapUpdate(VoiceZoneCostMap voiceZoneCostMap) throws Exception {
        this.voiceZoneCostMapDao.update(voiceZoneCostMap);
        return voiceZoneCostMap.getId();
    }

    public void voiceZoneCostMapDelete(int id) throws Exception {
        this.voiceZoneCostMapDao.delete(id);
    }
}

