/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.botmanager.server.bots.BotSender;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseComponentCategory;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseComponentDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.mail.MailAddOrder;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;

public class ActionLicense
extends AbstractAction {
    private static final Object mutex = new Object();

    public ActionLicense() {
        super("license");
    }

    public void execute() throws Exception {
        this.productCopy();
        super.execute();
    }

    public void licenseList() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        LicenseCopy copy = licenseManager.getCopy(copyId);
        if (copy != null && copy.getContractId() == this.contractId) {
            this.setResultParam("copy", copy);
            this.setResultParam("licenseList", licenseManager.getLicenses(copyId));
        }
        this.requestDispatcher(this.moduleName, "license_list");
    }

    public void licenseComponents() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        License license = licenseManager.getLicenseById(this.req.getInt("licenseId", -1));
        if (license != null) {
            LicenseCopy copy = licenseManager.getCopy(license.getCopyId());
            if (copy != null && copy.getContractId() == this.contractId) {
                String productVersion = copy.getProductVersion();
                this.licenseItemsList(license.getId(), productVersion, licenseManager);
            }
            this.setResultParam("license", license);
        }
        this.requestDispatcher(this.moduleName, "license_components");
    }

    public void licenseText() throws BGException {
        LicenseCopy copy;
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        License license = licenseManager.getLicenseById(this.req.getInt("licenseId", -1));
        if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
            this.setResultParam("licenseText", licenseManager.getLicenseText(license.getId()));
        }
        this.requestDispatcher(this.moduleName, "license_text");
    }

    public void licenseToEmail() throws BGException {
        this.setResultParam("licenseId", this.req.getInt("licenseId", -1));
        this.setResultParam("recipientList", this.getRecipientList());
        this.requestDispatcher(this.moduleName, "license_mail");
    }

    public void sendLicenseToEmail() throws BGException {
        int licenseId = this.req.getInt("licenseId", -1);
        StringBuilder sendEmailMessage = new StringBuilder();
        StringBuilder sendEmailError = new StringBuilder();
        String mails = this.req.get("email");
        if (!mails.isEmpty()) {
            try {
                LicenseCopy copy;
                LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
                License license = licenseManager.getLicenseById(licenseId);
                if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
                    String licenseText = licenseManager.getLicenseText(license.getId());
                    LicenseUtils.sendLiceneseText(mails, licenseText, "\u0422\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", this.moduleId);
                    sendEmailMessage.append("\u0422\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u0430\u0434\u0440\u0435\u0441(\u0430): ");
                    sendEmailMessage.append(mails);
                }
            }
            catch (Exception e) {
                sendEmailError.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f: ");
                sendEmailError.append(e.getMessage());
            }
        } else {
            sendEmailError.append("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438. \u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438.");
        }
        this.setResultParam("sendEmailMessage", sendEmailMessage.toString());
        this.setResultParam("sendEmailError", sendEmailError.toString());
        this.requestDispatcher(this.moduleName, "license_mail_message");
    }

    public void getLicense() throws BGException {
        LicenseCopy copy;
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        License license = licenseManager.getCurrentLicense(copyId);
        if (license != null && (copy = licenseManager.getCopy(license.getCopyId())) != null && copy.getContractId() == this.contractId) {
            String licenseText = licenseManager.getLicenseText(license.getId());
            this.setResultParam("contentType", "binary");
            this.context.getResponse().setContentType("application/txt;charset=UTF-8");
            this.context.getResponse().setHeader("Content-Disposition", "attachment;filename=\"lic.properties\"");
            try {
                ServletOutputStream responseStream = this.context.getResponse().getOutputStream();
                responseStream.write(licenseText.getBytes());
                responseStream.flush();
                responseStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void licenseOrders() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int copyId = this.req.getInt("copyId", -1);
        LicenseCopy copy = licenseManager.getCopy(copyId);
        if (copy != null && copy.getContractId() == this.contractId) {
            List<LicenseOrder> listAdded = licenseManager.getOrders(copy.getId(), null, Stream.of(Integer.valueOf(0)).toList(), -1);
            this.setResultParam("orderListAdded", listAdded);
            this.setResultParam("copy", copy);
        }
        this.requestDispatcher(this.moduleName, "license_orders");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void licenseOrderComponents() throws Exception {
        int orderIndex;
        int copyId = this.req.getInt("copyId", -1);
        ArrayList<LicenseOrder> orders = (ArrayList<LicenseOrder>)this.context.getRequest().getSession().getAttribute("orders");
        if (orders == null) {
            orders = new ArrayList<LicenseOrder>();
            this.context.getRequest().getSession().setAttribute("orders", orders);
        } else {
            boolean reset = false;
            for (LicenseOrder order : orders) {
                if (order.getCopyId() == copyId) continue;
                reset = true;
                break;
            }
            if (reset) {
                orders = new ArrayList();
                this.context.getRequest().getSession().setAttribute("orders", orders);
            }
        }
        List<LicenseComponent> productItems = new LicenseComponentDao(this.con, this.moduleId).list(copyId, false, true);
        HashMap<Integer, LicenseComponent> componentMap = new HashMap<Integer, LicenseComponent>();
        int productItemId = this.req.getInt("productItemId", -1);
        if (productItemId > 0) {
            boolean add = false;
            boolean unlimited = false;
            for (Object component : productItems) {
                if (component.getId() != productItemId) continue;
                add = true;
                unlimited = component.getUnlimited() == 1;
                break;
            }
            if (add) {
                Object component;
                LicenseOrder order = null;
                component = mutex;
                synchronized (component) {
                    add = true;
                    for (LicenseOrder checkOrder : orders) {
                        if (checkOrder.getCopyId() != copyId || checkOrder.getComponentId() != productItemId) continue;
                        order = checkOrder;
                        add = false;
                        break;
                    }
                    if (add) {
                        order = LicenseOrder.builder().setCopyId(copyId).setComponentId(productItemId).setStatus(0).setUserId(0).build();
                        orders.add(order);
                    }
                    order.setType(LicenseOrderType.getOrderTypeByCode((int)this.req.getInt("orderType", 1)));
                    order.setCount(unlimited ? 0 : this.req.getInt("orderCount", 1));
                    order.setTerm(order.getType() == LicenseOrderType.TEST ? this.req.getInt("orderTerm", 15) : 0);
                }
            }
        }
        if ((orderIndex = this.req.getInt("orderIndex", -1)) > -1) {
            orders.remove(orderIndex);
        }
        block6: for (LicenseOrder order : orders) {
            int len = productItems.size();
            for (int i = 0; i < len; ++i) {
                LicenseComponent component = productItems.get(i);
                if (order.getComponentId() != component.getId()) continue;
                componentMap.put(component.getId(), component);
                productItems.remove(i);
                continue block6;
            }
        }
        int categoryId = this.req.getInt("categoryId", Utils.parseInt((String)((String)this.context.getRequest().getSession().getAttribute("categoryId")), (int)-1));
        this.context.getRequest().getSession().setAttribute("categoryId", (Object)String.valueOf(categoryId));
        if (categoryId > -1) {
            ArrayList<LicenseComponent> filterPproductItems = new ArrayList<LicenseComponent>();
            productItems.stream().filter(a -> a.getCategory().getCode() == categoryId).forEach(a -> filterPproductItems.add((LicenseComponent)a));
            productItems = filterPproductItems;
        }
        this.setResultParam("productItems", productItems);
        this.setResultParam("componentMap", componentMap);
        this.setResultParam("componentCategory", LicenseComponentCategory.values());
        this.requestDispatcher(this.moduleName, "license_orders_product_items");
    }

    public void licenseEditComponent() throws Exception {
        int orderIndex;
        ArrayList orders = (ArrayList)this.context.getRequest().getSession().getAttribute("orders");
        if (orders == null) {
            orders = new ArrayList();
            this.context.getRequest().getSession().setAttribute("orders", orders);
        }
        if ((orderIndex = this.req.getInt("orderIndex", -1)) > -1 && orderIndex < orders.size()) {
            LicenseOrder order = (LicenseOrder)orders.get(orderIndex);
            this.setResultParam("productItem", new LicenseComponentDao(this.con, this.moduleId).get(order.getComponentId()));
            this.setResultParam("order", order);
        }
        this.requestDispatcher(this.moduleName, "license_orders_editor");
    }

    public void addOrder() throws BGException {
        ActionMessage message = new ActionMessage("licenseTab", "licenseOrders", "licenseQuery", "\u0417\u0430\u043a\u0430\u0437 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d");
        this.setResultParam("message", message);
        int copyId = this.req.getInt("copyId", -1);
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        List orders = (List)this.context.getRequest().getSession().getAttribute("orders");
        boolean buy = orders.stream().anyMatch(o -> o.getType().equals((Object)LicenseOrderType.BUY));
        if (buy && licenseManager.checkHaveNonSignAdditionalAgreement(copyId)) {
            message.setOnClose("close");
            message.setText("\u0417\u0430\u043a\u0430\u0437 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d! \u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c (\u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442), \u0430 \u0435\u0441\u043b\u0438 \u0432\u044b \u0435\u0433\u043e \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0442\u0438\u043b\u0438, \u0442\u043e \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043d\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u0435 \u043d\u0430\u043c \u0435\u0433\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c.");
            this.requestDispatcher("include", "popup_message");
            return;
        }
        try {
            String messageText = "\u0417\u0430\u043a\u0430\u0437 " + copyId;
            List<Long> userIds = Arrays.asList(311234868L);
            BotSender.BotMessage botMessage = BotSender.BotMessage.createMessage().setUserIds(userIds).setText(messageText);
            new BotSender().send(botMessage);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<LicenseOrder> updateOrders = new ArrayList<LicenseOrder>();
        for (LicenseOrder order : orders) {
            block9: {
                try {
                    licenseManager.updateCopyItemOrder(order);
                    updateOrders.add(order);
                }
                catch (Exception e) {
                    if (!(e instanceof BGMessageException)) break block9;
                    orders.removeAll(updateOrders);
                    message.setOnClose("close");
                    message.setText(e.getMessage());
                    this.requestDispatcher("include", "popup_message");
                    return;
                }
            }
            if ((order = licenseManager.getOrder(order.getId())) == null || order.getType() != LicenseOrderType.TEST) continue;
            String recipient = this.moduleSetup.get("license.bills.email.to", "");
            if (Utils.notBlankString((String)recipient)) {
                ContractUtils cu = new ContractUtils(this.con);
                String text = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(this.contractId, false) + " \u0434\u043e\u0431\u0430\u0432\u0438\u043b \u0437\u0430\u043a\u0430\u0437 \u043d\u0430 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \n" + order.getComponentName() + " \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 " + OrderUtils.getCount((Integer)order.getCount()) + " \u043d\u0430 \u0441\u0440\u043e\u043a " + order.getTerm() + " \u0434\u043d\u0435\u0439.";
                try {
                    MailAddOrder mailData = new MailAddOrder();
                    mailData.setModuleId(this.moduleId);
                    mailData.setRecipients(recipient);
                    mailData.setSubject("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430");
                    mailData.addTextPart("text", text);
                    new MailMsg((Preferences)this.setup).sendMessage((MailData)mailData);
                    continue;
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
            LogManager.getLogger().error("Wrong license.bills.email.to value. Can't send email.");
        }
        this.context.getRequest().getSession().removeAttribute("orders");
        this.requestDispatcher("include", "popup_message");
    }

    private void productCopy() throws BGException {
        if (this.contractId <= 0 && this.moduleId <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<LicenseCopy> copies = new LicenseManager(this.con, this.moduleId).getCopyList(this.contractId);
        this.setResultParam("copies", copies);
        this.setResultParam("copyId", copies.isEmpty() ? -1 : copies.get(0).getId());
    }

    private void licenseItemsList(int licenseId, String productVersion, LicenseManager licenseManager) {
        List<LicenseOrderConfirmed> confirmedOrders = licenseManager.getLicenseItems(licenseId, false);
        Map<String, BigDecimal> licenseItemCosts = this.getItemsCosts(confirmedOrders, productVersion);
        BigDecimal totalCost = BigDecimal.ZERO;
        Date now = new Date();
        ArrayList licenseItems = new ArrayList();
        for (LicenseOrderConfirmed item : confirmedOrders) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", OrderUtils.getType((LicenseOrderType)LicenseOrderType.getOrderTypeByCode((int)item.getType())));
            map.put("title", item.getComponentTitle());
            map.put("ids", item.getIds());
            map.put("count", OrderUtils.getCount((Integer)item.getCount()));
            if (TimeUtils.dateBeforeOrEq((Date)item.getDateTo(), (Date)now)) {
                map.put("dateOf", "true");
            }
            map.put("to_date", TimeUtils.format((Date)item.getDateTo(), (String)"dd.MM.yyyy"));
            BigDecimal itemCost = licenseItemCosts.get(item.getComponentName());
            if (itemCost == null || item.getType() == LicenseOrderType.TEST.getCode()) {
                itemCost = BigDecimal.ZERO;
            }
            totalCost = totalCost.add(itemCost);
            map.put("cost", itemCost);
            licenseItems.add(map);
        }
        this.setResultParam("licenseItemsList", licenseItems);
        this.setResultParam("totalCost", totalCost);
    }

    private Map<String, BigDecimal> getItemsCosts(List<LicenseOrderConfirmed> items, String productVersion) {
        return LicenseUtils.getCosts(LicenseUtils.buildLicenseCostUrlRequest(items, productVersion, (ParameterMap)this.moduleSetup));
    }

    private List<String> getRecipientList() throws BGException {
        try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
            List recipientList = null;
            int emailParameterId = this.moduleSetup.getInt("license.email.parameter.id", 0);
            EntityAttr entityAttr = contractDao.getContractParameter(this.contractId, emailParameterId);
            if (entityAttr instanceof EntityAttrEmail) {
                recipientList = ((EntityAttrEmail)entityAttr).getAddressList();
            }
            List list = recipientList;
            return list;
        }
    }
}

