package ru.bitel.bgbilling.modules.sorm.dyn.cdr;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRUploadCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

import java.nio.file.Path;

import static ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransConstants.FILE_TITLE_PATTERN;
import static ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils.getUploadFile;

public class NorsiTransCDRUpload
    extends CDRUploadCommon
{

    public NorsiTransCDRUpload( int sormModuleId,
                                SormProject sormProject )
    throws BGException
    {
        super( sormModuleId, sormProject );
    }

    @Override
    public SormManufacturer getSormManufacturer()
    {
        return SormManufacturer.NORSITRANS;
    }

    @Override
    public Path getFile()
        throws BGException
    {
        return getUploadFile( localUserPath,
                              NorsiTransFileTitle.CDR.getTitle(),
                              FILE_TITLE_PATTERN );
    }

    @Override
    public String[] getCDRItem( CDRItem cdrItem )
        throws BGException
    {
        try
        {
        /*
            Разделитель – табуляция.
            Поля не заключаются в экранирующие кавычки.
         */
            String[] item = new String[17];
            item[0] = regionId; //идентификатор оператора связи или филиала (регион) (число);
            item[1] = TimeUtils.formatFullDate( cdrItem.startTime ); //дата и время начала соединения;
            item[2] = String.valueOf( cdrItem.duration ); //длительность, сек (число);
            item[3] = "1"; //тип вызова (справочник типов вызовов) (число);
            item[4] = getServiceId(); //ДВО (справочник список ДВО) (число);
            item[5] = isOurNumber( cdrItem.callingNumber ) ? "0" : "1"; //тип вызывающего абонента (0 - абонент данного коммутатора, 1 - абонент сети связи);
            item[6] = isOurNumber( cdrItem.callingNumber ) ? "0" : "1"; //тип вызываемого абонента (0 - абонент данного коммутатора, 1 - абонент сети связи);
            item[7] = String.valueOf( cdrItem.deviceId ); //код АТС/коммутатора/MGW обслужившего вызов (код по справочнику коммутатора, обслужившего соединение) (строка);
            item[8] = Utils.maskBlank( cdrItem.fromPort, "1"); //входящая транковая группа (код по справочнику пучков соединительных линий) (число);
            item[9] = Utils.maskBlank( cdrItem.toPort, "1"); //исходящая транковая группа (код по справочнику пучков соединительных линий) (число);
            item[10] = "16"; //причина разъединения соединения (код по справочнику причин завершения соединений) (число);
            item[11] = cdrItem.callingNumber; //идентификатор вызывающего абонента (Абонент - А) (строка);
            // если звонящий не наш абонент, то поле пустое
            item[12] = cdrItem.callingNumber; //внутренний номер вызывающего абонента (Абонент А) (строка);
            item[13] = cdrItem.calledNumber; //набранный номер вызываемого абонента (набранный Абонентом А номер для вызова Абонента Б) (строка);
            item[14] = cdrItem.calledNumber; //идентификатор вызываемого абонента (Абонент - Б) (строка);
            item[15] = cdrItem.calledNumber; //внутренний номер вызываемого абонента (Абонент Б) (строка);
            item[16] = ""; //телефонный номер при переадресации (строка).
            return item;
        }
        catch( Exception e )
        {
            throw new BGException( e );
        }
    }

    @Override
    public String[] getHeader()
    {
        return null;
    }
}