/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.pscb.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.pscb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.pscb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.pscb.server.bean.Constants;
import ru.bitel.bgbilling.modules.pscb.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u041f\u0421\u041a\u0411")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("pscb");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransactions((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Transaction pscbTransaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(this.contractId)).setStatus(TransactionStatus.NEW.getCode())).setSum(this.sum)).build();
        new TransactionManager(this.con, this.moduleId).update(pscbTransaction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436 pscb \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. \u041a\u043e\u0434 {}", (Object)pscbTransaction.getId());
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
        }
        DecimalFormat orderIdFormat = new DecimalFormat(this.moduleSetup.get("pscb.order.id.format", "BG00000000"));
        HashMap<String, Object> messageParamMap = new HashMap<String, Object>();
        messageParamMap.put("nonce", Utils.randomAlphanumeric((int)10));
        messageParamMap.put("customerAccount", "cid_" + this.contractId);
        messageParamMap.put("custometRating", "5");
        messageParamMap.put("orderId", orderIdFormat.format(pscbTransaction.getId()));
        messageParamMap.put("showOrderId", orderIdFormat.format(pscbTransaction.getId()));
        messageParamMap.put("details", this.moduleSetup.get("pscb.details", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
        messageParamMap.put("amount", Utils.formatBigDecimalSumm((BigDecimal)this.sum));
        messageParamMap.put("successUrl", this.moduleSetup.get("pscb.success.url", ""));
        messageParamMap.put("failUrl", this.moduleSetup.get("pscb.fail.url", ""));
        ObjectMapper mapper = new ObjectMapper();
        String jsonParams = mapper.writeValueAsString(messageParamMap);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432 \u0432\u0438\u0434\u0435 json: \n{}", (Object)jsonParams);
        }
        String sign = Utils.getDigest((String)(jsonParams + this.moduleSetup.get("pscb.secret.key", "")), (String)"UTF-8", (String)"SHA-256");
        String base64Message = Base64.encode((String)jsonParams, (String)"UTF-8");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432 \u0432\u0438\u0434\u0435 base64: \n{}", (Object)base64Message);
        }
        String serverUrl = this.moduleSetup.get("pscb.server.url", null);
        String merchantId = this.moduleSetup.get("pscb.merchant.id", null);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Url \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441 pscb: {}?marketPlace={}&message={}&signature={}", new Object[]{serverUrl, merchantId, jsonParams, sign});
        }
        this.setResultParam("gateUrl", serverUrl);
        this.setResultParam("formFields", new String[]{"message", "marketPlace", "signature"});
        this.setResultParam("message", base64Message);
        this.setResultParam("marketPlace", merchantId);
        this.setResultParam("signature", sign);
    }
}

