/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemAttributeValueDao;
import ru.bitel.bgbilling.plugins.shop.server.dao.StockItemTypeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class StockItemDao
extends AbstractIdDao<StockItem> {
    private final StockItemTypeDao stockItemTypeDao;
    private final StockItemAttributeValueDao stockItemAttributeValueDao;

    public StockItemDao(Connection con, int moduleId) {
        super(con, moduleId, "stock_item");
        this.stockItemTypeDao = new StockItemTypeDao(con, moduleId);
        this.stockItemAttributeValueDao = new StockItemAttributeValueDao(con, moduleId, new StockItemAttributeDao(con, moduleId));
    }

    protected StockItem getFromRS(ResultSet rs) throws SQLException, BGException {
        StockItem stockItem = new StockItem();
        stockItem.setId(rs.getInt("id"));
        stockItem.setTitle(rs.getString("title"));
        stockItem.setWarehouseId(rs.getInt("warehouse_id"));
        stockItem.setType((StockItemType)this.stockItemTypeDao.get(rs.getInt("stock_item_type_id")));
        stockItem.setAttributeValues(this.stockItemAttributeValueDao.getValuesByStockItem(stockItem.getId()));
        stockItem.setContractId(rs.getInt("contract_id"));
        return stockItem;
    }

    protected void updateImpl(StockItem stockItem) throws BGException, SQLException {
        boolean isNew = stockItem.getId() <= 0;
        String prefix = isNew ? "INSERT INTO " : "UPDATE ";
        String query = prefix + this.tableName + " SET title=?, warehouse_id=?, stock_item_type_id=?, contract_id=?" + (isNew ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, stockItem.getTitle());
            ps.setInt(2, stockItem.getWarehouseId());
            ps.setInt(3, stockItem.getType().getId());
            ps.setInt(4, stockItem.getContractId());
            if (!isNew) {
                ps.setInt(5, stockItem.getId());
            }
            ps.executeUpdate();
            if (isNew) {
                stockItem.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
    }

    public void getStockItemsByWarehouseAndType(SearchResult<StockItem> searchResult, int warehouseId, int stockItemTypeId) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE warehouse_id=?";
        if (stockItemTypeId > 0) {
            query = query + " AND stock_item_type_id=? ";
        }
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, warehouseId);
            if (stockItemTypeId > 0) {
                ps.setInt(2, stockItemTypeId);
            }
            new AbstractDao.ResultSetIterator((AbstractDao)this, ps.executeQuery()).forEach(list::add);
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<StockItem> searchStockItemByValue(int warehouseId, int attributeId, String data) throws BGException {
        ArrayList<StockItem> result = new ArrayList<StockItem>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " LEFT JOIN stock_item_attribute_value AS val ON stock_item.id=val.stock_item_id WHERE warehouse_id=? AND val.attribute_id=? AND val.value LIKE ?");){
            ps.setInt(1, warehouseId);
            ps.setInt(2, attributeId);
            ps.setString(3, "%" + data + "%");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }
}

