/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ContractLimitLogManager
extends AbstractIdDao<ContractLimitLog> {
    public Map<String, String> fields = new HashMap<String, String>();

    public ContractLimitLogManager(Connection con) {
        super(con, 0, "log_contract_limit");
        this.fields.put("date", "dt");
    }

    public void searchContractLimitLog(SearchResult<ContractLimitLog> searchResult, int contractId) throws SQLException {
        ResultSet rs;
        Objects.requireNonNull(searchResult);
        Page page = searchResult.getPage();
        if (page == null) {
            page = new Page(1, Integer.MAX_VALUE);
            searchResult.setPage(page);
        }
        String[] sort = searchResult.getSort();
        Period period = searchResult.getPeriod();
        List list = searchResult.getList();
        StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" WHERE true").append(this.queryPeriod(period, "dt"));
        if (contractId > 0) {
            query.append(" AND cid=").append(contractId);
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*)" + query.toString());){
            this.psSetPeriod(ps, 1, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (page.getPageIndex() > page.getPageCount()) {
            page.setPageIndex(page.getPageCount());
        }
        ps = this.con.prepareStatement("SELECT *" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
        try {
            this.psSetPeriod(ps, 1, period);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void addContractLimitLog(ContractLimitLog contractLimitLog) throws SQLException {
        String query = "INSERT INTO " + this.tableName + " SET dt=NOW(), uid=?, nvalue=?, cid=?, comment=?, days=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractLimitLog.getUserId());
            ps.setBigDecimal(2, contractLimitLog.getLimitValue());
            ps.setInt(3, contractLimitLog.getContractId());
            ps.setString(4, contractLimitLog.getComment() != null ? contractLimitLog.getComment() : "");
            ps.setInt(5, contractLimitLog.getDays());
            ps.executeUpdate();
        }
    }

    public void deleteContractLimitLog(int contractId, int userId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cid=? AND uid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, userId);
            ps.executeUpdate();
        }
    }

    protected ContractLimitLog getFromRS(ResultSet rs) throws SQLException {
        int userId = rs.getInt("uid");
        return ContractLimitLog.builder().setContractId(rs.getInt("cid")).setDate(rs.getTimestamp("dt")).setUserId(userId).setUserName(Optional.ofNullable(UserMap.getUser(userId)).map(a -> a.getName()).orElse("??? [#" + userId + "]")).setLimitValue(rs.getBigDecimal("nvalue")).setComment(rs.getString("comment")).setDays(Utils.parseInt((String)rs.getString("days"))).build();
    }

    protected void updateImpl(ContractLimitLog contractLimitLog) throws SQLException {
    }
}

