/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.vidimax.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.vidimax.server.bean.Card;

public class CardManager {
    private Connection con;
    private String tableName;

    public CardManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "vidimax_cards_" + mid;
    }

    public Card getCard(long code) throws BGException {
        Card card = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                card = this.getCardFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return card;
    }

    private Card getCardFromRS(ResultSet rs) throws SQLException {
        Card card = new Card();
        card.setCode(rs.getLong("code"));
        card.setContractId(rs.getInt("cid"));
        card.setPin(rs.getString("pin"));
        return card;
    }

    public int getContractIdByCode(long code) throws BGException {
        int contractId = 0;
        try {
            String query = "SELECT cid FROM " + this.tableName + " WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                contractId = rs.getInt("contractId");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return contractId;
    }
}

