/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.warehouse;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.AbstractOperationPanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationEntry;
import ru.bitel.bgbilling.plugins.shop.common.bean.WarehouseOperationType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.SearchResult;

public class WarehouseOperationHistoryPanel
extends AbstractOperationPanel<WarehouseOperationEntry> {
    private final JTextField contractId = new JTextField(10);
    private final JTextField userId = new JTextField(10);
    private final JTextField warehouseId = new JTextField(10);
    private final BGUComboBox<GuiTitlable> operationType = new BGUComboBox();
    private final JButton search = new JButton("\u041f\u043e\u0438\u0441\u043a");

    public WarehouseOperationHistoryPanel() {
        super(new HistoryTableModel());
    }

    @Override
    protected void jbInit() throws Exception {
        super.add((Component)this.getSearchParametersPanel(), (Object)new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 0), 0, 0));
        super.jbInit();
        ArrayList<Object> operationTypeData = new ArrayList<Object>();
        operationTypeData.add(() -> "----------------");
        operationTypeData.addAll(Arrays.asList(WarehouseOperationType.values()));
        this.operationType.setData(operationTypeData);
        this.search.addActionListener(e -> {
            try {
                this.search();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    private JPanel getSearchParametersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        panel.add((Component)new JLabel("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), constraints);
        panel.add((Component)this.contractId, constraints);
        panel.add((Component)new JLabel("ID \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"), constraints);
        panel.add((Component)this.userId, constraints);
        panel.add((Component)new JLabel("ID \u0441\u043a\u043b\u0430\u0434\u0430"), constraints);
        panel.add((Component)this.warehouseId, constraints);
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"), constraints);
        panel.add((Component)this.operationType, constraints);
        panel.add((Component)this.search, constraints);
        return panel;
    }

    @Override
    protected void refreshImpl(ClientContext context) throws Exception {
        ((HistoryTableModel)this.tableModel).setClientContext(context);
        this.search();
    }

    private void search() throws Exception {
        SearchResult searchResult = new SearchResult(this.periodPanel.getPeriod(), this.page.getPage());
        searchResult.setAttribute("userId", this.userId.getText());
        searchResult.setAttribute("contractId", this.contractId.getText());
        searchResult.setAttribute("warehouseId", this.warehouseId.getText());
        GuiTitlable guiTitlable = this.operationType.getSelectedItem();
        if (guiTitlable instanceof WarehouseOperationType) {
            WarehouseOperationType type = (WarehouseOperationType)guiTitlable;
            searchResult.setAttribute("operationType", String.valueOf(type.ordinal()));
        }
        searchResult = this.getWarehouseOperationService().warehouseOperationList(searchResult);
        this.tableModel.setData(searchResult.getList());
        this.page.setPage(searchResult.getPage());
        this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
    }

    private static final class HistoryTableModel
    extends BGTableModel<WarehouseOperationEntry> {
        private Directory<UserInfo> directory;
        private ClientContext context;

        public HistoryTableModel() {
            super("warehouseHistoryTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 50, -1, "contractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0441\u043a\u043b\u0430\u0434\u0430", -1, 200, -1, "warehouseFromId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0441\u043a\u043b\u0430\u0434\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", -1, 200, -1, "warehouseToId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ID \u0442\u043e\u0432\u0430\u0440\u0430", -1, 200, -1, "stockItemId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u0442\u043e\u0432\u0430\u0440\u0430", -1, 200, -1, "stockItemTypeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", -1, 200, -1, "operationType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412\u0440\u0435\u043c\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", -1, 200, -1, "operationTime", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, 200, -1, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValueAt(WarehouseOperationEntry val, int column) throws Exception {
            if (this.directory == null && this.context != null) {
                this.directory = this.context.getDirectory(UserInfo.class);
            }
            switch (column) {
                case 5: {
                    return Utils.maskNull((String)val.getStockItemTypeTitle());
                }
                case 6: {
                    return val.getOperationType().getDescription();
                }
                case 7: {
                    return val.getOperationType() != null ? TimeUtils.format((Date)val.getTime(), (String)"dd.MM.yyyy HH:mm") : "";
                }
                case 8: {
                    UserInfo userInfo = this.directory != null ? (UserInfo)this.directory.get(val.getUserId()) : null;
                    return userInfo != null ? userInfo.getName() + "[" + userInfo.getId() + "]" : "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
            }
            return super.getValueAt((Object)val, column);
        }

        private void setClientContext(ClientContext context) {
            this.context = context;
        }
    }
}

