<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'DistributeBalance'">Распределение средств</xsl:when>
	<xsl:when test="data/@action = 'ChangeTariff'">Управление тарифными планами</xsl:when>
	<xsl:otherwise>НОВОСТИ</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:variable name="tarifQuestion" select="'Вы уверены что хотите сменить тариф? '"/>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'DistributeBalance'">
		<xsl:call-template name="DistributeBalance"/>
	</xsl:when>
	<xsl:when test="@action = 'ChangeTariff'">		
	 	<xsl:call-template name="ChangeTariff"/>
	</xsl:when>
</xsl:choose>
</xsl:template>

<!-- распределение средств -->
<xsl:template name="DistributeBalance">
	<form method='post' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>
		
	<input type="hidden" name="commit" value="1"/>
	<table class="filter">
	  <tr>
		<td>Свободные средства: <b><xsl:value-of select="format-number( free/@amount, '### ##0.00', 'summa')"/></b></td>
	  </tr>
	</table>
	
	<table class="layout">
		<tr><td colspan="2">
			<table class="table tableWidth">
				<thead>
					<tr>
						<td style="width: 150px;">Договор</td>
						<td>Примечание</td>
						<td style="width: 150px;">Баланс\сальдо</td>
						<td style="width: 100px;">Сумма</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="/data/subs/sub">
						<tr>
							<td><xsl:value-of select="@title"/></td>
							<td><xsl:value-of select="@comment"/></td>
							<td><xsl:value-of select="@debt"/></td>
							<td><input type="text" size="10" style="text-align: center;">
									<xsl:attribute name="name">
										<xsl:value-of select="@cid"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</td></tr>
		<tr class="foot">
		<td style="text-align: left;">
			<button type="button" onclick="document.location='{$WEBEXECUTER}?action=GetBalance&amp;mid=0&amp;module=contract&amp;contractId={$CONTRACT_ID}'">Назад, к просмотру баланса</button>
		</td>
		<td>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Распределить'"/>
				<xsl:with-param name="align" select="'right'"/>
			</xsl:call-template>
		</td></tr>
	</table>	
	</form>
</xsl:template>


<!-- смена тарифных планов -->
<xsl:template name="ChangeTariff">
	<table class="table800">
		<thead>
		  <tr>
		  	<td>Тарифный план</td>
		  	<td>С даты</td>
		  	<td>По дату</td>
		  	<td>Сменить</td>
		  </tr>
		 </thead>
		 <tbody>
		  <xsl:for-each select="/data/history/row">
			<tr>
				<td><font>
				<xsl:if test="@active=0">
					<xsl:attribute name="color">#8e8e8e</xsl:attribute>
				</xsl:if><xsl:value-of select="@tariff"/><xsl:if test="@type=1"> (персональный)</xsl:if></font></td>
				<td><xsl:value-of select="@date1"/></td>
				<td><xsl:value-of select="@date2"/></td>
				<td>
					<xsl:if test="@group">
						<form method='get' action='{$WEBEXECUTER}'>
							<xsl:call-template name="action"/>
							<input type="hidden" name="command" value="change"/>
							<input type="hidden" name="from_tariff"><xsl:attribute name="value"><xsl:value-of select="@contractTariffId"/></xsl:attribute></input>
							<input type="hidden" name="step"><xsl:attribute name="value"><xsl:value-of select="/data/@step"/></xsl:attribute></input>
							<table class="layout"><tr>
								<xsl:choose>
									<xsl:when test="/data/@step=0">
										<td nowrap="1" style="border: 0px;">Перейти на тариф: <select name="to_tariff"><option value="-1">---</option><xsl:for-each select="tariff_list/item" >
													<option value="{@id}"><xsl:value-of select="@title"/></option>
												</xsl:for-each>			
											</select>
										</td>
										<td style="border: 0px;">
											<xsl:call-template name="submit">				
												<xsl:with-param name="title" select="'Выбрать дату'"/>
											</xsl:call-template>
										</td>
									</xsl:when>
									<xsl:when test="/data/@step=1">
										<xsl:if test="@tariffId=/data/@from_tariff">
											<td nowrap="1" style="border: 0px;">	
											<input type="hidden" name="to_tariff"><xsl:attribute name="value"><xsl:value-of select="/data/@to_tariff"/></xsl:attribute></input>	Перейти на тариф: <b><xsl:value-of select="/data/@to_tariff_title"/></b> с даты: <select name="from_date">
													<xsl:for-each select="date_list/item">
														<option>
															<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
															<xsl:value-of select="@value"/>
														</option>
													</xsl:for-each>
												</select>
											</td>
											<td style="border: 0px;">
												<xsl:call-template name="submit">				
													<xsl:with-param name="title" select="'Сменить тариф'"/>
													<xsl:with-param name="confirm" select="'Вы уверены, что хотите сменить тариф?'"/>
												</xsl:call-template>
											</td>
										</xsl:if>
									</xsl:when>		
								</xsl:choose>
							</tr></table>
						</form>
					</xsl:if>
					<xsl:if test="@canCancel=1">
						<form method='post' action='{$WEBEXECUTER}'>
							<xsl:call-template name="action"/>
							<input type="hidden" name="command" value="cancel"/>
							<input type="hidden" name="contractTariffId" value="{@contractTariffId}"/>
							
							<div style="float: left;">
								Предыдущий тариф: "<xsl:value-of select="@previousTariffTitle"/>"
							</div>
							<div style="float: left; padding-left: 10px;">
								<xsl:call-template name="submit">
									<xsl:with-param name="title" select="'Отменить переход'"/>
									<xsl:with-param name="confirm" select="'Вы уверены, что хотите отменить переход на тариф?'"/>
								</xsl:call-template>
							</div>
						</form>
					</xsl:if>
				</td>
			</tr>
		  </xsl:for-each>
		  </tbody>	
	</table>		
	
	<em class="comment">Серым цветом выделены неактивные тарифные планы.</em>
	
</xsl:template>

</xsl:stylesheet>
