/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.model.IdTitle;

public class PacketGroupTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"filter.gif");
    private JLabel view;
    private Directory packetDir;
    private List<Integer> values = new ArrayList<Integer>();
    private JPanel editor;
    private BGControlPanelListSelect packets;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.packetDir = this.getDirManager().getDirectory("packets");
    }

    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    public Component getEditor() throws Exception {
        if (this.editor == null) {
            this.editor = new JPanel(new GridBagLayout());
            this.editor.setMinimumSize(new Dimension(400, 500));
            this.editor.setPreferredSize(new Dimension(400, 500));
            this.packets = new BGControlPanelListSelect();
            for (IdTitle di : this.packetDir.getItems()) {
                this.packets.getListModel().addElement(new BGUListItem(di.getId(), di.getTitle()));
            }
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    this.serializeData();
                    this.saveData();
                }
                this.tree.getViewableTree().stopEditing();
            });
            this.editor.add((Component)new JLabel("\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.packets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return this.editor;
    }

    protected void loadData() throws Exception {
        this.extractData();
        this.getEditor();
        this.packets.setListValues(Utils.toString(this.values));
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("packets", this.packets.getListValues());
        this.setDataInHash(data);
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this.extractData();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\u0411\u0430\u0437\u043e\u0432\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b:");
        for (Integer code : this.values) {
            String packetTitle = this.packetDir.getValue(code.intValue());
            if (packetTitle == null) continue;
            sb.append("<br>");
            sb.append(packetTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.values.clear();
        this.values.addAll(Utils.toIntegerList((String)((String)data.get("packets"))));
    }
}

