/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.card.common.bean.DealerPayment;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;

public class DealerPaymentDao
extends AbstractDao<DealerPayment> {
    private ContractDao contractDao;

    public DealerPaymentDao(Connection con, int mid, java.util.Date date) {
        super(con, mid, "card_dealer_pay", date);
        this.contractDao = new ContractDao(con, 0);
    }

    public Result<DealerPayment> list(Set<Integer> dealerIds, java.util.Date dateFrom, java.util.Date dateTo, int type, String trans, String contract, long contractGroups, List<FilterEntityAttr> contractFilter, Page page) throws BGException {
        try {
            BigDecimal total = BigDecimal.ZERO;
            int number = 0;
            BigDecimal payedTotal = BigDecimal.ZERO;
            int payedNumber = 0;
            if (!ServerUtils.tableExists((Connection)this.con, (String)this.tableName)) {
                if (page != null) {
                    page.setRecordCount(0);
                }
                Result result = new Result(new ArrayList(), page);
                result.setAttribute("count", (Object)number);
                result.setAttribute("total", (Object)total);
                return result;
            }
            if (dateFrom == null) {
                dateFrom = new java.util.Date();
            }
            contractFilter = this.contractDao.filterInit(contractFilter);
            Date dateFromSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
            Date dateToSql = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
            StringBuilder query = new StringBuilder();
            query.append(" FROM ").append(this.tableName).append(" as pay");
            query.append(" LEFT JOIN contract_payment ON contract_payment.id=pay.pid");
            query.append(" INNER JOIN contract ON contract.id=pay.cid");
            query.append(" LEFT JOIN card_dealer_").append(this.moduleId).append(" as dealer ON dealer.id=pay.did");
            StringBuilder where = new StringBuilder().append(" WHERE ");
            if (dealerIds != null && dealerIds.size() > 0) {
                where.append("pay.did IN (").append(Utils.toString(dealerIds)).append(") AND");
            }
            where.append(" (? IS NULL OR TO_DAYS(pay.dt)>=TO_DAYS(?))");
            where.append(" AND (? IS NULL OR TO_DAYS(pay.dt)<=TO_DAYS(?))");
            where.append(" AND (? OR pay.status!=1) AND (? OR pay.status=1) AND (? OR contract_payment.id IS NULL)");
            where.append(" AND (? OR UPPER(pay.trans) REGEXP ?)");
            where.append(" AND (? OR UPPER(contract.title) REGEXP ?)");
            where.append(" AND (? OR contract.gr&?=?)");
            this.contractDao.filterJoin(query, " AND", where, contractFilter);
            query.append((CharSequence)where);
            PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(pay.id), SUM(pay.summ)" + String.valueOf(query));
            ps.setDate(1, dateFromSql);
            ps.setDate(2, dateFromSql);
            ps.setDate(3, dateToSql);
            ps.setDate(4, dateToSql);
            if (type == 1) {
                ps.setBoolean(5, true);
                ps.setBoolean(6, false);
                ps.setBoolean(7, true);
            } else if (type == 0) {
                ps.setBoolean(5, false);
                ps.setBoolean(6, true);
                ps.setBoolean(7, true);
            } else if (type == -1) {
                ps.setBoolean(5, true);
                ps.setBoolean(6, false);
                ps.setBoolean(7, false);
            } else {
                ps.setBoolean(5, true);
                ps.setBoolean(6, true);
                ps.setBoolean(7, true);
            }
            if (Utils.isBlankString((String)trans)) {
                ps.setBoolean(8, true);
                ps.setString(9, null);
            } else {
                ps.setBoolean(8, false);
                ps.setString(9, trans.toUpperCase());
            }
            if (Utils.isBlankString((String)contract)) {
                ps.setBoolean(10, true);
                ps.setString(11, null);
            } else {
                ps.setBoolean(10, false);
                ps.setString(11, contract.toUpperCase());
            }
            ps.setBoolean(12, contractGroups == 0L);
            ps.setLong(13, contractGroups);
            ps.setLong(14, contractGroups);
            this.contractDao.filterToPS(ps, 14, contractFilter);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                number = rs.getInt(1);
                total = Utils.maskNull((BigDecimal)rs.getBigDecimal(2));
            }
            if (type == 1) {
                payedNumber = number;
                payedTotal = total;
            } else {
                rs.close();
                ps.setBoolean(5, true);
                ps.setBoolean(6, false);
                ps.setBoolean(7, true);
                rs = ps.executeQuery();
                if (rs.next()) {
                    payedNumber = rs.getInt(1);
                    payedTotal = Utils.maskNull((BigDecimal)rs.getBigDecimal(2));
                }
            }
            rs.close();
            ps.close();
            if (page != null) {
                page.setRecordCount(number);
            }
            query = new StringBuilder("SELECT pay.*, dealer.title, contract_payment.id, contract_payment.comment, contract_payment.pt,  contract.title as contract_title, contract.comment as contract_comment" + String.valueOf(query));
            query.append(" ORDER BY pay.id").append(this.sqlLimit(page));
            ps = this.con.prepareStatement(query.toString());
            ps.setDate(1, dateFromSql);
            ps.setDate(2, dateFromSql);
            ps.setDate(3, dateToSql);
            ps.setDate(4, dateToSql);
            if (type == 1) {
                ps.setBoolean(5, true);
                ps.setBoolean(6, false);
                ps.setBoolean(7, true);
            } else if (type == 0) {
                ps.setBoolean(5, false);
                ps.setBoolean(6, true);
                ps.setBoolean(7, true);
            } else if (type == -1) {
                ps.setBoolean(5, true);
                ps.setBoolean(6, false);
                ps.setBoolean(7, false);
            } else {
                ps.setBoolean(5, true);
                ps.setBoolean(6, true);
                ps.setBoolean(7, true);
            }
            if (Utils.isBlankString((String)trans)) {
                ps.setBoolean(8, true);
                ps.setString(9, null);
            } else {
                ps.setBoolean(8, false);
                ps.setString(9, trans.toUpperCase());
            }
            if (Utils.isBlankString((String)contract)) {
                ps.setBoolean(10, true);
                ps.setString(11, null);
            } else {
                ps.setBoolean(10, false);
                ps.setString(11, contract.toUpperCase());
            }
            ps.setBoolean(12, contractGroups == 0L);
            ps.setLong(13, contractGroups);
            ps.setLong(14, contractGroups);
            this.contractDao.filterToPS(ps, 14, contractFilter);
            ArrayList<DealerPayment> list = new ArrayList<DealerPayment>();
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            Result result = new Result(list, page);
            result.setAttribute("count", (Object)number);
            result.setAttribute("total", (Object)total);
            result.setAttribute("payedCount", (Object)payedNumber);
            result.setAttribute("payedTotal", (Object)payedTotal);
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected DealerPayment getFromRS(ResultSet rs) throws SQLException, BGException {
        DealerPayment result = new DealerPayment();
        result.setId(rs.getInt("id"));
        result.setDealerId(rs.getInt("did"));
        result.setDealerTitle(rs.getString("dealer.title"));
        result.setContractComment(rs.getString("contract_comment"));
        result.setContractId(rs.getInt("cid"));
        result.setContractTitle(rs.getString("contract_title"));
        result.setDateTime(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        result.setPaymentType(rs.getInt("contract_payment.pt"));
        result.setTransId(rs.getString("trans"));
        result.setPaymentComment(rs.getString("comment"));
        result.setPaymentId(rs.getInt("contract_payment.id"));
        result.setSumma(rs.getBigDecimal("summ"));
        result.setStatus(rs.getInt("status"));
        if (result.getStatus() == 1 && result.getPaymentId() == 0) {
            result.setStatus(-1);
        }
        return result;
    }

    protected void updateImpl(DealerPayment b) throws BGException, SQLException {
    }
}

