/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.list.renderer.IdTitleComboBoxCellRender;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.modules.license.client.ServicePropertiesPanel;
import ru.bitel.bgbilling.modules.license.client.contract.LicenceBGUTable;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ComponentsPanel
extends BGUPanel {
    private int copyId = -1;
    private ServicePropertiesPanel parent;
    private JComboBox<IdTitle> filterMode;
    private ComponentsTableModel tableModel = new ComponentsTableModel();
    private BGUPanel.WebServiceHolder<LicenseService> licenseService = new BGUPanel.WebServiceHolder((BGUPanel)this, LicenseService.class);

    public ComponentsPanel(ServicePropertiesPanel parentComponent) {
        this.parent = parentComponent;
    }

    public void setCopyId(int id) {
        this.copyId = id;
    }

    public void jbInit() {
        LicenceBGUTable copyItemsTable = new LicenceBGUTable((TableModel)((Object)this.tableModel), new String[]{"count"});
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)((Object)copyItemsTable)), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getTopPanel() {
        ActionListener actionListener = actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if ("test".equals(actionCommand)) {
                this.prolongOrders();
            } else if ("create".equals(actionCommand)) {
                this.createPackage();
            } else if ("mode".equals(actionCommand)) {
                this.performAction("refresh");
            }
        };
        this.filterMode = new JComboBox();
        this.filterMode.setActionCommand("mode");
        this.filterMode.addItem(new IdTitle(0, "\u0441 \u043d\u0430\u0438\u0431\u043e\u043b\u044c\u0448\u0438\u043c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e\u043c"));
        this.filterMode.addItem(new IdTitle(1, "\u0442\u043e\u043b\u044c\u043a\u043e \u043a\u0443\u043f\u043b\u0435\u043d\u043d\u044b\u0435"));
        this.filterMode.addItem(new IdTitle(2, "\u0432\u0441\u0435"));
        this.filterMode.addActionListener(actionListener);
        this.filterMode.setRenderer((ListCellRenderer<IdTitle>)new IdTitleComboBoxCellRender());
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.filterMode, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new BGButton("\u041f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0435", "test", actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e", "create", actionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.tryCall(() -> this.tableModel.setData(((LicenseService)this.licenseService.get()).confirmedOrderList(((ClientContext)this.getContext()).getContractId(), this.copyId, this.filterMode.getSelectedIndex()))));
    }

    private void createPackage() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.size() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0432\u043e\u0439\u0442\u0438 \u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.\n\u0414\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0437\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 Ctrl.", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 1);
            return;
        }
        ArrayList<String> productItemIdList = new ArrayList<String>();
        StringBuilder copyItemIds = new StringBuilder();
        for (int i = 0; i < rows.size(); ++i) {
            String productItemId = String.valueOf(((LicenseOrderConfirmed)rows.get(i)).getComponentId());
            if (productItemIdList.contains(productItemId)) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412 \u043e\u0434\u043d\u0443 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u044b \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432.", "\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435", 1);
                return;
            }
            productItemIdList.add(productItemId);
            copyItemIds.append(((LicenseOrderConfirmed)rows.get(i)).getIds());
            if (i >= rows.size() - 1) continue;
            copyItemIds.append(",");
        }
        this.tryCall(() -> this.parent.switchToPackagePane(((LicenseService)this.licenseService.get()).createPackage(((ClientContext)this.getContext()).getContractId(), this.copyId, Utils.toSet((String)copyItemIds.toString()))));
    }

    private void prolongOrders() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.size() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0435 \u0437\u0430\u043a\u0430\u0437\u044b, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0436\u0435\u043b\u0430\u0435\u0442\u0435 \u043f\u0440\u043e\u0434\u043b\u0438\u0442\u044c.\n\u0414\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0437\u0430\u0436\u043c\u0438\u0442\u0435 \u043a\u043b\u0430\u0432\u0438\u0448\u0443 Ctrl.", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 1);
            return;
        }
        GregorianCalendar todayCal = new GregorianCalendar();
        todayCal.set(11, 0);
        todayCal.set(12, 0);
        todayCal.set(13, 0);
        todayCal.set(14, 0);
        Date today = todayCal.getTime();
        BGCalendarButton calButton = new BGCalendarButton();
        calButton.setLocalDate(LocalDate.now());
        JPanel dialogPanel = new JPanel();
        dialogPanel.add(new JLabel("\u041f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438 \u0434\u043e "));
        dialogPanel.add((Component)calButton);
        int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), dialogPanel, "\u041f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438", 2, 3);
        if (result == 0) {
            if (today.after(calButton.getCalendar().getTime())) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u043e\u0434\u043b\u0438\u0442\u044c \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e \u0434\u043e \u043f\u0440\u043e\u0448\u0435\u0434\u0448\u0435\u0439 \u0434\u0430\u0442\u044b.", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f", 1);
                return;
            }
            this.tryCall(() -> {
                List ids = rows.stream().map(a -> Utils.parseInt((String)a.getIds())).collect(Collectors.toList());
                ((LicenseService)this.licenseService.get()).prolongTestOrders(((ClientContext)this.getContext()).getContractId(), calButton.getCalendar().getTime(), ids);
                this.performAction("refresh");
            });
        }
    }

    class ComponentsTableModel
    extends BGTableModel<LicenseOrderConfirmed> {
        public ComponentsTableModel() {
            super(ComponentsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u2116", 50, 50, 50, "index", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("IDS", 0, 0, 0, "ids", false);
            this.addColumn("PIID", 0, 0, 0, "componentId", false);
            this.addColumn("\u0422\u0438\u043f", 120, 120, 120, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 300, 300, 300, "componentName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "componentTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 120, 120, 120, "count", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", 120, 120, 120, "dateTo", true, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
        }

        public Object getValue(LicenseOrderConfirmed val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("index".equals(identifier)) {
                LicenseOrderConfirmed confirmedOrder;
                int index = 1;
                Iterator iterator = this.getRows().iterator();
                while (iterator.hasNext() && !(confirmedOrder = (LicenseOrderConfirmed)iterator.next()).equals((Object)val)) {
                    ++index;
                }
                return index;
            }
            if ("type".equals(identifier)) {
                String type = "";
                if (val.getType() == LicenseOrderType.TEST.getCode()) {
                    type = LicenseOrderType.TEST.getText();
                } else if (val.getType() == LicenseOrderType.BUY.getCode()) {
                    type = LicenseOrderType.BUY.getText();
                }
                return type;
            }
            if ("count".equals(identifier)) {
                String count = "";
                count = val.getCount() > 0 ? String.valueOf(val.getCount()) : "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e";
                return count;
            }
            return super.getValue((Object)val, column);
        }
    }
}

