/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.container.security.server.HttpAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ServiceAction;

class ModuleInfo {
    final Map<String, ModuleAction> moduleActionMap;
    private final List<HttpAction> httpActionList;
    private final Map<String, List<ServiceAction>> serviceActionMap;

    public ModuleInfo(Map<String, ModuleAction> moduleActionMap, List<HttpAction> webActionList, Map<String, List<ServiceAction>> serviceActionMap) {
        this.moduleActionMap = moduleActionMap;
        this.httpActionList = webActionList;
        this.serviceActionMap = serviceActionMap;
    }

    ModuleAction findAction(String service, String operation, Map<String, Object> args) {
        List<ServiceAction> actions = this.serviceActionMap.get(service);
        if (actions == null) {
            return null;
        }
        for (int i = 0; i < actions.size(); ++i) {
            ServiceAction action = actions.get(i);
            if (!action.isCoincide(operation, args)) continue;
            return action;
        }
        return null;
    }

    public ModuleAction findAction(HttpServletRequest request) {
        return this.httpActionList.stream().filter(httpAction -> httpAction.isCoincide(request)).findFirst().orElse(null);
    }

    public ModuleAction findAction(Map<String, String> requestMap) {
        return this.httpActionList.stream().filter(httpAction -> httpAction.isCoincide(requestMap)).findFirst().orElse(null);
    }
}

