/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;

public class EntityAttrIntCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private EntityAttrEntry value = null;

    public EntityAttrIntCellEditor() {
        super(new IntTextField());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = (EntityAttrEntry)value;
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.value == null) {
            return true;
        }
        String value = (String)this.getCellEditorValue();
        boolean isInt = false;
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
            isInt = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isInt) {
            this.value.setAttr(null);
        } else if (this.value.getAttr() == null) {
            this.value.setAttr((EntityAttr)new EntityAttrInt(this.value.getEntity().getEntityId(), this.value.getSpecAttr().getId(), intValue));
        } else {
            ((EntityAttrInt)this.value.getAttr()).setValue(intValue);
        }
        return super.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    static class IntTextField
    extends JTextField {
        public IntTextField() {
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkValue(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkValue(e);
                }
            });
        }

        private void checkValue(DocumentEvent e) {
        }
    }
}

