/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicSourceData;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.GeneratorOptions;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.RunMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.CodeGenerator;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.CustomTemplateDao;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptSavingEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService")
public class DynamicCodeServiceImpl
extends AbstractService
implements DynamicCodeService {
    private DynamicCodeDao dao;
    private CustomTemplateDao templateDao;

    @PostConstruct
    public void init() {
        this.dao = new DynamicCodeDao(this.getConnection());
        this.templateDao = new CustomTemplateDao(this.getConnection());
    }

    @Override
    public void updateSource(String className, String source) throws Exception {
        if (Utils.isBlankString(className)) {
            throw new BGMessageException("\u041f\u0443c\u0442\u043e\u0435 \u0438\u043c\u044f \u043a\u043b\u0430\u0441\u0441\u0430!");
        }
        DynamicCodeDao.updateClassSource(className, source);
    }

    @Override
    public CompilationResult recompileAll() throws Exception {
        List<String> classNames = this.dao.getDynamicClasses().stream().map(f -> f.getClassName()).collect(Collectors.toList());
        return EventProcessor.getInstance().request(new ScriptSavingEvent(classNames, true)).getCompilationResult();
    }

    @Override
    public String getSource(String className) throws Exception {
        File file = DynamicCodeDao.getClassFile(className);
        if (!file.exists() || !file.isFile()) {
            throw new BGMessageException("\u041a\u043b\u0430\u0441\u0441 \"" + className + "\" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return Files.readString(file.toPath());
    }

    @Override
    public DynamicSourceData getSourceData(String className) throws Exception {
        DynamicSourceData dynamicSourceData = new DynamicSourceData();
        dynamicSourceData.setClassName(className);
        dynamicSourceData.setBase64Bytes(Base64.getEncoder().encodeToString(new DynamicCodeDao(this.getConnection()).getClassData(className)));
        return dynamicSourceData;
    }

    @Override
    public List<DynamicClass> getDynamicClasses() throws Exception {
        DynamicClassManager classManager = DynamicClassManager.getInstance();
        List<DynamicClass> result = this.dao.getDynamicClasses();
        for (DynamicClass dynamicClass : result) {
            try {
                Class<?> clazz = classManager.loadClass(dynamicClass.getClassName());
                dynamicClass.setAnnotations(clazz);
            }
            catch (Exception clazz) {
            }
            catch (Throwable t) {
                this.getLogger().error("error get dynamic class (" + dynamicClass.getClassName() + ")", t);
            }
        }
        return result;
    }

    @Override
    public List<String> getClassNamesByInterface(String ifaceName) throws Exception {
        return this.dao.getActualClassesByInterface(ifaceName);
    }

    @Override
    public List<DynamicClass> getDynamicClassesByInterface(String ifaceName) throws Exception {
        DynamicClassManager classManager = DynamicClassManager.getInstance();
        ArrayList<DynamicClass> result = new ArrayList<DynamicClass>();
        List<String> classNames = this.dao.getActualClassesByInterface(ifaceName);
        for (String className : classNames) {
            try {
                Class<?> clazz = classManager.loadClass(className);
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                DynamicClass dynamicClass = DynamicClass.builder().setClassName(className).setAnnotations(clazz).build();
                result.add(dynamicClass);
            }
            catch (Exception ex) {
                this.getLogger().error("Dynamic class NoClassDefFoundError: {}", (Object)className);
                this.logError(ex);
            }
        }
        return result;
    }

    @Override
    public CompilationResult compile(String className) throws Exception {
        ScriptSavingEvent event = EventProcessor.getInstance().request(new ScriptSavingEvent(Collections.singletonList(className), false));
        return event.getCompilationResult();
    }

    @Override
    public CompilationResult deleteClasses(String ... classNames) throws Exception {
        for (String className : classNames) {
            DynamicCodeDao.backupAndDelete(className);
        }
        CompilationResult result = this.recompileAll();
        if (result.getErrors().size() > 0) {
            for (String className : classNames) {
                DynamicCodeDao.restoreSourcesFromBackup(className);
            }
        } else {
            for (String className : classNames) {
                DynamicCodeDao.deleteSourcesBackup(className);
                this.dao.deleteClassFromDb(className);
            }
        }
        return result;
    }

    @Override
    public CompilationResult deleteFiles(String ... classNames) throws Exception {
        for (String className : classNames) {
            DynamicCodeDao.backupAndDelete(className);
        }
        return new CompilationResult();
    }

    @Override
    public String generateCode(GeneratorOptions options) throws Exception {
        return new CodeGenerator(options).generateCode();
    }

    @Override
    public boolean isClassExists(String className) throws Exception {
        return DynamicCodeDao.getClassFile(className).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RunMessage> run(String className, String[] parameters) throws Exception {
        final ArrayList<RunMessage> result = new ArrayList<RunMessage>();
        if (parameters == null) {
            parameters = new String[]{};
        }
        final PrintStream originalOut = System.out;
        PrintStream filterOut = new PrintStream(new OutputStream(this){
            private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    originalOut.write(b);
                    this.bos.write(b);
                }
            }

            @Override
            public void flush() throws IOException {
                originalOut.flush();
                if (this.bos.size() > 0) {
                    result.add(new RunMessage(this.bos.toString(), RunMessage.RunMessageType.OUT));
                    this.bos.reset();
                }
            }
        }, true);
        final PrintStream originalErr = System.err;
        PrintStream filterErr = new PrintStream(new OutputStream(this){
            private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int b) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    originalErr.write(b);
                    this.bos.write(b);
                }
            }

            @Override
            public void flush() throws IOException {
                originalErr.flush();
                if (this.bos.size() > 0) {
                    result.add(new RunMessage(this.bos.toString(), RunMessage.RunMessageType.ERR));
                    this.bos.reset();
                }
            }
        }, true);
        try {
            System.setOut(filterOut);
            System.setErr(filterErr);
            Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
            result.add(new RunMessage("load class " + clazz.getCanonicalName() + "\n", RunMessage.RunMessageType.INFO));
            try {
                Method methot1 = clazz.getMethod("execute", Setup.class, ConnectionSet.class);
                result.add(new RunMessage("get method " + methot1.toString() + "\n", RunMessage.RunMessageType.INFO));
                Object objekt = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                result.add(new RunMessage("new instance " + objekt.toString() + "\n", RunMessage.RunMessageType.INFO));
                try {
                    clazz.getMethod("setOutputStream", PrintStream.class).invoke(objekt, filterOut);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    clazz.getMethod("setErrorStream", PrintStream.class).invoke(objekt, filterErr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                methot1.invoke(objekt, this.getSetup(), this.getConnectionSet());
            }
            catch (NoSuchMethodException e1) {
                try {
                    Method methot2 = clazz.getMethod("main", String[].class);
                    result.add(new RunMessage("get method " + methot2.toString() + "\n", RunMessage.RunMessageType.INFO));
                    methot2.invoke(null, new Object[]{parameters});
                }
                catch (NoSuchMethodException e2) {
                    result.add(new RunMessage("need a method \"execute(Setup,ConnectionSet)\" or \"static main(String[])\" to run\n", RunMessage.RunMessageType.ERR));
                }
            }
            catch (InvocationTargetException ex) {
                ex.getTargetException().printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            filterOut.flush();
            filterErr.flush();
            System.setOut(originalOut);
            System.setErr(originalErr);
        }
        return result;
    }

    @Override
    public void getDynJar(boolean common, Holder<DataHandler> data) throws Exception {
        DynamicCodeDao dynamicCodeDao = new DynamicCodeDao(this.getConnection());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jarOutputStream = new JarOutputStream(baos);
        JarEntry entry = new JarEntry("META-INF/");
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.closeEntry();
        entry = new JarEntry("META-INF/MANIFEST.MF");
        jarOutputStream.putNextEntry(entry);
        jarOutputStream.write("Manifest-Version: 1.0\nImplementation-Title: BGBilling Dyn\n".getBytes("UTF-8"));
        jarOutputStream.closeEntry();
        for (Pair<String, byte[]> dynamicClass : dynamicCodeDao.getClassData()) {
            byte[] classData;
            Class<?> clazz;
            if (common && (clazz = DynamicClassManager.getInstance().loadClass(dynamicClass.getFirst())).isAnnotationPresent(WebService.class) && !clazz.isInterface() || (classData = dynamicClass.getSecond()) == null) continue;
            entry = new JarEntry(dynamicClass.getFirst().replaceAll("\\.", "/") + ".class");
            jarOutputStream.putNextEntry(entry);
            jarOutputStream.write(classData);
            jarOutputStream.closeEntry();
        }
        jarOutputStream.close();
        jarOutputStream = null;
        final byte[] result = baos.toByteArray();
        baos = null;
        data.value = new DataHandler(new DataSource(){

            public String getContentType() {
                return "application/java-archive";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(result);
            }

            public String getName() {
                return "bgbilling-dyn.jar";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        });
    }

    @Override
    public void updateTemplate(CustomTemplate customTemplate) throws Exception {
        customTemplate.setUserId(this.userId);
        this.templateDao.update(customTemplate);
    }

    @Override
    public CustomTemplate getTemplateById(int id) throws Exception {
        return (CustomTemplate)this.templateDao.get(id);
    }

    @Override
    public SearchResult<CustomTemplate> getTemplateList(Page page) throws Exception {
        SearchResult<CustomTemplate> searchResult = new SearchResult<CustomTemplate>(page);
        searchResult.setList(new ArrayList());
        this.templateDao.getList(searchResult);
        return searchResult;
    }

    @Override
    public void deleteTepmlate(int id) throws Exception {
        this.templateDao.delete(id);
    }
}

